/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.util.collect;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class MultiMap<K, V, T extends Collection<V>> {
    protected final Map<K, T> map;
    private final Function<K, T> collectionMappingFunction;

    public MultiMap(Supplier<T> collectionSupplier) {
        this(new HashMap(), collectionSupplier);
    }

    public MultiMap(Map<K, T> map, Supplier<T> collectionSupplier) {
        this.map = map;
        this.collectionMappingFunction = k -> (Collection)collectionSupplier.get();
    }

    public T get(K key) {
        return (T)((Collection)this.map.computeIfAbsent(key, this.collectionMappingFunction));
    }

    public boolean put(K key, V value) {
        return this.get(key).add(value);
    }

    public boolean contains(K key, V value) {
        return this.get(key).contains(value);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        for (Collection values : this.map.values()) {
            if (values.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

