/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.TankInfo;
import binnie.core.util.NBTUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ComponentTankContainer
extends MachineComponent
implements ITankMachine {
    private static final String TANKS_KEY = "liquidTanks";
    private static final String TANK_INDEX_KEY = "index";
    private final Map<Integer, TankSlot> tanks = new LinkedHashMap<Integer, TankSlot>();
    private final EnumMap<EnumFacing, IFluidHandler> handlers = new EnumMap(EnumFacing.class);
    private final IFluidHandler noFacingHandler;

    public ComponentTankContainer(IMachine machine) {
        super(machine);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.handlers.put(facing, new TankContainer(this, this.tanks, facing));
        }
        this.noFacingHandler = new TankContainer(this, this.tanks, null);
    }

    @Override
    public final TankSlot addTank(int index, String name, int capacity) {
        TankSlot tank = new TankSlot(index, name, capacity);
        this.tanks.put(index, tank);
        return tank;
    }

    @Override
    public final TankSlot addTank(int index, ResourceLocation name, int capacity) {
        TankSlot tank = new TankSlot(index, name, capacity);
        this.tanks.put(index, tank);
        return tank;
    }

    private int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (!this.tanks.containsKey(tankIndex)) {
            return 0;
        }
        if (!this.isLiquidValidForTank(resource, tankIndex)) {
            return 0;
        }
        TankSlot tank = this.tanks.get(tankIndex);
        int filled = tank.getTank().fill(resource, doFill);
        if (filled > 0) {
            this.markDirty();
        }
        return filled;
    }

    @Nullable
    private FluidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (!this.tanks.containsKey(tankIndex)) {
            return null;
        }
        TankSlot tank = this.tanks.get(tankIndex);
        FluidStack drained = tank.getTank().drain(maxDrain, doDrain);
        if (drained != null && doDrain) {
            this.markDirty();
        }
        return drained;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTUtil.readFromList(compound, TANKS_KEY, tankNBT -> {
            int index = tankNBT.func_74762_e(TANK_INDEX_KEY);
            if (this.tanks.containsKey(index)) {
                TankSlot tank = this.tanks.get(index);
                tank.readFromNBT((NBTTagCompound)tankNBT);
            }
        });
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = super.writeToNBT(compound);
        NBTUtil.writeToList(compound, TANKS_KEY, this.tanks, (index, tank) -> {
            NBTTagCompound tankNBT = new NBTTagCompound();
            tankNBT.func_74768_a(TANK_INDEX_KEY, index.intValue());
            tank.writeToNBT(tankNBT);
            return tankNBT;
        });
        return compound;
    }

    @Override
    public boolean isTankReadOnly(int index) {
        return this.tanks.get(index).isReadOnly();
    }

    @Override
    public boolean isLiquidValidForTank(FluidStack liquid, int index) {
        TankSlot slot = this.getTankSlot(index);
        return slot != null && slot.isValid(liquid) && !slot.isReadOnly();
    }

    @Override
    public TankInfo[] getTankInfos() {
        return TankInfo.get(this);
    }

    @Override
    public IFluidTank getTank(int index) {
        return this.getTanks()[index];
    }

    @Override
    public IFluidTank[] getTanks() {
        ArrayList<FluidTank> tankList = new ArrayList<FluidTank>();
        for (TankSlot tank : this.tanks.values()) {
            tankList.add(tank.getTank());
        }
        return tankList.toArray(new IFluidTank[0]);
    }

    @Override
    @Nullable
    public TankSlot getTankSlot(int index) {
        return this.tanks.get(index);
    }

    public void markDirty() {
        this.getMachine().markDirty();
    }

    @Override
    @Nullable
    public IFluidHandler getHandler(@Nullable EnumFacing from) {
        if (from == null) {
            return this.noFacingHandler;
        }
        return this.handlers.get(from);
    }

    @Override
    @Nullable
    public IFluidHandler getHandler(int[] targetTanks) {
        HashMap<Integer, TankSlot> tanks = new HashMap<Integer, TankSlot>();
        for (int index : targetTanks) {
            TankSlot tankSlot = this.tanks.get(index);
            if (tankSlot == null) continue;
            tanks.put(index, tankSlot);
        }
        if (tanks.isEmpty()) {
            return null;
        }
        return new TankContainer(this, tanks, null);
    }

    private static class TankContainer
    implements IFluidHandler {
        private final ComponentTankContainer tankContainer;
        private final Map<Integer, TankSlot> tanks;
        @Nullable
        private final EnumFacing from;

        private TankContainer(ComponentTankContainer tankContainer, Map<Integer, TankSlot> tanks, @Nullable EnumFacing from) {
            this.tankContainer = tankContainer;
            this.tanks = tanks;
            this.from = from;
        }

        public final int fill(FluidStack resource, boolean doFill) {
            int index = TankContainer.getTankIndexToFill(this.tanks, this.from, resource);
            if (this.tanks.containsKey(index)) {
                return this.tankContainer.fill(index, resource, doFill);
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            int index = TankContainer.getTankIndexToDrain(this.tanks, this.from, null);
            if (this.tanks.containsKey(index)) {
                return this.tankContainer.drain(index, resource.amount, doDrain);
            }
            return null;
        }

        @Nullable
        public final FluidStack drain(int maxDrain, boolean doDrain) {
            int index = TankContainer.getTankIndexToDrain(this.tanks, this.from, null);
            if (this.tanks.containsKey(index)) {
                return this.tankContainer.drain(index, maxDrain, doDrain);
            }
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            IFluidTankProperties[] properties = new IFluidTankProperties[this.getTanks().length];
            for (int i = 0; i < properties.length; ++i) {
                IFluidTank tank = this.getTanks()[i];
                properties[i] = new FluidTankProperties(tank.getFluid(), tank.getCapacity());
            }
            return properties;
        }

        private IFluidTank[] getTanks() {
            ArrayList<FluidTank> ltanks = new ArrayList<FluidTank>();
            for (TankSlot tank : this.tanks.values()) {
                ltanks.add(tank.getTank());
            }
            return ltanks.toArray(new IFluidTank[0]);
        }

        private static int getTankIndexToFill(Map<Integer, TankSlot> tanks, @Nullable EnumFacing from, FluidStack resource) {
            for (TankSlot tank : tanks.values()) {
                if (!tank.isValid(resource) || !tank.canInsert(from) || tank.getContent() != null && !tank.getContent().isFluidEqual(resource)) continue;
                return tank.getIndex();
            }
            return -1;
        }

        private static int getTankIndexToDrain(Map<Integer, TankSlot> tanks, @Nullable EnumFacing from, @Nullable FluidStack resource) {
            for (TankSlot tank : tanks.values()) {
                if (tank.getContent() == null || !tank.canExtract(from) || resource != null && !resource.isFluidEqual(tank.getContent())) continue;
                return tank.getIndex();
            }
            return -1;
        }
    }
}

