/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.beebetteratbees.common.integration.jei;

import com.google.common.collect.Maps;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import hellfirepvp.beebetteratbees.client.util.SimpleBinaryTree;
import hellfirepvp.beebetteratbees.common.data.Config;
import hellfirepvp.beebetteratbees.common.util.BeeUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.opengl.GL11;

public class BeeTreeRecipeWrapper
implements IRecipeWrapper {
    private static final int MIN_X = 20;
    private static final int MAX_X = 170;
    private static final int X_SEPERATION_THRESHOLD = 7;
    private static final int Y_OFFSET = 0;
    private SimpleBinaryTree<IAlleleBeeSpecies> mutationTree;
    private List<PosItemStack> evaluatedBeePositions;
    private PosItemStack rootStack;
    private static final Color lineColorBlack = new Color(0, 0, 0);
    private static final Color lineColorRed = new Color(169, 0, 10);
    private static final int offsetCorrection = 8;
    private static final int possibleChildOffset = 16;

    public BeeTreeRecipeWrapper(final IAlleleBeeSpecies rootBee, final int select) {
        this.mutationTree = new SimpleBinaryTree<IAlleleBeeSpecies>(4, rootBee, new SimpleBinaryTree.RootProvider<IAlleleBeeSpecies>(){

            public IAlleleBeeSpecies[] provideSubNodes(IAlleleBeeSpecies superNode) {
                List<IBeeMutation> mutations = BeeUtil.getMutationsWithResult((IAllele)superNode);
                if (mutations.size() > 0) {
                    IBeeMutation mutation = mutations.get(superNode == rootBee ? MathHelper.func_76125_a((int)select, (int)0, (int)(mutations.size() - 1)) : 0);
                    return new IAlleleBeeSpecies[]{(IAlleleBeeSpecies)mutation.getAllele0(), (IAlleleBeeSpecies)mutation.getAllele1()};
                }
                return null;
            }
        });
        if (!Config.showDuplicateTrees) {
            ArrayList<IAlleleBeeSpecies> foundMutationTrees = new ArrayList<IAlleleBeeSpecies>();
            this.removeAndReplaceDuplicates(this.mutationTree.getRoot(), foundMutationTrees);
        }
        this.evaluatedBeePositions = new LinkedList<PosItemStack>();
        int iterationDepth = 3;
        int maxTotalDepth = Math.min(iterationDepth, this.mutationTree.getRoot().getMaxFollowingDepth());
        if (maxTotalDepth <= 0) {
            return;
        }
        int yStep = 110 / maxTotalDepth;
        boolean oversized = this.checkSeparationWidth(maxTotalDepth, 7);
        int evaluatedMaxX = 170;
        int center = (20 + evaluatedMaxX) / 2;
        PosItemStack leftChild = this.placeInRenderBuffer(this.mutationTree.getRoot().getLeftNode(), 0 + yStep, yStep, 20, center, iterationDepth - 1);
        PosItemStack rightChild = this.placeInRenderBuffer(this.mutationTree.getRoot().getRightNode(), 0 + yStep, yStep, center, evaluatedMaxX, iterationDepth - 1);
        List<IBeeMutation> mutationsToRoot = BeeUtil.getMutationsWithResult((IAllele)this.mutationTree.getRoot().getValue());
        float ch = -1.0f;
        LinkedList<String> requirements = new LinkedList<String>();
        if (mutationsToRoot.size() > 0) {
            IBeeMutation mut = mutationsToRoot.get(0);
            ch = mut.getBaseChance();
            try {
                requirements.addAll(mut.getSpecialConditions());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.rootStack = new PosItemStack(this.mutationTree.getRoot().getValue(), (20 + evaluatedMaxX) / 2, 0, ch, requirements, leftChild, rightChild, true);
    }

    private void removeAndReplaceDuplicates(SimpleBinaryTree.Node<IAlleleBeeSpecies> node, List<IAlleleBeeSpecies> discoveredMutations) {
        if (discoveredMutations.contains(node.getValue())) {
            List<IBeeMutation> mutations = BeeUtil.getMutationsWithResult((IAllele)node.getValue());
            if (mutations.size() > 0) {
                node.removeDuplicate();
            }
        } else {
            discoveredMutations.add(node.getValue());
            if (node.getMaxFollowingDepth() > 0) {
                this.removeAndReplaceDuplicates(node.getLeftNode(), discoveredMutations);
                this.removeAndReplaceDuplicates(node.getRightNode(), discoveredMutations);
            }
        }
    }

    public void getIngredients(IIngredients ingredients) {
        LinkedList inputs = new LinkedList();
        this.evaluatedBeePositions.forEach(i -> inputs.add(BeeUtil.createStack((IAlleleSpecies)i.beeSpecies, EnumBeeType.DRONE)));
        this.evaluatedBeePositions.forEach(i -> inputs.add(BeeUtil.createStack((IAlleleSpecies)i.beeSpecies, EnumBeeType.PRINCESS)));
        this.evaluatedBeePositions.forEach(i -> inputs.add(BeeUtil.createStack((IAlleleSpecies)i.beeSpecies, EnumBeeType.QUEEN)));
        this.evaluatedBeePositions.forEach(i -> inputs.add(BeeUtil.createStack((IAlleleSpecies)i.beeSpecies, EnumBeeType.LARVAE)));
        ingredients.setInputs(ItemStack.class, inputs);
        LinkedList<ItemStack> outputs = new LinkedList<ItemStack>();
        outputs.add(BeeUtil.createStack((IAlleleSpecies)this.rootStack.beeSpecies, EnumBeeType.DRONE));
        outputs.add(BeeUtil.createStack((IAlleleSpecies)this.rootStack.beeSpecies, EnumBeeType.PRINCESS));
        outputs.add(BeeUtil.createStack((IAlleleSpecies)this.rootStack.beeSpecies, EnumBeeType.QUEEN));
        outputs.add(BeeUtil.createStack((IAlleleSpecies)this.rootStack.beeSpecies, EnumBeeType.LARVAE));
        ingredients.setOutputs(ItemStack.class, outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        HashMap boxes = Maps.newHashMap();
        BeeTreeRecipeWrapper.drawExtrasFrom(this.rootStack, boxes);
        for (Map.Entry etr : boxes.entrySet()) {
            if (!((Rectangle)etr.getKey()).contains(mouseX, mouseY)) continue;
            GlStateManager.func_179097_i();
            GuiUtils.drawHoveringText((List)((List)etr.getValue()), (int)mouseX, (int)mouseY, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (FontRenderer)minecraft.field_71466_p);
            GlStateManager.func_179126_j();
        }
    }

    public static void drawExtrasFrom(PosItemStack nodeStack, Map<Rectangle, List<String>> infoBoxes) {
        float chance;
        int nodeX = nodeStack.posX;
        int nodeY = nodeStack.posY;
        if (nodeStack.leftChild == null || nodeStack.rightChild == null) {
            if (nodeStack.hasPossibleChildren) {
                float chance2;
                Color drawColor = lineColorBlack;
                if (nodeStack.requirements != null && !nodeStack.requirements.isEmpty()) {
                    drawColor = lineColorRed;
                }
                if ((chance2 = nodeStack.baseChance) > 0.0f) {
                    int length = BeeTreeRecipeWrapper.drawChanceInfo(nodeX, nodeY, chance2, Minecraft.func_71410_x().field_71466_p, drawColor);
                    if (nodeStack.requirements != null && !nodeStack.requirements.isEmpty()) {
                        Rectangle rec = new Rectangle(nodeX + 4, nodeY + 17, (int)((float)length * 0.75f), 5);
                        infoBoxes.put(rec, nodeStack.requirements);
                    }
                }
                BeeTreeRecipeWrapper.drawLine(nodeX + 8, nodeY + 8, nodeX + 8 - 4, nodeY + 8 + 16, drawColor);
                BeeTreeRecipeWrapper.drawLine(nodeX + 8, nodeY + 8, nodeX + 8 + 4, nodeY + 8 + 16, drawColor);
            }
            return;
        }
        Color drawColor = lineColorBlack;
        if (nodeStack.requirements != null && !nodeStack.requirements.isEmpty()) {
            drawColor = lineColorRed;
        }
        if ((chance = nodeStack.baseChance) > 0.0f) {
            int length = BeeTreeRecipeWrapper.drawChanceInfo(nodeX, nodeY, chance, Minecraft.func_71410_x().field_71466_p, drawColor);
            if (nodeStack.requirements != null && !nodeStack.requirements.isEmpty()) {
                Rectangle rec = new Rectangle(nodeX + 4, nodeY + 17, (int)((float)length * 0.75f), 5);
                infoBoxes.put(rec, nodeStack.requirements);
            }
        }
        PosItemStack left = nodeStack.leftChild;
        BeeTreeRecipeWrapper.drawLine(nodeX + 8, nodeY + 8, left.posX + 8, left.posY + 8, drawColor);
        PosItemStack right = nodeStack.rightChild;
        BeeTreeRecipeWrapper.drawLine(nodeX + 8, nodeY + 8, right.posX + 8, right.posY + 8, drawColor);
        BeeTreeRecipeWrapper.drawExtrasFrom(left, infoBoxes);
        BeeTreeRecipeWrapper.drawExtrasFrom(right, infoBoxes);
    }

    private static int drawChanceInfo(int nodeX, int nodeY, float chance, FontRenderer fr, Color drawColor) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(nodeX + 4), (float)(nodeY + 17), (float)0.0f);
        GL11.glScalef((float)0.65f, (float)0.65f, (float)0.65f);
        int chAsInt = (int)chance;
        StringBuilder sb = new StringBuilder().append(TextFormatting.BOLD);
        if (chAsInt <= 0) {
            sb.append("<1%");
        } else {
            sb.append(chAsInt).append("%");
        }
        int length = fr.func_78276_b(sb.toString(), 0, 0, drawColor.getRGB());
        GL11.glPopMatrix();
        return length;
    }

    private static void drawLine(double lx, double ly, double hx, double hy, Color color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187441_d((float)3.0f);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.4f);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        vb.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        vb.func_181662_b(lx, ly, 0.0).func_181675_d();
        vb.func_181662_b(hx, hy, 0.0).func_181675_d();
        t.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2848);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public List<PosItemStack> getEvaluatedBeePositions() {
        return this.evaluatedBeePositions;
    }

    public PosItemStack getRootStack() {
        return this.rootStack;
    }

    private boolean checkSeparationWidth(int maxTotalDepth, int xSeparationThreshold) {
        double maxDivision = Math.pow(2.0, maxTotalDepth + 1);
        int resultingLLWidth = (int)(120.0 / maxDivision);
        return resultingLLWidth < xSeparationThreshold;
    }

    private PosItemStack placeInRenderBuffer(SimpleBinaryTree.Node<IAlleleBeeSpecies> node, int minY, int yStep, int minX, int maxX, int iterationMaxCount) {
        int center = (minX + maxX) / 2;
        if (--iterationMaxCount < 0 || node.getMaxFollowingDepth() <= 0) {
            List<IBeeMutation> mutationsToRoot = BeeUtil.getMutationsWithResult((IAllele)node.getValue());
            float ch = -1.0f;
            LinkedList<String> requirements = new LinkedList<String>();
            if (mutationsToRoot.size() > 0) {
                IBeeMutation mut = mutationsToRoot.get(0);
                ch = mut.getBaseChance();
                try {
                    requirements.addAll(mut.getSpecialConditions());
                }
                catch (Throwable tr) {
                    requirements = new LinkedList();
                }
            }
            PosItemStack leaf = new PosItemStack(node.getValue(), center, minY, ch, requirements, null, null, node.getMaxFollowingDepth() > 0);
            this.evaluatedBeePositions.add(leaf);
            return leaf;
        }
        List<IBeeMutation> mutations = BeeUtil.getMutationsWithResult((IAllele)node.getValue());
        float ch = -1.0f;
        LinkedList<String> requirements = new LinkedList<String>();
        if (mutations.size() > 0) {
            IBeeMutation mut = mutations.get(0);
            ch = mut.getBaseChance();
            try {
                requirements.addAll(mut.getSpecialConditions());
            }
            catch (Throwable tr) {
                requirements = new LinkedList();
            }
        }
        PosItemStack outNode = new PosItemStack(node.getValue(), center, minY, ch, requirements, node.getLeftNode() != null ? this.placeInRenderBuffer(node.getLeftNode(), minY + yStep, yStep, minX, center, iterationMaxCount) : null, node.getRightNode() != null ? this.placeInRenderBuffer(node.getRightNode(), minY + yStep, yStep, center, maxX, iterationMaxCount) : null, true);
        this.evaluatedBeePositions.add(outNode);
        return outNode;
    }

    public static class PosItemStack {
        public final IAlleleBeeSpecies beeSpecies;
        public final int posX;
        public final int posY;
        public final boolean hasPossibleChildren;
        public final float baseChance;
        public final List<String> requirements;
        public final PosItemStack leftChild;
        public final PosItemStack rightChild;

        public PosItemStack(IAlleleBeeSpecies species, int x, int y, float baseChance, List<String> requirementInfo, PosItemStack leftChild, PosItemStack rightChild, boolean hasPossibleChildren) {
            this.beeSpecies = species;
            this.posX = x;
            this.posY = y;
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.hasPossibleChildren = hasPossibleChildren;
            this.baseChance = baseChance;
            this.requirements = requirementInfo;
        }
    }
}

