/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FullnessMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.automation.BlockUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.AEItemFilters;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TileIOPort
extends AENetworkInvTile
implements IUpgradeableHost,
IConfigManagerHost,
IGridTickable {
    private static final int NUMBER_OF_CELL_SLOTS = 6;
    private static final int NUMBER_OF_UPGRADE_SLOTS = 3;
    private final ConfigManager manager;
    private final AppEngInternalInventory inputCells = new AppEngInternalInventory(this, 6, 1);
    private final AppEngInternalInventory outputCells = new AppEngInternalInventory(this, 6, 1);
    private final IItemHandler combinedInventory = new WrapperChainedItemHandler(new IItemHandler[]{this.inputCells, this.outputCells});
    private final IItemHandler inputCellsExt = new WrapperFilteredItemHandler((IItemHandler)this.inputCells, AEItemFilters.INSERT_ONLY);
    private final IItemHandler outputCellsExt = new WrapperFilteredItemHandler((IItemHandler)this.outputCells, AEItemFilters.EXTRACT_ONLY);
    private final UpgradeInventory upgrades;
    private final IActionSource mySrc;
    private YesNo lastRedstoneState;
    private ItemStack currentCell;
    private Map<IStorageChannel<?>, IMEInventory<?>> cachedInventories;
    private boolean isActive = false;

    public TileIOPort() {
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.manager = new ConfigManager(this);
        this.manager.registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.manager.registerSetting(Settings.FULLNESS_MODE, (Enum)FullnessMode.EMPTY);
        this.manager.registerSetting(Settings.OPERATION_MODE, (Enum)OperationMode.EMPTY);
        this.mySrc = new MachineSource(this);
        this.lastRedstoneState = YesNo.UNDECIDED;
        Block ioPortBlock = AEApi.instance().definitions().blocks().iOPort().maybeBlock().get();
        this.upgrades = new BlockUpgradeInventory(ioPortBlock, this, 3);
    }

    @MENetworkEventSubscribe
    public void onPower(MENetworkPowerStatusChange ch) {
        this.markForUpdate();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.manager.writeToNBT(data);
        this.upgrades.writeToNBT(data, "upgrades");
        data.func_74768_a("lastRedstoneState", this.lastRedstoneState.ordinal());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.manager.readFromNBT(data);
        this.upgrades.readFromNBT(data, "upgrades");
        if (data.func_74764_b("lastRedstoneState")) {
            this.lastRedstoneState = YesNo.values()[data.func_74762_e("lastRedstoneState")];
        }
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldIsActive = this.isActive;
        this.isActive = data.readBoolean();
        return oldIsActive != this.isActive || c;
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isActive());
    }

    public boolean isActive() {
        if (Platform.isServer()) {
            try {
                return this.getProxy().getEnergy().isNetworkPowered();
            }
            catch (GridAccessException e) {
                return false;
            }
        }
        return this.isActive;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    private void updateTask() {
        try {
            if (this.hasWork()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void updateRedstoneState() {
        YesNo currentState;
        YesNo yesNo = currentState = this.field_145850_b.func_175687_A(this.field_174879_c) != 0 ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            this.updateTask();
            if (currentState == YesNo.YES && this.manager.getSetting(Settings.REDSTONE_CONTROLLED) == RedstoneMode.SIGNAL_PULSE) {
                this.doWork();
            }
        }
    }

    private boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    private boolean isEnabled() {
        if (this.getInstalledUpgrades(Upgrades.REDSTONE) == 0) {
            return true;
        }
        RedstoneMode rs = (RedstoneMode)this.manager.getSetting(Settings.REDSTONE_CONTROLLED);
        switch (rs) {
            case IGNORE: {
                return true;
            }
            case HIGH_SIGNAL: {
                return this.getRedstoneState();
            }
            case LOW_SIGNAL: {
                return !this.getRedstoneState();
            }
        }
        return false;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        if (name.equals("cells")) {
            return this.combinedInventory;
        }
        return null;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.updateTask();
    }

    private boolean hasWork() {
        if (this.isEnabled()) {
            return !ItemHandlerUtil.isEmpty((IItemHandler)this.inputCells);
        }
        return false;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.combinedInventory;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.inputCells == inv) {
            this.updateTask();
        }
    }

    @Override
    protected IItemHandler getItemHandlerForSide(EnumFacing facing) {
        if (facing == this.getUp() || facing == this.getUp().func_176734_d()) {
            return this.inputCellsExt;
        }
        return this.outputCellsExt;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.IOPort.getMin(), TickRates.IOPort.getMax(), !this.hasWork(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.getProxy().isActive()) {
            return TickRateModulation.IDLE;
        }
        return this.doWork();
    }

    public TickRateModulation doWork() {
        TickRateModulation ret = TickRateModulation.SLEEP;
        long itemsToMove = 256L;
        switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
            case 1: {
                itemsToMove *= 2L;
                break;
            }
            case 2: {
                itemsToMove *= 4L;
                break;
            }
            case 3: {
                itemsToMove *= 8L;
            }
        }
        try {
            IEnergyGrid energy = this.getProxy().getEnergy();
            for (int x = 0; x < 6; ++x) {
                ItemStack is = this.inputCells.getStackInSlot(x);
                if (is.func_190926_b()) continue;
                boolean shouldMove = true;
                for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : AEApi.instance().storage().storageChannels()) {
                    if (itemsToMove <= 0L) continue;
                    IMEMonitor<? extends IAEStack<?>> network = this.getProxy().getStorage().getInventory(iStorageChannel);
                    IMEInventory<?> inv = this.getInv(is, iStorageChannel);
                    if (inv == null) continue;
                    itemsToMove = this.manager.getSetting(Settings.OPERATION_MODE) == OperationMode.EMPTY ? this.transferContents(energy, inv, network, itemsToMove, iStorageChannel) : this.transferContents(energy, network, inv, itemsToMove, iStorageChannel);
                    shouldMove &= this.shouldMove(inv);
                    if (itemsToMove > 0L) {
                        ret = TickRateModulation.IDLE;
                        continue;
                    }
                    ret = TickRateModulation.URGENT;
                }
                ret = itemsToMove > 0L && shouldMove && this.moveSlot(x) ? TickRateModulation.URGENT : TickRateModulation.URGENT;
            }
        }
        catch (GridAccessException e) {
            ret = TickRateModulation.IDLE;
        }
        return ret;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    private IMEInventory<?> getInv(ItemStack is, IStorageChannel<?> chan) {
        if (this.currentCell != is) {
            this.currentCell = is;
            this.cachedInventories = new IdentityHashMap();
            for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : AEApi.instance().storage().storageChannels()) {
                this.cachedInventories.put(iStorageChannel, AEApi.instance().registries().cell().getCellInventory(is, null, iStorageChannel));
            }
        }
        return this.cachedInventories.get(chan);
    }

    private long transferContents(IEnergySource energy, IMEInventory src, IMEInventory destination, long itemsToMove, IStorageChannel chan) {
        boolean didStuff;
        IItemList myList = src instanceof IMEMonitor ? ((IMEMonitor)src).getStorageList() : src.getAvailableItems(src.getChannel().createList());
        itemsToMove *= (long)chan.transferFactor();
        block0: do {
            didStuff = false;
            for (IAEStack s : myList) {
                long totalStackSize = s.getStackSize();
                if (totalStackSize <= 0L) continue;
                IAEStack stack = destination.injectItems(s, Actionable.SIMULATE, this.mySrc);
                long possible = 0L;
                possible = stack == null ? totalStackSize : totalStackSize - stack.getStackSize();
                if (possible <= 0L) continue;
                Object injectable = s.copy();
                possible = Math.min(possible, itemsToMove);
                injectable.setStackSize(possible);
                Object extracted = src.extractItems(injectable, Actionable.MODULATE, this.mySrc);
                if (extracted == null) continue;
                possible = extracted.getStackSize();
                extracted.setCraftable(false);
                Object failed = Platform.poweredInsert(energy, destination, extracted, this.mySrc);
                if (failed != null) {
                    possible -= failed.getStackSize();
                    src.injectItems(failed, Actionable.MODULATE, this.mySrc);
                }
                if (possible <= 0L) continue block0;
                itemsToMove -= possible;
                didStuff = true;
                continue block0;
            }
        } while (itemsToMove > 0L && didStuff);
        return itemsToMove / (long)chan.transferFactor();
    }

    private boolean shouldMove(IMEInventory<?> inv) {
        FullnessMode fm = (FullnessMode)this.manager.getSetting(Settings.FULLNESS_MODE);
        if (inv != null) {
            return this.matches(fm, inv);
        }
        return true;
    }

    private boolean moveSlot(int x) {
        AdaptorItemHandler ad = new AdaptorItemHandler((IItemHandler)this.outputCells);
        if (((InventoryAdaptor)ad).addItems(this.inputCells.getStackInSlot(x)).func_190926_b()) {
            this.inputCells.setStackInSlot(x, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    private boolean matches(FullnessMode fm, IMEInventory src) {
        if (fm == FullnessMode.HALF) {
            return true;
        }
        IItemList myList = src instanceof IMEMonitor ? ((IMEMonitor)src).getStorageList() : src.getAvailableItems(src.getChannel().createList());
        if (fm == FullnessMode.EMPTY) {
            return myList.isEmpty();
        }
        Object test = myList.getFirstItem();
        if (test != null) {
            Object testCopy = test.copy();
            testCopy.setStackSize(1L);
            return src.injectItems(testCopy, Actionable.SIMULATE, this.mySrc) != null;
        }
        return false;
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        super.getDrops(w, pos, drops);
        for (int upgradeIndex = 0; upgradeIndex < this.upgrades.getSlots(); ++upgradeIndex) {
            ItemStack stackInSlot = this.upgrades.getStackInSlot(upgradeIndex);
            if (stackInSlot.func_190926_b()) continue;
            drops.add(stackInSlot);
        }
    }
}

