/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IMaterials;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.GuiBridge;
import appeng.helpers.DualityInterface;
import appeng.helpers.DualityInterfaceAdv;
import appeng.helpers.DualityInterfaceImp;
import appeng.helpers.DualityInterfacePatt;
import appeng.helpers.DualityInterfacePer;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.items.misc.ItemEncodedPattern;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.InvOperation;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class TileInterfaceImp
extends AENetworkInvTile
implements IGridTickable,
IInventoryDestination,
IInterfaceHost,
IPriorityHost {
    private final DualityInterfaceImp duality = new DualityInterfaceImp(this.getProxy(), this);
    private final DualityInterfacePer duality2 = new DualityInterfacePer(this.getProxy(), this);
    private final DualityInterfaceAdv duality3 = new DualityInterfaceAdv(this.getProxy(), this);
    private final DualityInterfacePatt duality4 = new DualityInterfacePatt(this.getProxy(), this);
    private final DualityInterface duality5 = new DualityInterface(this.getProxy(), this);
    private boolean omniDirectional = true;

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.duality.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.duality.notifyNeighbors();
    }

    public void setSide(EnumFacing facing) {
        if (Platform.isClient()) {
            return;
        }
        EnumFacing newForward = facing;
        if (!this.omniDirectional && this.getForward() == facing.func_176734_d()) {
            newForward = facing;
        } else if (!(this.omniDirectional || this.getForward() != facing && this.getForward() != facing.func_176734_d())) {
            this.omniDirectional = true;
        } else if (this.omniDirectional) {
            newForward = facing.func_176734_d();
            this.omniDirectional = false;
        } else {
            newForward = Platform.rotateAround(this.getForward(), facing);
        }
        if (this.omniDirectional) {
            this.setOrientation(EnumFacing.NORTH, EnumFacing.UP);
        } else {
            EnumFacing newUp = EnumFacing.UP;
            if (newForward == EnumFacing.UP || newForward == EnumFacing.DOWN) {
                newUp = EnumFacing.NORTH;
            }
            this.setOrientation(newForward, newUp);
        }
        this.configureNodeSides();
        this.markForUpdate();
        this.saveChanges();
    }

    private void configureNodeSides() {
        if (this.omniDirectional) {
            this.getProxy().setValidSides(EnumSet.allOf(EnumFacing.class));
        } else {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        }
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        this.duality.addDrops(drops);
    }

    @Override
    public void gridChanged() {
        this.duality.gridChanged();
    }

    @Override
    public void onReady() {
        this.configureNodeSides();
        super.onReady();
        this.duality.initialize();
        this.getProxy().setIdlePowerUsage(2.0);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74757_a("omniDirectional", this.omniDirectional);
        this.duality.writeToNBT(data);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.omniDirectional = data.func_74767_n("omniDirectional");
        this.duality.readFromNBT(data);
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldOmniDirectional = this.omniDirectional;
        this.omniDirectional = data.readBoolean();
        return oldOmniDirectional != this.omniDirectional || c;
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.omniDirectional);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return this.duality.getCableConnectionType(dir);
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.duality.getLocation();
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        return this.duality.canInsert(stack);
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        return this.duality.getInventoryByName(name);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return this.duality.getTickingRequest(node);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.duality.tickingRequest(node, ticksSinceLastCall);
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.duality.getInternalInventory();
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.duality.onChangeInventory(inv, slot, mc, removed, added);
    }

    @Override
    public DualityInterface getInterfaceDuality() {
        return this.duality5;
    }

    @Override
    public DualityInterfaceImp getInterfaceDualityImp() {
        return this.duality;
    }

    @Override
    public DualityInterfaceAdv getInterfaceDualityAdv() {
        return this.duality3;
    }

    @Override
    public DualityInterfacePer getInterfaceDualityPer() {
        return this.duality2;
    }

    @Override
    public DualityInterfacePatt getInterfaceDualityPatt() {
        return this.duality4;
    }

    @Override
    public EnumSet<EnumFacing> getTargets() {
        if (this.omniDirectional) {
            return EnumSet.allOf(EnumFacing.class);
        }
        return EnumSet.of(this.getForward());
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.duality.getConfigManager();
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.duality.pushPattern(patternDetails, table);
    }

    @Override
    public boolean isBusy() {
        return this.duality.isBusy();
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.duality.provideCrafting(craftingTracker);
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.duality.getInstalledUpgrades(u);
    }

    @Override
    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.duality.getRequestedJobs();
    }

    @Override
    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return this.duality.injectCraftedItems(link, items, mode);
    }

    @Override
    public void jobStateChange(ICraftingLink link) {
        this.duality.jobStateChange(link);
    }

    @Override
    public int getPriority() {
        return this.duality.getPriority();
    }

    @Override
    public void setPriority(int newValue) {
        this.duality.setPriority(newValue);
    }

    public boolean isOmniDirectional() {
        return this.omniDirectional;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.duality.hasCapability(capability, facing) || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T result = this.duality.getCapability(capability, facing);
        if (result != null) {
            return result;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return AEApi.instance().definitions().blocks().ifaceImp().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    @Override
    public GuiBridge getGuiBridge() {
        return GuiBridge.GUI_INTERFACEIMP;
    }

    @Override
    public NBTTagCompound downloadSettings(SettingsFrom from) {
        IItemHandler inv;
        NBTTagCompound output = super.downloadSettings(from);
        if (from == SettingsFrom.MEMORY_CARD && (inv = this.getInventoryByName("patterns")) instanceof AppEngInternalInventory) {
            ((AppEngInternalInventory)inv).writeToNBT(output, "patterns");
        }
        return output;
    }

    @Override
    public void uploadSettings(SettingsFrom from, NBTTagCompound compound, EntityPlayer player) {
        super.uploadSettings(from, compound, player);
        IItemHandler inv = this.getInventoryByName("patterns");
        if (inv instanceof AppEngInternalInventory) {
            AppEngInternalInventory target = (AppEngInternalInventory)inv;
            AppEngInternalInventory tmp = new AppEngInternalInventory(null, target.getSlots());
            tmp.readFromNBT(compound, "patterns");
            PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(player.field_71071_by);
            IMaterials materials = AEApi.instance().definitions().materials();
            int missingPatternsToEncode = 0;
            int amountPatternSlots = 36;
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!(target.getStackInSlot(i).func_77973_b() instanceof ItemEncodedPattern)) continue;
                ItemStack blank = materials.blankPattern().maybeStack(target.getStackInSlot(i).func_190916_E()).get();
                if (!player.func_191521_c(blank)) {
                    player.func_71019_a(blank, true);
                }
                target.setStackInSlot(i, ItemStack.field_190927_a);
            }
            for (int x = 0; x < amountPatternSlots; ++x) {
                if (tmp.getStackInSlot(x).func_190926_b()) continue;
                boolean found = false;
                for (int i = 0; i < playerInv.getSlots(); ++i) {
                    if (!materials.blankPattern().isSameAs(playerInv.getStackInSlot(i))) continue;
                    target.setStackInSlot(x, tmp.getStackInSlot(x));
                    playerInv.getStackInSlot(i).func_190918_g(1);
                    found = true;
                    break;
                }
                if (found) continue;
                ++missingPatternsToEncode;
            }
            if (Platform.isServer() && missingPatternsToEncode > 0) {
                player.func_145747_a(PlayerMessages.MissingPatternsToEncode.get());
            }
        }
    }
}

