/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.util.IConfigManager;
import appeng.parts.PartBasicState;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public abstract class PartUpgradeableImp
extends PartBasicState
implements IAEAppEngInventory,
IConfigManagerHost {
    private final IConfigManager manager;
    private final UpgradeInventory upgrades = new StackUpgradeInventory(this.getItemStack(), this, this.getUpgradeSlots());

    public PartUpgradeableImp(ItemStack is) {
        super(is);
        this.manager = new ConfigManager(this);
    }

    protected int getUpgradeSlots() {
        return 4;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.upgrades) {
            this.upgradesChanged();
        }
    }

    public void upgradesChanged() {
    }

    protected boolean isSleeping() {
        switch (this.getRSMode()) {
            case IGNORE: {
                return false;
            }
            case HIGH_SIGNAL: {
                if (!this.getHost().hasRedstone(this.getSide())) break;
                return false;
            }
            case LOW_SIGNAL: {
                if (this.getHost().hasRedstone(this.getSide())) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.manager.readFromNBT(extra);
        this.upgrades.readFromNBT(extra, "upgrades");
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.manager.writeToNBT(extra);
        this.upgrades.writeToNBT(extra, "upgrades");
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack is : this.upgrades) {
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    public RedstoneMode getRSMode() {
        return null;
    }
}

