/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.parts.IPart;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.part.BasePartWailaDataProvider;
import appeng.parts.networking.PartCableSmart;
import appeng.parts.networking.PartDenseCableSmart;
import appeng.parts.networking.PartX128CableCoverted;
import appeng.parts.networking.PartX256CableCoverted;
import appeng.parts.networking.PartX64CableCoverted;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ChannelWailaDataProvider
extends BasePartWailaDataProvider {
    private static final String ID_USED_CHANNELS = "usedChannels";
    private final Object2IntMap<IPart> cache = new Object2IntOpenHashMap();

    @Override
    public List<String> getWailaBody(IPart part, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag;
        int usedChannels;
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.CHANNELS)) {
            return currentToolTip;
        }
        if ((part instanceof PartCableSmart || part instanceof PartDenseCableSmart || part instanceof PartX64CableCoverted || part instanceof PartX128CableCoverted || part instanceof PartX256CableCoverted) && (usedChannels = this.getUsedChannels(part, tag = accessor.getNBTData(), this.cache)) >= 0) {
            int maxChannels = part instanceof PartDenseCableSmart ? AEConfig.instance().getDenseCableCapacity() : (part instanceof PartX64CableCoverted ? AEConfig.instance().getX64CableCapacity() : (part instanceof PartX128CableCoverted ? AEConfig.instance().getX128CableCapacity() : (part instanceof PartX256CableCoverted ? AEConfig.instance().getX256CableCapacity() : AEConfig.instance().getSmallCableCapacity())));
            String formattedToolTip = String.format(WailaText.Channels.getLocal(), usedChannels, maxChannels);
            currentToolTip.add(formattedToolTip);
        }
        return currentToolTip;
    }

    private int getUsedChannels(IPart part, NBTTagCompound tag, Object2IntMap<IPart> cache) {
        int usedChannels;
        if (tag.func_74764_b(ID_USED_CHANNELS)) {
            usedChannels = tag.func_74762_e(ID_USED_CHANNELS);
            this.cache.put((Object)part, usedChannels);
        } else {
            usedChannels = this.cache.containsKey((Object)part) ? (Integer)this.cache.get((Object)part) : -1;
        }
        return usedChannels;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, IPart part, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (part instanceof PartCableSmart || part instanceof PartDenseCableSmart) {
            NBTTagCompound tempTag = new NBTTagCompound();
            part.writeToNBT(tempTag);
            if (tempTag.func_74764_b(ID_USED_CHANNELS)) {
                int usedChannels = tempTag.func_74762_e(ID_USED_CHANNELS);
                tag.func_74768_a(ID_USED_CHANNELS, usedChannels);
            }
        }
        return tag;
    }
}

