/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.fluids.parts.PartSharedFluidBus;
import appeng.fluids.util.AEFluidStack;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PartFluidImportBusImp
extends PartSharedFluidBus {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "part/fluid_import_bus_base_diamond");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/fluid_import_bus_off_diamond"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/fluid_import_bus_on_diamond"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/fluid_import_bus_has_channel_diamond"));
    private final IActionSource source;

    public PartFluidImportBusImp(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.source = new MachineSource(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(4, 35, this.isSleeping(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.canDoBusWork() ? this.doBusWork() : TickRateModulation.IDLE;
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        TileEntity te = this.getConnectedTE();
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d())) {
            try {
                IFluidHandler fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d());
                IMEMonitor<IAEFluidStack> inv = this.getProxy().getStorage().getInventory(this.getChannel());
                if (fh != null) {
                    FluidStack fluidStack = fh.drain(this.amountFluidsToSendImp(), false);
                    if (this.filterEnabled() && !this.isInFilter(fluidStack)) {
                        return TickRateModulation.SLOWER;
                    }
                    AEFluidStack aeFluidStack = AEFluidStack.fromFluidStack(fluidStack);
                    if (aeFluidStack != null) {
                        IAEFluidStack notInserted = inv.injectItems(aeFluidStack, Actionable.MODULATE, this.source);
                        if (notInserted != null && notInserted.getStackSize() > 0L) {
                            aeFluidStack.decStackSize(notInserted.getStackSize());
                        }
                        fh.drain(aeFluidStack.getFluidStack(), true);
                        return TickRateModulation.URGENT;
                    }
                    return TickRateModulation.IDLE;
                }
            }
            catch (GridAccessException e) {
                e.printStackTrace();
            }
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    private boolean isInFilter(FluidStack fluid) {
        for (int i = 0; i < this.getConfig().getSlots(); ++i) {
            IAEFluidStack stack = this.getConfig().getFluidInSlot(i);
            if (stack == null || !stack.equals(fluid)) continue;
            return true;
        }
        return false;
    }

    private boolean filterEnabled() {
        for (int i = 0; i < this.getConfig().getSlots(); ++i) {
            IAEFluidStack stack = this.getConfig().getFluidInSlot(i);
            if (stack == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

