/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.fluids.parts.PartFluidStorageBus;
import appeng.fluids.util.AEFluidStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.IGridProxyable;
import appeng.me.storage.ITickingMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerAdapter
implements IMEInventory<IAEFluidStack>,
IBaseMonitor<IAEFluidStack>,
ITickingMonitor {
    private final Map<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> listeners = new HashMap<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>();
    private IActionSource source;
    private final IFluidHandler fluidHandler;
    private final IGridProxyable proxyable;
    private final InventoryCache cache;
    private StorageFilter mode;
    private AccessRestriction access;

    FluidHandlerAdapter(IFluidHandler fluidHandler, IGridProxyable proxy) {
        this.fluidHandler = fluidHandler;
        IGridProxyable iGridProxyable = this.proxyable = proxy;
        if (iGridProxyable instanceof PartFluidStorageBus) {
            PartFluidStorageBus partFluidStorageBus = (PartFluidStorageBus)iGridProxyable;
            this.mode = (StorageFilter)partFluidStorageBus.getConfigManager().getSetting(Settings.STORAGE_FILTER);
            this.access = (AccessRestriction)partFluidStorageBus.getConfigManager().getSetting(Settings.ACCESS);
        }
        this.cache = new InventoryCache(this.fluidHandler, this.mode);
        this.cache.update();
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
        FluidStack fluidStack = input.getFluidStack();
        int wasFillled = this.fluidHandler.fill(fluidStack, type != Actionable.SIMULATE);
        int remaining = fluidStack.amount - wasFillled;
        if (fluidStack.amount == remaining) {
            return input;
        }
        if (type == Actionable.MODULATE) {
            IAEFluidStack added = (IAEFluidStack)input.copy().setStackSize(input.getStackSize() - (long)remaining);
            this.cache.currentlyCached.add(added);
            this.postDifference(Collections.singletonList(added));
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        fluidStack.amount = remaining;
        return AEFluidStack.fromFluidStack(fluidStack);
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, IActionSource src) {
        boolean doDrain;
        FluidStack requestedFluidStack = request.getFluidStack();
        FluidStack gathered = this.fluidHandler.drain(requestedFluidStack, doDrain = mode == Actionable.MODULATE);
        if (gathered == null) {
            return null;
        }
        AEFluidStack gatheredAEFluidstack = AEFluidStack.fromFluidStack(gathered);
        if (mode == Actionable.MODULATE) {
            IAEFluidStack cachedStack = this.cache.currentlyCached.findPrecise(request);
            if (cachedStack != null) {
                cachedStack.decStackSize(gatheredAEFluidstack.getStackSize());
                this.postDifference(Collections.singletonList((IAEFluidStack)gatheredAEFluidstack.copy().setStackSize(-gatheredAEFluidstack.getStackSize())));
            }
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return gatheredAEFluidstack;
    }

    @Override
    public TickRateModulation onTick() {
        List<IAEFluidStack> changes = this.cache.update();
        if (!changes.isEmpty() && this.access.hasPermission(AccessRestriction.READ)) {
            this.postDifference(changes);
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        return this.cache.getAvailableItems(out);
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public void setActionSource(IActionSource source) {
        this.source = source;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEFluidStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEFluidStack> l) {
        this.listeners.remove(l);
    }

    private void postDifference(Iterable<IAEFluidStack> a) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> l = i.next();
            IMEMonitorHandlerReceiver<IAEFluidStack> key = l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange(this, a, this.source);
                continue;
            }
            i.remove();
        }
    }

    private static class InventoryCache {
        private final IFluidHandler fluidHandler;
        private final StorageFilter mode;
        IItemList<IAEFluidStack> currentlyCached = AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();

        public InventoryCache(IFluidHandler fluidHandler, StorageFilter mode) {
            this.mode = mode;
            this.fluidHandler = fluidHandler;
        }

        public List<IAEFluidStack> update() {
            ArrayList<IAEFluidStack> changes = new ArrayList<IAEFluidStack>();
            IFluidTankProperties[] tankProperties = this.fluidHandler.getTankProperties();
            IItemList<AEFluidStack> currentlyOnStorage = AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
            for (IFluidTankProperties tankProperty : tankProperties) {
                if (this.mode == StorageFilter.EXTRACTABLE_ONLY && this.fluidHandler.drain(1, false) == null) continue;
                currentlyOnStorage.add(AEFluidStack.fromFluidStack(tankProperty.getContents()));
            }
            for (IAEFluidStack iAEFluidStack : this.currentlyCached) {
                iAEFluidStack.setStackSize(-iAEFluidStack.getStackSize());
            }
            for (IAEFluidStack iAEFluidStack : currentlyOnStorage) {
                this.currentlyCached.add(iAEFluidStack);
            }
            for (IAEFluidStack iAEFluidStack : this.currentlyCached) {
                if (iAEFluidStack.getStackSize() == 0L) continue;
                changes.add(iAEFluidStack);
            }
            this.currentlyCached = currentlyOnStorage;
            return changes;
        }

        public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
            this.currentlyCached.iterator().forEachRemaining(out::add);
            return out;
        }
    }
}

