/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Upgrades;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.container.guisync.GuiSync;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketTargetFluidStack;
import appeng.fluids.container.ContainerFluidConfigurable;
import appeng.fluids.helper.DualityFluidInterface;
import appeng.fluids.helper.FluidSyncHelper;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import appeng.helpers.InventoryAction;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ContainerFluidInterface
extends ContainerFluidConfigurable
implements IConfigManagerHost {
    private final DualityFluidInterface myDuality;
    private final FluidSyncHelper tankSync;
    private IConfigManagerHost gui;
    private IAEFluidStack clientRequestedTargetFluid = null;
    @GuiSync(value=7)
    public int capacityUpgrades = 0;

    public ContainerFluidInterface(InventoryPlayer ip, IFluidInterfaceHost te) {
        super(ip, te.getDualityFluidInterface().getHost());
        this.myDuality = te.getDualityFluidInterface();
        this.tankSync = new FluidSyncHelper(this.myDuality.getTanks(), 9);
    }

    @Override
    protected int getHeight() {
        return 231;
    }

    @Override
    public IAEFluidTank getFluidConfigInventory() {
        return this.myDuality.getConfig();
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.tankSync.sendDiff(this.field_75149_d);
            if (this.capacityUpgrades != this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY)) {
                this.capacityUpgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
            }
        }
        super.func_75142_b();
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (Platform.isClient() && field.equals("capacityUpgrades")) {
            this.capacityUpgrades = (Integer)newValue;
            ((AEFluidInventory)this.myDuality.getTanks()).setCapacity((int)(Math.pow(4.0, this.capacityUpgrades + 1) * 1000.0));
        }
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    protected void loadSettingsFromHost(IConfigManager cm) {
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.tankSync.sendFull(Collections.singleton(listener));
    }

    @Override
    public void receiveFluidSlots(Map<Integer, IAEFluidStack> fluids) {
        super.receiveFluidSlots(fluids);
        this.tankSync.readPacket(fluids);
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM) {
            super.doAction(player, action, slot, id);
            return;
        }
        ItemStack held = player.field_71071_by.func_70445_o();
        ItemStack heldCopy = held.func_77946_l();
        heldCopy.func_190920_e(1);
        IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)heldCopy);
        if (fh == null) {
            return;
        }
        if (action == InventoryAction.FILL_ITEM && this.clientRequestedTargetFluid != null) {
            IAEFluidStack stack = this.clientRequestedTargetFluid.copy();
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = fh.fill(stack.getFluidStack(), false);
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                ItemStack copiedFluidContainer = held.func_77946_l();
                copiedFluidContainer.func_190920_e(1);
                fh = FluidUtil.getFluidHandler((ItemStack)copiedFluidContainer);
                FluidStack extractableFluid = this.myDuality.getTanks().drain(((IAEFluidStack)stack.setStackSize(amountAllowed)).getFluidStack(), false);
                if (extractableFluid != null && extractableFluid.amount != 0) {
                    int fillableAmount = fh.fill(extractableFluid, false);
                    if (fillableAmount > 0) {
                        FluidStack extractedFluid = this.myDuality.getTanks().drain(extractableFluid, true);
                        fh.fill(extractedFluid, true);
                    }
                    if (held.func_190916_E() == 1) {
                        player.field_71071_by.func_70437_b(fh.getContainer());
                        continue;
                    }
                    player.field_71071_by.func_70445_o().func_190918_g(1);
                    if (player.field_71071_by.func_70441_a(fh.getContainer())) continue;
                    player.func_71019_a(fh.getContainer(), false);
                    continue;
                }
                break;
            }
        } else if (action == InventoryAction.EMPTY_ITEM) {
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                ItemStack copiedFluidContainer = held.func_77946_l();
                copiedFluidContainer.func_190920_e(1);
                fh = FluidUtil.getFluidHandler((ItemStack)copiedFluidContainer);
                FluidStack drainable = fh.drain(this.myDuality.getTanks().getTankProperties()[slot].getCapacity(), false);
                if (drainable != null) {
                    fh.drain(drainable, true);
                    this.myDuality.getTanks().fill(drainable, true);
                }
                if (held.func_190916_E() == 1) {
                    player.field_71071_by.func_70437_b(fh.getContainer());
                    continue;
                }
                player.field_71071_by.func_70445_o().func_190918_g(1);
                if (player.field_71071_by.func_70441_a(fh.getContainer())) continue;
                player.func_71019_a(fh.getContainer(), false);
            }
        }
        this.updateHeld(player);
    }

    public void setTargetStack(IAEFluidStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetFluid == null) {
                return;
            }
            if (stack != null && this.clientRequestedTargetFluid != null && stack.getFluidStack().isFluidEqual(this.clientRequestedTargetFluid.getFluidStack())) {
                return;
            }
            NetworkHandler.instance().sendToServer(new PacketTargetFluidStack((AEFluidStack)stack));
        }
        this.clientRequestedTargetFluid = stack == null ? null : stack.copy();
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 2;
    }
}

