/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.settings;

import appeng.core.AEConfig;

public enum TickRates {
    Interface(1, 1),
    ImportBus(4, 35),
    FluidImportBus(4, 35),
    ExportBus(4, 35),
    FluidExportBus(4, 35),
    AnnihilationPlane(3, 80),
    METunnel(5, 20),
    Inscriber(1, 1),
    Charger(1, 10),
    IOPort(1, 1),
    VibrationChamber(10, 40),
    StorageBus(4, 35),
    FluidStorageBus(4, 35),
    ItemTunnel(3, 60),
    LightTunnel(3, 60),
    OpenComputersTunnel(1, 5),
    PressureTunnel(1, 120),
    SolarBasic(1, 4),
    SolarImproved(1, 4),
    SolarAdvanced(1, 4),
    SolarPerfect(1, 4);

    private int min;
    private int max;

    private TickRates(int min, int max) {
        this.setMin(min);
        this.setMax(max);
    }

    public void Load(AEConfig config) {
        config.addCustomCategoryComment("TickRates", " Min / Max Tickrates for dynamic ticking, most of these components also use sleeping, to prevent constant ticking, adjust with care, non standard rates are not supported or tested.");
        this.setMin(config.get("TickRates", this.name() + ".min", this.getMin()).getInt(this.getMin()));
        this.setMax(config.get("TickRates", this.name() + ".max", this.getMax()).getInt(this.getMax()));
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }
}

