/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.parts.IPart;
import appeng.api.util.IConfigManager;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFakeTypeOnly;
import appeng.items.contents.NetworkToolViewer;
import appeng.items.tools.ToolNetworkTool;
import appeng.parts.automation.PartExportBus;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class ContainerUpgradeableImp
extends AEBaseContainer
implements IOptionalSlotHost {
    private final IUpgradeableHost upgradeable;
    @GuiSync(value=0)
    public RedstoneMode rsMode = RedstoneMode.IGNORE;
    @GuiSync(value=1)
    public FuzzyMode fzMode = FuzzyMode.IGNORE_ALL;
    @GuiSync(value=5)
    public YesNo cMode = YesNo.NO;
    @GuiSync(value=6)
    public SchedulingMode schedulingMode = SchedulingMode.DEFAULT;
    private int tbSlot;
    private NetworkToolViewer tbInventory;

    public ContainerUpgradeableImp(InventoryPlayer ip, IUpgradeableHost te) {
        super(ip, (TileEntity)(te instanceof TileEntity ? te : null), (IPart)((Object)(te instanceof IPart ? te : null)));
        this.upgradeable = te;
        World w = null;
        int xCoord = 0;
        int yCoord = 0;
        int zCoord = 0;
        if (te instanceof TileEntity) {
            TileEntity myTile = (TileEntity)te;
            w = myTile.func_145831_w();
            xCoord = myTile.func_174877_v().func_177958_n();
            yCoord = myTile.func_174877_v().func_177956_o();
            zCoord = myTile.func_174877_v().func_177952_p();
        }
        if (te instanceof IPart) {
            TileEntity mk = te.getTile();
            w = mk.func_145831_w();
            xCoord = mk.func_174877_v().func_177958_n();
            yCoord = mk.func_174877_v().func_177956_o();
            zCoord = mk.func_174877_v().func_177952_p();
        }
        InventoryPlayer pi = this.getPlayerInv();
        for (int x = 0; x < pi.func_70302_i_(); ++x) {
            ItemStack pii = pi.func_70301_a(x);
            if (pii.func_190926_b() || !(pii.func_77973_b() instanceof ToolNetworkTool)) continue;
            this.lockPlayerInventorySlot(x);
            this.tbSlot = x;
            this.tbInventory = (NetworkToolViewer)((IGuiItem)pii.func_77973_b()).getGuiObject(pii, w, new BlockPos(xCoord, yCoord, zCoord));
            break;
        }
        this.setupConfig();
        this.bindPlayerInventory(ip, 0, this.getHeight() - 82);
    }

    public boolean hasToolbox() {
        return this.tbInventory != null;
    }

    protected int getHeight() {
        return 184;
    }

    protected void setupConfig() {
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        int y = 40;
        int x = 80;
        this.func_75146_a(new SlotFakeTypeOnly(inv, 0, 80, 40));
    }

    protected boolean supportCapacity() {
        return true;
    }

    public int availableUpgrades() {
        return 0;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            IConfigManager cm = this.getUpgradeable().getConfigManager();
            this.loadSettingsFromHost(cm);
        }
        for (Object o : this.field_75151_b) {
            OptionalSlotFake fs;
            if (!(o instanceof OptionalSlotFake) || (fs = (OptionalSlotFake)o).isSlotEnabled() || fs.getDisplayStack().func_190926_b()) continue;
            fs.clearStack();
        }
        this.standardDetectAndSendChanges();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
        this.setRedStoneMode((RedstoneMode)cm.getSetting(Settings.REDSTONE_CONTROLLED));
        if (this.getUpgradeable() instanceof PartExportBus) {
            this.setCraftingMode((YesNo)cm.getSetting(Settings.CRAFT_ONLY));
            this.setSchedulingMode((SchedulingMode)cm.getSetting(Settings.SCHEDULING_MODE));
        }
    }

    protected void standardDetectAndSendChanges() {
        super.func_75142_b();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        return true;
    }

    public FuzzyMode getFuzzyMode() {
        return this.fzMode;
    }

    public void setFuzzyMode(FuzzyMode fzMode) {
        this.fzMode = fzMode;
    }

    public YesNo getCraftingMode() {
        return this.cMode;
    }

    public void setCraftingMode(YesNo cMode) {
        this.cMode = cMode;
    }

    public RedstoneMode getRedStoneMode() {
        return this.rsMode;
    }

    public void setRedStoneMode(RedstoneMode rsMode) {
        this.rsMode = rsMode;
    }

    public SchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    private void setSchedulingMode(SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    protected IUpgradeableHost getUpgradeable() {
        return this.upgradeable;
    }
}

