/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.client.me.SlotDisconnected;
import appeng.container.AEBaseContainer;
import appeng.container.slot.AppEngSlot;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.DualityInterfaceImp;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.helpers.ItemStackHelper;
import appeng.items.misc.ItemEncodedPattern;
import appeng.parts.misc.PartInterfaceImp;
import appeng.parts.reporting.PartInterfaceTerminalImp;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.TileInterfaceImp;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.WrapperRangeItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public final class ContainerInterfaceTerminalImp
extends AEBaseContainer {
    private static long autoBase = Long.MIN_VALUE;
    private final Map<IInterfaceHost, InvTracker> diList = new HashMap<IInterfaceHost, InvTracker>();
    private final Map<Long, InvTracker> byId = new HashMap<Long, InvTracker>();
    private IGrid grid;
    private NBTTagCompound data = new NBTTagCompound();

    public ContainerInterfaceTerminalImp(InventoryPlayer ip, PartInterfaceTerminalImp anchor) {
        super(ip, anchor);
        if (Platform.isServer()) {
            this.grid = anchor.getActionableNode().getGrid();
        }
        this.bindPlayerInventory(ip, 0, 0);
    }

    @Override
    public void func_75142_b() {
        IGridNode agn;
        if (Platform.isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterfaceImp dual;
            InvTracker t;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterfaceImp.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)((Object)gn.getMachine())).getInterfaceDualityImp().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDualityImp();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
            for (IGridNode gn : this.grid.getMachines(PartInterfaceImp.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)((Object)gn.getMachine())).getInterfaceDualityImp().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDualityImp();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
        }
        if (total != this.diList.size() || missing) {
            this.regenList(this.data);
        } else {
            for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
                InvTracker inv = en.getValue();
                for (int x = 0; x < inv.server.getSlots(); ++x) {
                    if (!this.isDifferent(inv.server.getStackInSlot(x), inv.client.getStackInSlot(x))) continue;
                    this.addItems(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.func_82582_d()) {
            try {
                NetworkHandler.instance().sendTo(new PacketCompressedNBT(this.data), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = new NBTTagCompound();
        }
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        InvTracker inv = this.byId.get(id);
        if (inv != null) {
            if (action == InventoryAction.PLACE_SINGLE) {
                AppEngSlot playerSlot;
                try {
                    playerSlot = (AppEngSlot)((Object)this.field_75151_b.get(slot));
                }
                catch (IndexOutOfBoundsException ignored) {
                    return;
                }
                if (!playerSlot.isPlayerSide() || !playerSlot.func_75216_d()) {
                    return;
                }
                ItemStack itemStack = playerSlot.func_75211_c();
                if (!itemStack.func_190926_b()) {
                    WrapperFilteredItemHandler handler = new WrapperFilteredItemHandler((IItemHandler)new WrapperRangeItemHandler(inv.server, 0, 36), new PatternSlotFilter());
                    playerSlot.func_75215_d(ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack, (boolean)false));
                    this.func_75142_b();
                }
                return;
            }
            ItemStack is = inv.server.getStackInSlot(slot);
            boolean hasItemInHand = !player.field_71071_by.func_70445_o().func_190926_b();
            AdaptorItemHandler playerHand = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
            WrapperFilteredItemHandler theSlot = new WrapperFilteredItemHandler((IItemHandler)new WrapperRangeItemHandler(inv.server, slot, slot + 1), new PatternSlotFilter());
            AdaptorItemHandler interfaceSlot = new AdaptorItemHandler((IItemHandler)theSlot);
            IItemHandler interfaceHandler = inv.server;
            boolean canInsert = true;
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hasItemInHand) {
                        for (int s = 0; s < interfaceHandler.getSlots(); ++s) {
                            if (!Platform.itemComparisons().isSameItem(interfaceHandler.getStackInSlot(s), player.field_71071_by.func_70445_o())) continue;
                            canInsert = false;
                            break;
                        }
                        if (!canInsert) break;
                        ItemStack inSlot = theSlot.getStackInSlot(0);
                        if (inSlot.func_190926_b()) {
                            player.field_71071_by.func_70437_b(((InventoryAdaptor)interfaceSlot).addItems(player.field_71071_by.func_70445_o()));
                            break;
                        }
                        inSlot = inSlot.func_77946_l();
                        ItemStack inHand = player.field_71071_by.func_70445_o().func_77946_l();
                        ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, ItemStack.field_190927_a);
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                        player.field_71071_by.func_70437_b(((InventoryAdaptor)interfaceSlot).addItems(inHand.func_77946_l()));
                        if (player.field_71071_by.func_70445_o().func_190926_b()) {
                            player.field_71071_by.func_70437_b(inSlot);
                            break;
                        }
                        player.field_71071_by.func_70437_b(inHand);
                        ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, inSlot);
                        break;
                    }
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, ((InventoryAdaptor)playerHand).addItems(theSlot.getStackInSlot(0)));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (hasItemInHand) {
                        for (int s = 0; s < interfaceHandler.getSlots(); ++s) {
                            if (!Platform.itemComparisons().isSameItem(interfaceHandler.getStackInSlot(s), player.field_71071_by.func_70445_o())) continue;
                            canInsert = false;
                            break;
                        }
                        if (!canInsert) break;
                        ItemStack extra = ((InventoryAdaptor)playerHand).removeItems(1, ItemStack.field_190927_a, null);
                        if (!extra.func_190926_b() && !((InventoryAdaptor)interfaceSlot).containsItems()) {
                            extra = ((InventoryAdaptor)interfaceSlot).addItems(extra);
                        }
                        if (extra.func_190926_b()) break;
                        ((InventoryAdaptor)playerHand).addItems(extra);
                        break;
                    }
                    if (is.func_190926_b()) break;
                    ItemStack extra = ((InventoryAdaptor)interfaceSlot).removeItems((is.func_190916_E() + 1) / 2, ItemStack.field_190927_a, null);
                    if (!extra.func_190926_b()) {
                        extra = ((InventoryAdaptor)playerHand).addItems(extra);
                    }
                    if (extra.func_190926_b()) break;
                    ((InventoryAdaptor)interfaceSlot).addItems(extra);
                    break;
                }
                case SHIFT_CLICK: {
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, playerInv.addItems(theSlot.getStackInSlot(0)));
                    break;
                }
                case MOVE_REGION: {
                    InventoryAdaptor playerInvAd = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                    for (int x = 0; x < inv.server.getSlots(); ++x) {
                        ItemHandlerUtil.setStackInSlot(inv.server, x, playerInvAd.addItems(inv.server.getStackInSlot(x)));
                    }
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.field_71075_bZ.field_75098_d || hasItemInHand) break;
                    player.field_71071_by.func_70437_b(is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterfaceImp dual;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterfaceImp.class)) {
                ih = (IInterfaceHost)((Object)gn.getMachine());
                dual = ih.getInterfaceDualityImp();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
            for (IGridNode gn : this.grid.getMachines(PartInterfaceImp.class)) {
                ih = (IInterfaceHost)((Object)gn.getMachine());
                dual = ih.getInterfaceDualityImp();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
        }
        data.func_74757_a("clear", true);
        for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
            InvTracker inv = en.getValue();
            this.byId.put(inv.which, inv);
            this.addItems(data, inv, 0, inv.server.getSlots());
        }
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return false;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return !ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    private void addItems(NBTTagCompound data, InvTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        NBTTagCompound tag = data.func_74775_l(name);
        if (tag.func_82582_d()) {
            tag.func_74772_a("sortBy", inv.sortBy);
            tag.func_74778_a("un", inv.unlocalizedName);
            tag.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)inv.pos));
            tag.func_74768_a("dim", inv.dim);
            tag.func_74768_a("numUpgrades", inv.numUpgrades);
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            ItemStack is = inv.server.getStackInSlot(x + offset);
            ItemHandlerUtil.setStackInSlot(inv.client, x + offset, is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
            if (!is.func_190926_b()) {
                ItemStackHelper.stackWriteToNBT(is, itemNBT);
            }
            tag.func_74782_a(Integer.toString(x + offset), (NBTBase)itemNBT);
        }
        data.func_74782_a(name, (NBTBase)tag);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        AppEngSlot playerAppEngSlot;
        Slot playerSlot;
        if (Platform.isClient() && (playerSlot = (Slot)this.field_75151_b.get(idx)) instanceof AppEngSlot && (playerAppEngSlot = (AppEngSlot)playerSlot).isPlayerSide()) {
            for (Slot slot : this.field_75151_b) {
                if (!(slot instanceof SlotDisconnected)) continue;
                SlotDisconnected slotDisconnected = (SlotDisconnected)slot;
                if (slot.func_75216_d()) continue;
                PacketInventoryAction packet = new PacketInventoryAction(InventoryAction.PLACE_SINGLE, playerAppEngSlot.field_75222_d, slotDisconnected.getSlot().getId());
                NetworkHandler.instance().sendToServer(packet);
                return ItemStack.field_190927_a;
            }
        }
        return super.func_82846_b(p, idx);
    }

    static /* synthetic */ long access$908() {
        return autoBase++;
    }

    private static class InvTracker {
        private final long sortBy;
        private final long which = ContainerInterfaceTerminalImp.access$908();
        private final String unlocalizedName;
        private final IItemHandler client;
        private final IItemHandler server;
        private final BlockPos pos;
        private final int dim;
        private final int numUpgrades;

        public InvTracker(DualityInterfaceImp dual, IItemHandler patterns, String unlocalizedName) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(null, this.server.getSlots());
            this.unlocalizedName = unlocalizedName;
            this.sortBy = dual.getSortValue();
            this.pos = dual.getLocation().getPos();
            this.dim = dual.getLocation().getWorld().field_73011_w.getDimension();
            this.numUpgrades = dual.getInstalledUpgrades(Upgrades.PATTERN_EXPANSION);
        }
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemEncodedPattern;
        }
    }
}

