/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.block.crafting.BlockCraftingUnit;
import appeng.client.render.crafting.LightBakedModel;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.crafting.UnitBakedModel;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

class CraftingCubeModel
implements IModel {
    private static final ResourceLocation RING_CORNER = CraftingCubeModel.texture("ring_corner");
    private static final ResourceLocation RING_SIDE_HOR = CraftingCubeModel.texture("ring_side_hor");
    private static final ResourceLocation RING_SIDE_VER = CraftingCubeModel.texture("ring_side_ver");
    private static final ResourceLocation UNIT_BASE = CraftingCubeModel.texture("unit_base");
    private static final ResourceLocation LIGHT_BASE = CraftingCubeModel.texture("light_base");
    private static final ResourceLocation ACCELERATOR_LIGHT = CraftingCubeModel.texture("accelerator_light");
    private static final ResourceLocation ACCELERATOR_4X_LIGHT = CraftingCubeModel.texture("accelerator_4x_light");
    private static final ResourceLocation ACCELERATOR_16X_LIGHT = CraftingCubeModel.texture("accelerator_16x_light");
    private static final ResourceLocation ACCELERATOR_64X_LIGHT = CraftingCubeModel.texture("accelerator_64x_light");
    private static final ResourceLocation ACCELERATOR_128X_LIGHT = CraftingCubeModel.texture("accelerator_128x_light");
    private static final ResourceLocation ACCELERATOR_256X_LIGHT = CraftingCubeModel.texture("accelerator_256x_light");
    private static final ResourceLocation ACCELERATOR_512X_LIGHT = CraftingCubeModel.texture("accelerator_512x_light");
    private static final ResourceLocation ACCELERATOR_1024X_LIGHT = CraftingCubeModel.texture("accelerator_1024x_light");
    private static final ResourceLocation ACCELERATOR_CREATIVE_LIGHT = CraftingCubeModel.texture("accelerator_creative_light");
    private static final ResourceLocation STORAGE_1K_LIGHT = CraftingCubeModel.texture("storage_1k_light");
    private static final ResourceLocation STORAGE_4K_LIGHT = CraftingCubeModel.texture("storage_4k_light");
    private static final ResourceLocation STORAGE_16K_LIGHT = CraftingCubeModel.texture("storage_16k_light");
    private static final ResourceLocation STORAGE_64K_LIGHT = CraftingCubeModel.texture("storage_64k_light");
    private static final ResourceLocation STORAGE_1MB_LIGHT = CraftingCubeModel.texture("storage_1mb_light");
    private static final ResourceLocation STORAGE_4MB_LIGHT = CraftingCubeModel.texture("storage_4mb_light");
    private static final ResourceLocation STORAGE_16MB_LIGHT = CraftingCubeModel.texture("storage_16mb_light");
    private static final ResourceLocation STORAGE_64MB_LIGHT = CraftingCubeModel.texture("storage_64mb_light");
    private static final ResourceLocation STORAGE_256MB_LIGHT = CraftingCubeModel.texture("storage_256mb_light");
    private static final ResourceLocation STORAGE_1GB_LIGHT = CraftingCubeModel.texture("storage_1gb_light");
    private static final ResourceLocation STORAGE_2GB_LIGHT = CraftingCubeModel.texture("storage_15gb_light");
    private static final ResourceLocation STORAGE_CREATIVE_LIGHT = CraftingCubeModel.texture("storage_creative_light");
    private static final ResourceLocation MONITOR_BASE = CraftingCubeModel.texture("monitor_base");
    private static final ResourceLocation MONITOR_LIGHT_DARK = CraftingCubeModel.texture("monitor_light_dark");
    private static final ResourceLocation MONITOR_LIGHT_MEDIUM = CraftingCubeModel.texture("monitor_light_medium");
    private static final ResourceLocation MONITOR_LIGHT_BRIGHT = CraftingCubeModel.texture("monitor_light_bright");
    private final BlockCraftingUnit.CraftingUnitType type;

    CraftingCubeModel(BlockCraftingUnit.CraftingUnitType type) {
        this.type = type;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)RING_CORNER, (Object)RING_SIDE_HOR, (Object)RING_SIDE_VER, (Object)UNIT_BASE, (Object)LIGHT_BASE, (Object)ACCELERATOR_LIGHT, (Object)ACCELERATOR_4X_LIGHT, (Object)ACCELERATOR_16X_LIGHT, (Object)ACCELERATOR_64X_LIGHT, (Object)ACCELERATOR_128X_LIGHT, (Object)ACCELERATOR_256X_LIGHT, (Object)ACCELERATOR_512X_LIGHT, (Object[])new ResourceLocation[]{ACCELERATOR_1024X_LIGHT, ACCELERATOR_CREATIVE_LIGHT, STORAGE_1K_LIGHT, STORAGE_4K_LIGHT, STORAGE_16K_LIGHT, STORAGE_64K_LIGHT, STORAGE_1MB_LIGHT, STORAGE_4MB_LIGHT, STORAGE_16MB_LIGHT, STORAGE_64MB_LIGHT, STORAGE_256MB_LIGHT, STORAGE_1GB_LIGHT, STORAGE_2GB_LIGHT, STORAGE_CREATIVE_LIGHT, MONITOR_BASE, MONITOR_LIGHT_DARK, MONITOR_LIGHT_MEDIUM, MONITOR_LIGHT_BRIGHT});
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite ringCorner = bakedTextureGetter.apply(RING_CORNER);
        TextureAtlasSprite ringSideHor = bakedTextureGetter.apply(RING_SIDE_HOR);
        TextureAtlasSprite ringSideVer = bakedTextureGetter.apply(RING_SIDE_VER);
        switch (this.type) {
            case UNIT: {
                return new UnitBakedModel(format, ringCorner, ringSideHor, ringSideVer, bakedTextureGetter.apply(UNIT_BASE));
            }
            case STORAGE_1K: 
            case STORAGE_4K: 
            case STORAGE_16K: 
            case STORAGE_64K: 
            case STORAGE_1MB: 
            case STORAGE_4MB: 
            case STORAGE_16MB: 
            case STORAGE_64MB: 
            case STORAGE_256MB: 
            case STORAGE_1GB: 
            case STORAGE_2GB: 
            case STORAGE_CREATIVE: 
            case ACCELERATOR: 
            case ACCELERATOR_4X: 
            case ACCELERATOR_16X: 
            case ACCELERATOR_64X: 
            case ACCELERATOR_128X: 
            case ACCELERATOR_256X: 
            case ACCELERATOR_512X: 
            case ACCELERATOR_1024X: 
            case ACCELERATOR_CREATIVE: {
                return new LightBakedModel(format, ringCorner, ringSideHor, ringSideVer, bakedTextureGetter.apply(LIGHT_BASE), CraftingCubeModel.getLightTexture(bakedTextureGetter, this.type));
            }
            case MONITOR: {
                return new MonitorBakedModel(format, ringCorner, ringSideHor, ringSideVer, bakedTextureGetter.apply(UNIT_BASE), bakedTextureGetter.apply(MONITOR_BASE), bakedTextureGetter.apply(MONITOR_LIGHT_DARK), bakedTextureGetter.apply(MONITOR_LIGHT_MEDIUM), bakedTextureGetter.apply(MONITOR_LIGHT_BRIGHT));
            }
        }
        throw new IllegalArgumentException("Unsupported crafting unit type: " + (Object)((Object)this.type));
    }

    private static TextureAtlasSprite getLightTexture(Function<ResourceLocation, TextureAtlasSprite> textureGetter, BlockCraftingUnit.CraftingUnitType type) {
        switch (type) {
            case ACCELERATOR: {
                return textureGetter.apply(ACCELERATOR_LIGHT);
            }
            case ACCELERATOR_4X: {
                return textureGetter.apply(ACCELERATOR_4X_LIGHT);
            }
            case ACCELERATOR_16X: {
                return textureGetter.apply(ACCELERATOR_16X_LIGHT);
            }
            case ACCELERATOR_64X: {
                return textureGetter.apply(ACCELERATOR_64X_LIGHT);
            }
            case ACCELERATOR_128X: {
                return textureGetter.apply(ACCELERATOR_128X_LIGHT);
            }
            case ACCELERATOR_256X: {
                return textureGetter.apply(ACCELERATOR_256X_LIGHT);
            }
            case ACCELERATOR_512X: {
                return textureGetter.apply(ACCELERATOR_512X_LIGHT);
            }
            case ACCELERATOR_1024X: {
                return textureGetter.apply(ACCELERATOR_1024X_LIGHT);
            }
            case ACCELERATOR_CREATIVE: {
                return textureGetter.apply(ACCELERATOR_CREATIVE_LIGHT);
            }
            case STORAGE_1K: {
                return textureGetter.apply(STORAGE_1K_LIGHT);
            }
            case STORAGE_4K: {
                return textureGetter.apply(STORAGE_4K_LIGHT);
            }
            case STORAGE_16K: {
                return textureGetter.apply(STORAGE_16K_LIGHT);
            }
            case STORAGE_64K: {
                return textureGetter.apply(STORAGE_64K_LIGHT);
            }
            case STORAGE_1MB: {
                return textureGetter.apply(STORAGE_1MB_LIGHT);
            }
            case STORAGE_4MB: {
                return textureGetter.apply(STORAGE_4MB_LIGHT);
            }
            case STORAGE_16MB: {
                return textureGetter.apply(STORAGE_16MB_LIGHT);
            }
            case STORAGE_64MB: {
                return textureGetter.apply(STORAGE_64MB_LIGHT);
            }
            case STORAGE_256MB: {
                return textureGetter.apply(STORAGE_256MB_LIGHT);
            }
            case STORAGE_1GB: {
                return textureGetter.apply(STORAGE_1GB_LIGHT);
            }
            case STORAGE_2GB: {
                return textureGetter.apply(STORAGE_2GB_LIGHT);
            }
            case STORAGE_CREATIVE: {
                return textureGetter.apply(STORAGE_CREATIVE_LIGHT);
            }
        }
        throw new IllegalArgumentException("Crafting unit type " + (Object)((Object)type) + " does not use a light texture. Beecube, are you stupid?");
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private static ResourceLocation texture(String name) {
        return new ResourceLocation("appliedenergistics2", "blocks/crafting/" + name);
    }
}

