/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.api.config.ItemSubstitution;
import appeng.api.config.Settings;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.implementations.ContainerPatternEncoder;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerWirelessPatternTerminal;
import appeng.container.interfaces.IJEIGhostIngredients;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotFake;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.InventoryAction;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.util.item.AEItemStack;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiPatternTerm
extends GuiMEMonitorable
implements IJEIGhostIngredients {
    private static final String BACKGROUND_CRAFTING_MODE = "guis/pattern.png";
    private static final String BACKGROUND_PROCESSING_MODE = "guis/pattern2.png";
    private static final String SUBSITUTION_DISABLE = "0";
    private static final String SUBSITUTION_ENABLE = "1";
    private static final String CRAFTMODE_CRFTING = "1";
    private static final String CRAFTMODE_PROCESSING = "0";
    private final ContainerPatternEncoder container;
    private GuiTabButton tabCraftButton;
    private GuiTabButton tabProcessButton;
    private GuiImgButton substitutionsEnabledBtn;
    private GuiImgButton substitutionsDisabledBtn;
    private GuiImgButton encodeBtn;
    private GuiImgButton clearBtn;
    private GuiImgButton x2Btn;
    private GuiImgButton x3Btn;
    private GuiImgButton plusOneBtn;
    private GuiImgButton divTwoBtn;
    private GuiImgButton divThreeBtn;
    private GuiImgButton minusOneBtn;
    private GuiImgButton maxCountBtn;
    public Map<IGhostIngredientHandler.Target<?>, Object> mapTargetSlot = new HashMap();

    public GuiPatternTerm(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(inventoryPlayer, te, new ContainerPatternTerm(inventoryPlayer, te));
        this.container = (ContainerPatternTerm)this.field_147002_h;
        this.setReservedSpace(81);
    }

    public GuiPatternTerm(InventoryPlayer inventoryPlayer, WirelessTerminalGuiObject te, ContainerWirelessPatternTerminal wpt) {
        super(inventoryPlayer, te, wpt);
        this.container = (ContainerWirelessPatternTerminal)this.field_147002_h;
        this.setReservedSpace(81);
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        try {
            if (this.tabCraftButton == btn || this.tabProcessButton == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.CraftMode", this.tabProcessButton == btn ? "1" : "0"));
            }
            if (this.encodeBtn == btn) {
                if (GuiPatternTerm.func_146272_n()) {
                    NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.Encode", "2"));
                } else {
                    NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.Encode", "1"));
                }
            }
            if (this.clearBtn == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.Clear", "1"));
            }
            if (this.x2Btn == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.MultiplyByTwo", "1"));
            }
            if (this.x3Btn == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.MultiplyByThree", "1"));
            }
            if (this.divTwoBtn == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.DivideByTwo", "1"));
            }
            if (this.divThreeBtn == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.DivideByThree", "1"));
            }
            if (this.plusOneBtn == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.IncreaseByOne", "1"));
            }
            if (this.minusOneBtn == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.DecreaseByOne", "1"));
            }
            if (this.maxCountBtn == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.MaximizeCount", "1"));
            }
            if (this.substitutionsEnabledBtn == btn || this.substitutionsDisabledBtn == btn) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.Substitute", this.substitutionsEnabledBtn == btn ? "0" : "1"));
            }
        }
        catch (IOException e) {
            AELog.error(e);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabCraftButton = new GuiTabButton(this.field_147003_i + 173, this.field_147009_r + this.field_147000_g - 177, new ItemStack(Blocks.field_150462_ai), GuiText.CraftingPattern.getLocal(), this.field_146296_j);
        this.field_146292_n.add(this.tabCraftButton);
        this.tabProcessButton = new GuiTabButton(this.field_147003_i + 173, this.field_147009_r + this.field_147000_g - 177, new ItemStack(Blocks.field_150460_al), GuiText.ProcessingPattern.getLocal(), this.field_146296_j);
        this.field_146292_n.add(this.tabProcessButton);
        this.substitutionsEnabledBtn = new GuiImgButton(this.field_147003_i + 84, this.field_147009_r + this.field_147000_g - 163, Settings.ACTIONS, ItemSubstitution.ENABLED);
        this.substitutionsEnabledBtn.setHalfSize(true);
        this.field_146292_n.add(this.substitutionsEnabledBtn);
        this.substitutionsDisabledBtn = new GuiImgButton(this.field_147003_i + 84, this.field_147009_r + this.field_147000_g - 163, Settings.ACTIONS, ItemSubstitution.DISABLED);
        this.substitutionsDisabledBtn.setHalfSize(true);
        this.field_146292_n.add(this.substitutionsDisabledBtn);
        this.clearBtn = new GuiImgButton(this.field_147003_i + 74, this.field_147009_r + this.field_147000_g - 163, Settings.ACTIONS, ActionItems.CLOSE);
        this.clearBtn.setHalfSize(true);
        this.field_146292_n.add(this.clearBtn);
        this.x3Btn = new GuiImgButton(this.field_147003_i + 128, this.field_147009_r + this.field_147000_g - 158, Settings.ACTIONS, ActionItems.MULTIPLY_BY_THREE);
        this.x3Btn.setHalfSize(true);
        this.field_146292_n.add(this.x3Btn);
        this.x2Btn = new GuiImgButton(this.field_147003_i + 128, this.field_147009_r + this.field_147000_g - 148, Settings.ACTIONS, ActionItems.MULTIPLY_BY_TWO);
        this.x2Btn.setHalfSize(true);
        this.field_146292_n.add(this.x2Btn);
        this.plusOneBtn = new GuiImgButton(this.field_147003_i + 128, this.field_147009_r + this.field_147000_g - 138, Settings.ACTIONS, ActionItems.INCREASE_BY_ONE);
        this.plusOneBtn.setHalfSize(true);
        this.field_146292_n.add(this.plusOneBtn);
        this.divThreeBtn = new GuiImgButton(this.field_147003_i + 100, this.field_147009_r + this.field_147000_g - 158, Settings.ACTIONS, ActionItems.DIVIDE_BY_THREE);
        this.divThreeBtn.setHalfSize(true);
        this.field_146292_n.add(this.divThreeBtn);
        this.divTwoBtn = new GuiImgButton(this.field_147003_i + 100, this.field_147009_r + this.field_147000_g - 148, Settings.ACTIONS, ActionItems.DIVIDE_BY_TWO);
        this.divTwoBtn.setHalfSize(true);
        this.field_146292_n.add(this.divTwoBtn);
        this.minusOneBtn = new GuiImgButton(this.field_147003_i + 100, this.field_147009_r + this.field_147000_g - 138, Settings.ACTIONS, ActionItems.DECREASE_BY_ONE);
        this.minusOneBtn.setHalfSize(true);
        this.field_146292_n.add(this.minusOneBtn);
        this.encodeBtn = new GuiImgButton(this.field_147003_i + 147, this.field_147009_r + this.field_147000_g - 142, Settings.ACTIONS, ActionItems.ENCODE);
        this.field_146292_n.add(this.encodeBtn);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.container.isCraftingMode()) {
            this.tabCraftButton.field_146125_m = true;
            this.tabProcessButton.field_146125_m = false;
            this.x2Btn.field_146125_m = false;
            this.x3Btn.field_146125_m = false;
            this.divTwoBtn.field_146125_m = false;
            this.divThreeBtn.field_146125_m = false;
            this.plusOneBtn.field_146125_m = false;
            this.minusOneBtn.field_146125_m = false;
            if (this.container.substitute) {
                this.substitutionsEnabledBtn.field_146125_m = true;
                this.substitutionsDisabledBtn.field_146125_m = false;
            } else {
                this.substitutionsEnabledBtn.field_146125_m = false;
                this.substitutionsDisabledBtn.field_146125_m = true;
            }
        } else {
            this.tabCraftButton.field_146125_m = false;
            this.tabProcessButton.field_146125_m = true;
            this.substitutionsEnabledBtn.field_146125_m = false;
            this.substitutionsDisabledBtn.field_146125_m = false;
            this.x2Btn.field_146125_m = true;
            this.x3Btn.field_146125_m = true;
            this.divTwoBtn.field_146125_m = true;
            this.divThreeBtn.field_146125_m = true;
            this.plusOneBtn.field_146125_m = true;
            this.minusOneBtn.field_146125_m = true;
        }
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        this.field_146289_q.func_78276_b(GuiText.PatternTerminal.getLocal(), 8, this.field_147000_g - 96 + 2 - this.getReservedSpace(), 0x404040);
    }

    @Override
    protected String getBackground() {
        if (this.container.isCraftingMode()) {
            return BACKGROUND_CRAFTING_MODE;
        }
        return BACKGROUND_PROCESSING_MODE;
    }

    @Override
    protected void repositionSlot(AppEngSlot s) {
        int offsetPlayerSide = s.isPlayerSide() ? 5 : 3;
        s.field_75221_f = s.getY() + this.field_147000_g - 78 - offsetPlayerSide;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        ArrayList targets = new ArrayList();
        for (final Slot slot : this.field_147002_h.field_75151_b) {
            if (!(slot instanceof SlotFake)) continue;
            final ItemStack itemStack = (ItemStack)ingredient;
            IGhostIngredientHandler.Target<Object> target = new IGhostIngredientHandler.Target<Object>(){

                public Rectangle getArea() {
                    return new Rectangle(GuiPatternTerm.this.getGuiLeft() + slot.field_75223_e, GuiPatternTerm.this.getGuiTop() + slot.field_75221_f, 16, 16);
                }

                public void accept(Object ingredient) {
                    try {
                        PacketInventoryAction p = new PacketInventoryAction(InventoryAction.PLACE_JEI_GHOST_ITEM, (SlotFake)slot, (IAEItemStack)AEItemStack.fromItemStack(itemStack));
                        NetworkHandler.instance().sendToServer(p);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            targets.add(target);
            this.mapTargetSlot.putIfAbsent(target, slot);
        }
        return targets;
    }

    @Override
    public Map<IGhostIngredientHandler.Target<?>, Object> getFakeSlotTargetMap() {
        return this.mapTargetSlot;
    }
}

