/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.implementations.ContainerInterfaceTerminal;
import appeng.container.slot.AppEngSlot;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.helpers.ItemStackHelper;
import appeng.parts.reporting.PartInterfaceTerminal;
import appeng.util.BlockPosUtils;
import appeng.util.Platform;
import com.google.common.collect.HashMultimap;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.input.Mouse;

public class GuiInterfaceTerminal
extends AEBaseGui {
    private int rows = 6;
    private final int offsetX = 21;
    private int maxRows = Integer.MAX_VALUE;
    protected int jeiOffset = Loader.isModLoaded((String)"jei") ? 24 : 0;
    private int reservedSpace = 0;
    private final HashMap<Long, ClientDCInternalInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalInv> byName = HashMultimap.create();
    private final HashMap<ClientDCInternalInv, BlockPos> blockPosHashMap = new HashMap();
    private final HashMap<GuiButton, ClientDCInternalInv> guiButtonHashMap = new HashMap();
    private final Map<ClientDCInternalInv, Integer> numUpgradesMap = new HashMap<ClientDCInternalInv, Integer>();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Set<Object> matchedStacks = new HashSet<Object>();
    private final Set<ClientDCInternalInv> matchedInterfaces = new HashSet<ClientDCInternalInv>();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private boolean refreshList = false;
    private MEGuiTextField searchFieldOutputs;
    private MEGuiTextField searchFieldInputs;
    private final PartInterfaceTerminal partInterfaceTerminal;
    private GuiButton guiButtonHide;
    private GuiButton guiButtonNextAssembler;
    private GuiImgButton terminalStyleBox;
    private final HashMap<ClientDCInternalInv, Integer> dimHashMap = new HashMap();
    private int drawnRows = 0;

    public GuiInterfaceTerminal(InventoryPlayer inventoryPlayer, PartInterfaceTerminal te) {
        super(new ContainerInterfaceTerminal(inventoryPlayer, te));
        this.partInterfaceTerminal = te;
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.field_146999_f = 208;
        this.field_147000_g = 255;
        this.setReservedSpace(82);
    }

    @Override
    public void func_73866_w_() {
        this.maxRows = AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.TALL ? 6 : Integer.MAX_VALUE;
        int magicNumber = 96;
        int extraSpace = this.field_146295_m - 96 - this.reservedSpace;
        this.rows = (int)Math.floor(extraSpace / 18);
        if (this.rows > this.maxRows) {
            this.rows = this.maxRows;
        }
        if (this.rows < 6) {
            this.rows = 6;
        }
        this.field_147000_g = 96 + this.rows * 18 + this.reservedSpace;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = (int)Math.floor((float)unusedSpace / (unusedSpace < 0 ? 3.8f : 2.0f));
        super.func_73866_w_();
        this.getScrollBar().setLeft(189);
        this.getScrollBar().setHeight(106);
        this.getScrollBar().setTop(51);
        this.searchFieldInputs = new MEGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(32, this.offsetX), this.field_147009_r + 25, 65, 12);
        this.searchFieldInputs.func_146185_a(false);
        this.searchFieldInputs.func_146203_f(25);
        this.searchFieldInputs.func_146193_g(0xFFFFFF);
        this.searchFieldInputs.func_146189_e(true);
        this.searchFieldInputs.func_146195_b(false);
        this.searchFieldOutputs = new MEGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(32, this.offsetX), this.field_147009_r + 38, 65, 12);
        this.searchFieldOutputs.func_146185_a(false);
        this.searchFieldOutputs.func_146203_f(25);
        this.searchFieldOutputs.func_146193_g(0xFFFFFF);
        this.searchFieldOutputs.func_146189_e(true);
        this.searchFieldOutputs.func_146195_b(true);
        this.searchFieldInputs.func_146180_a(this.partInterfaceTerminal.in);
        this.searchFieldOutputs.func_146180_a(this.partInterfaceTerminal.out);
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.InterfaceTerminal.getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), this.offsetX + 2, this.field_147000_g - 96 + 3, 0x404040);
    }

    protected void repositionSlot(AppEngSlot s) {
        this.field_147000_g = 96 + this.drawnRows * 18 + this.reservedSpace;
        s.field_75221_f = s.getY() + this.field_147000_g - 112;
        s.field_75223_e = s.getX() + 14;
    }

    @Override
    public void func_146281_b() {
        this.partInterfaceTerminal.saveSearchStrings(this.searchFieldInputs.func_146179_b().toLowerCase(), this.searchFieldOutputs.func_146179_b().toLowerCase());
        super.func_146281_b();
    }

    @Override
    public List<Rectangle> getJEIExclusionArea() {
        Rectangle tallButton = new Rectangle(this.field_147003_i - 18, this.field_147009_r + 24 + this.jeiOffset, 18, 18);
        ArrayList<Rectangle> area = new ArrayList<Rectangle>();
        area.add(tallButton);
        return area;
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146292_n.clear();
        int currentScroll = this.getScrollBar().getCurrentScroll();
        this.guiButtonNextAssembler = new GuiImgButton(this.field_147003_i + 123, this.field_147009_r + 25, Settings.ACTIONS, ActionItems.FREE_MOLECULAR_SLOT_SHORTCUT);
        this.field_146292_n.add(this.guiButtonNextAssembler);
        this.guiButtonHide = new GuiImgButton(this.field_147003_i + 141, this.field_147009_r + 25, Settings.ACTIONS, this.partInterfaceTerminal.onlyInterfacesWithFreeSlots ? ActionItems.TOGGLE_SHOW_FULL_INTERFACES_OFF : ActionItems.TOGGLE_SHOW_FULL_INTERFACES_ON);
        this.field_146292_n.add(this.guiButtonHide);
        this.terminalStyleBox = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 24 + this.jeiOffset, Settings.TERMINAL_STYLE, AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE));
        this.field_146292_n.add(this.terminalStyleBox);
        this.field_147002_h.field_75151_b.removeIf(slot -> slot instanceof SlotDisconnected);
        for (Slot s : this.field_147002_h.field_75151_b) {
            if (!(s instanceof AppEngSlot) || s.field_75223_e >= 197) continue;
            this.repositionSlot((AppEngSlot)s);
        }
        int offset = 52;
        int linesDraw = 0;
        for (int x = 0; x < this.rows && linesDraw < this.rows && currentScroll + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(currentScroll + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                GuiImgButton guiButton = new GuiImgButton(this.field_147003_i + 4, this.field_147009_r + offset, Settings.ACTIONS, ActionItems.HIGHLIGHT_INTERFACE);
                this.guiButtonHashMap.put(guiButton, inv);
                this.field_146292_n.add(guiButton);
                int extraLines = this.numUpgradesMap.get(inv);
                for (int row = 0; row < 1 + extraLines && linesDraw < this.rows; ++row) {
                    for (int z = 0; z < 9; ++z) {
                        this.field_147002_h.field_75151_b.add(new SlotDisconnected(inv, z + row * 9, z * 18 + 22, offset));
                        if (this.matchedStacks.contains(inv.getInventory().getStackInSlot(z + row * 9))) {
                            GuiInterfaceTerminal.func_73734_a((int)(z * 18 + 22), (int)offset, (int)(z * 18 + 22 + 16), (int)(offset + 16), (int)-1979646208);
                            continue;
                        }
                        if (this.matchedInterfaces.contains(inv)) continue;
                        GuiInterfaceTerminal.func_73734_a((int)(z * 18 + 22), (int)offset, (int)(z * 18 + 22 + 16), (int)(offset + 16), (int)0x6A000000);
                    }
                    ++linesDraw;
                    offset += 18;
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            String name = (String)lineObj;
            int rows = this.byName.get((Object)name).size();
            if (rows > 1) {
                name = name + " (" + rows + ')';
            }
            while (name.length() > 2 && this.field_146289_q.func_78256_a(name) > 155) {
                name = name.substring(0, name.length() - 1);
            }
            this.field_146289_q.func_78276_b(name, this.offsetX + 2, 5 + offset, 0x404040);
            ++linesDraw;
            offset += 18;
        }
        if (this.searchFieldInputs.isMouseIn(mouseX, mouseY)) {
            this.drawTooltip(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - offsetX, mouseY - this.field_147009_r, "Inputs OR names");
        } else if (this.searchFieldOutputs.isMouseIn(mouseX, mouseY)) {
            this.drawTooltip(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - offsetX, mouseY - this.field_147009_r, "Outputs OR names");
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        this.searchFieldInputs.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchFieldInputs.isMouseIn(xCoord, yCoord)) {
            this.searchFieldInputs.func_146180_a("");
            this.refreshList();
        }
        this.searchFieldOutputs.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchFieldOutputs.isMouseIn(xCoord, yCoord)) {
            this.searchFieldOutputs.func_146180_a("");
            this.refreshList();
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        if (this.guiButtonHashMap.containsKey(btn)) {
            int interfaceDim;
            BlockPos blockPos = this.blockPosHashMap.get(this.guiButtonHashMap.get(this.field_146290_a));
            BlockPos blockPos2 = this.field_146297_k.field_71439_g.func_180425_c();
            int playerDim = this.field_146297_k.field_71441_e.field_73011_w.getDimension();
            if (playerDim != (interfaceDim = this.dimHashMap.get(this.guiButtonHashMap.get(this.field_146290_a)).intValue())) {
                try {
                    this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Interface located at dimension: " + interfaceDim + " [" + DimensionManager.getWorld((int)interfaceDim).field_73011_w.func_186058_p().func_186065_b() + "] and cant be highlighted"), false);
                }
                catch (Exception e) {
                    this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Interface is located in another dimension and cannot be highlighted"), false);
                }
            } else {
                BlockPosHighlighter.hilightBlock(blockPos, System.currentTimeMillis() + 500L * BlockPosUtils.getDistance(blockPos, blockPos2), playerDim);
                this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("The interface is now highlighted at X: " + blockPos.func_177958_n() + " Y: " + blockPos.func_177956_o() + " Z: " + blockPos.func_177952_p()), false);
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (btn instanceof GuiImgButton) {
            GuiImgButton iBtn = (GuiImgButton)btn;
            boolean backwards = Mouse.isButtonDown((int)1);
            if (iBtn.getSetting() != Settings.ACTIONS) {
                Enum cv = iBtn.getCurrentValue();
                Enum next = Platform.rotateEnum(cv, backwards, iBtn.getSetting().getPossibleValues());
                if (btn == this.terminalStyleBox) {
                    AEConfig.instance().getConfigManager().putSetting(iBtn.getSetting(), next);
                }
                iBtn.set(next);
                if (next.getClass() == TerminalStyle.class) {
                    this.reinitalize();
                }
            }
        }
        if (btn == this.guiButtonHide) {
            this.partInterfaceTerminal.onlyInterfacesWithFreeSlots = !this.partInterfaceTerminal.onlyInterfacesWithFreeSlots;
            this.refreshList();
        }
        if (btn == this.guiButtonNextAssembler) {
            boolean currentOnlyInterfacesWithFreeSlots = this.partInterfaceTerminal.onlyInterfacesWithFreeSlots;
            String currentSearchText = this.searchFieldOutputs.func_146179_b();
            this.partInterfaceTerminal.onlyInterfacesWithFreeSlots = true;
            this.searchFieldOutputs.func_146180_a("Molecular Assembler");
            this.refreshList();
            this.partInterfaceTerminal.onlyInterfacesWithFreeSlots = currentOnlyInterfacesWithFreeSlots;
            this.searchFieldOutputs.func_146180_a(currentSearchText);
        }
    }

    private void reinitalize() {
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/newinterfaceterminal.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 166);
        int offset = 51;
        int ex = this.getScrollBar().getCurrentScroll();
        int linesDraw = 0;
        for (int x = 0; x < this.rows && linesDraw < this.rows && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = 162;
                int extraLines = this.numUpgradesMap.get(lineObj);
                for (int row = 0; row < 1 + extraLines && linesDraw < this.rows; ++linesDraw, ++row) {
                    if (linesDraw == 6) {
                        this.func_73729_b(offsetX, offsetY + offset + 7, 0, 166, 190, 7);
                        this.func_73729_b(offsetX, offsetY + offset + 14, 0, 166, 190, 4);
                    } else if (linesDraw >= 7) {
                        this.func_73729_b(offsetX, offsetY + offset, 0, 173, 190, 18);
                    }
                    this.func_73729_b(offsetX + 20, offsetY + offset, 20, 173, 162, 18);
                    offset += 18;
                }
                continue;
            }
            if (linesDraw == 6) {
                this.func_73729_b(offsetX, offsetY + offset + 7, 0, 166, 190, 7);
                this.func_73729_b(offsetX, offsetY + offset + 14, 0, 166, 190, 4);
                this.func_73729_b(offsetX, offsetY + offset, 0, 53, 183, 18);
            } else if (linesDraw >= 7) {
                this.func_73729_b(offsetX, offsetY + offset, 0, 53, 183, 18);
                this.func_73729_b(offsetX + 183, offsetY + offset, 183, 166, 7, 18);
            }
            offset += 18;
            ++linesDraw;
        }
        offset = 51 + Math.max(108, linesDraw * 18);
        if (linesDraw > 6) {
            this.func_73729_b(offsetX, offsetY + offset, 0, 166, 190, 7);
        }
        this.func_73729_b(offsetX, offsetY + offset + 7, 0, 166, this.field_146999_f, 90);
        this.drawnRows = Math.max(6, linesDraw);
        if (this.searchFieldInputs != null) {
            this.searchFieldInputs.func_146194_f();
        }
        if (this.searchFieldOutputs != null) {
            this.searchFieldOutputs.func_146194_f();
        }
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchFieldInputs.func_146179_b().isEmpty() && this.searchFieldInputs.func_146206_l()) {
                return;
            }
            if (character == ' ' && this.searchFieldOutputs.func_146179_b().isEmpty() && this.searchFieldOutputs.func_146206_l()) {
                return;
            }
            if (this.searchFieldInputs.func_146201_a(character, key) || this.searchFieldOutputs.func_146201_a(character, key)) {
                this.refreshList();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    public void postUpdate(NBTTagCompound in) {
        if (in.func_74767_n("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (Object oKey : in.func_150296_c()) {
            String key = (String)oKey;
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                NBTTagCompound invData = in.func_74775_l(key);
                ClientDCInternalInv current = this.getById(id, invData.func_74763_f("sortBy"), invData.func_74779_i("un"));
                this.blockPosHashMap.put(current, NBTUtil.func_186861_c((NBTTagCompound)invData.func_74775_l("pos")));
                this.dimHashMap.put(current, invData.func_74762_e("dim"));
                this.numUpgradesMap.put(current, invData.func_74762_e("numUpgrades"));
                for (int x = 0; x < current.getInventory().getSlots(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().setStackInSlot(x, ItemStackHelper.stackFromNBT(invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        this.field_146292_n.clear();
        this.matchedStacks.clear();
        this.matchedInterfaces.clear();
        String searchFieldInputs = this.searchFieldInputs.func_146179_b().toLowerCase();
        String searchFieldOutputs = this.searchFieldOutputs.func_146179_b().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm("IN:" + searchFieldInputs + " OUT:" + searchFieldOutputs + this.partInterfaceTerminal.onlyInterfacesWithFreeSlots);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFieldInputs.isEmpty() && searchFieldOutputs.isEmpty() && !this.partInterfaceTerminal.onlyInterfacesWithFreeSlots;
            boolean interfaceHasFreeSlots = false;
            if (!found) {
                int slot = 0;
                for (ItemStack itemStack : entry.getInventory()) {
                    if (slot > 8 + this.numUpgradesMap.get(entry) * 9) break;
                    if (!searchFieldInputs.isEmpty() && !searchFieldOutputs.isEmpty()) {
                        if (this.itemStackMatchesSearchTerm(itemStack, searchFieldInputs, 0) || this.itemStackMatchesSearchTerm(itemStack, searchFieldOutputs, 1)) {
                            found = true;
                            this.matchedStacks.add(itemStack);
                        }
                    } else if (!searchFieldInputs.isEmpty()) {
                        if (this.itemStackMatchesSearchTerm(itemStack, searchFieldInputs, 0)) {
                            found = true;
                            this.matchedStacks.add(itemStack);
                        }
                    } else if (!searchFieldOutputs.isEmpty() && this.itemStackMatchesSearchTerm(itemStack, searchFieldOutputs, 1)) {
                        found = true;
                        this.matchedStacks.add(itemStack);
                    }
                    if (itemStack.func_190926_b()) {
                        interfaceHasFreeSlots = true;
                    }
                    ++slot;
                }
            }
            if (searchFieldInputs.isEmpty() && searchFieldOutputs.isEmpty() || !searchFieldInputs.isEmpty() && entry.getName().toLowerCase().contains(searchFieldInputs) || !searchFieldOutputs.isEmpty() && entry.getName().toLowerCase().contains(searchFieldOutputs)) {
                this.matchedInterfaces.add(entry);
                found = true;
            }
            if (found) {
                if (!this.partInterfaceTerminal.onlyInterfacesWithFreeSlots) {
                    this.byName.put((Object)entry.getName(), (Object)entry);
                    cachedSearch.add(entry);
                    continue;
                }
                if (!interfaceHasFreeSlots) continue;
                this.byName.put((Object)entry.getName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList();
            clientInventories.addAll(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.getScrollBar().setRange(0, this.lines.size() - 1, 1);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm, int pass) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        NBTTagCompound encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return searchTerm.matches(GuiText.InvalidPattern.getLocal());
        }
        NBTTagList tag = new NBTTagList();
        tag = pass == 0 ? encodedValue.func_150295_c("in", 10) : encodedValue.func_150295_c("out", 10);
        boolean foundMatchingItemStack = false;
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            ItemStack parsedItemStack = new ItemStack(tag.func_150305_b(i));
            if (parsedItemStack.func_190926_b()) continue;
            String displayName = Platform.getItemDisplayName(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(parsedItemStack)).toLowerCase();
            for (String term : searchTerm.split(" ")) {
                if (term.length() > 1 && (term.startsWith("-") || term.startsWith("!"))) {
                    if (!displayName.contains(term = term.substring(1))) continue;
                    return false;
                }
                if (displayName.contains(term)) {
                    foundMatchingItemStack = true;
                    continue;
                }
                return false;
            }
        }
        return foundMatchingItemStack;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private ClientDCInternalInv getById(long id, long sortBy, String string) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(36, id, sortBy, string);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }

    int getReservedSpace() {
        return this.reservedSpace;
    }

    void setReservedSpace(int reservedSpace) {
        this.reservedSpace = reservedSpace;
    }
}

