/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.grindstone;

import appeng.api.implementations.tiles.ICrankable;
import appeng.block.AEBaseTileBlock;
import appeng.core.stats.Stats;
import appeng.tile.AEBaseTile;
import appeng.tile.grindstone.TileCrank;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCrank
extends AEBaseTileBlock {
    public BlockCrank() {
        super(Material.field_151575_d);
        this.func_149713_g(0);
        this.setHarvestLevel("axe", 0);
        this.setFullSize(this.setOpaque(false));
    }

    @Override
    public boolean onActivated(World w, BlockPos pos, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        Object tile = this.getTileEntity((IBlockAccess)w, pos);
        if (tile instanceof TileCrank && ((TileCrank)tile).power()) {
            Stats.TurnedCranks.addToPlayer(player, 1);
        }
        return true;
    }

    private void dropCrank(World world, BlockPos pos) {
        world.func_175655_b(pos, true);
        world.func_184138_a(pos, this.func_176223_P(), world.func_180495_p(pos), 3);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Object tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null) {
            EnumFacing mnt = this.findCrankable(world, pos);
            EnumFacing forward = EnumFacing.UP;
            if (mnt == EnumFacing.UP || mnt == EnumFacing.DOWN) {
                forward = EnumFacing.SOUTH;
            }
            ((AEBaseTile)tile).setOrientation(forward, mnt.func_176734_d());
        } else {
            this.dropCrank(world, pos);
        }
    }

    @Override
    public boolean isValidOrientation(World w, BlockPos pos, EnumFacing forward, EnumFacing up) {
        TileEntity te = w.func_175625_s(pos);
        return !(te instanceof TileCrank) || this.isCrankable(w, pos, up.func_176734_d());
    }

    private EnumFacing findCrankable(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.isCrankable(world, pos, dir)) continue;
            return dir;
        }
        return null;
    }

    private boolean isCrankable(World world, BlockPos pos, EnumFacing offset) {
        BlockPos o = pos.func_177972_a(offset);
        TileEntity te = world.func_175625_s(o);
        return te instanceof ICrankable && ((ICrankable)te).canCrankAttach(offset.func_176734_d());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        Object tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null) {
            if (!this.isCrankable(world, pos, ((AEBaseTile)tile).getUp().func_176734_d())) {
                this.dropCrank(world, pos);
            }
        } else {
            this.dropCrank(world, pos);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.findCrankable(world, pos) != null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

