/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.util.LookDirection;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AEBaseBlock
extends Block {
    private boolean isOpaque = true;
    private boolean isFullSize = true;
    private boolean hasSubtypes = false;
    private boolean isInventory = false;
    protected AxisAlignedBB boundingBox = field_185505_j;

    protected AEBaseBlock(Material mat) {
        super(mat);
        if (mat == AEGlassMaterial.INSTANCE || mat == Material.field_151592_s) {
            this.func_149672_a(SoundType.field_185853_f);
        } else if (mat == Material.field_151576_e) {
            this.func_149672_a(SoundType.field_185851_d);
        } else if (mat == Material.field_151575_d) {
            this.func_149672_a(SoundType.field_185848_a);
        } else {
            this.func_149672_a(SoundType.field_185852_e);
        }
        this.func_149713_g(255);
        this.func_149715_a(0.0f);
        this.func_149711_c(2.2f);
        this.setHarvestLevel("pickaxe", 0);
        this.field_149787_q = this.isFullSize();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, this.getAEStates());
    }

    public final boolean func_149721_r(IBlockState state) {
        return this.isFullSize() && this.isOpaque();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    public void func_185477_a(IBlockState state, World w, BlockPos pos, AxisAlignedBB bb, List<AxisAlignedBB> out, @Nullable Entity e, boolean p_185477_7_) {
        ICustomCollision collisionHandler = this.getCustomCollision(w, pos);
        if (collisionHandler != null && bb != null) {
            ArrayList<AxisAlignedBB> tmp = new ArrayList<AxisAlignedBB>();
            collisionHandler.addCollidingBlockToList(w, pos, bb, tmp, e);
            for (AxisAlignedBB b : tmp) {
                AxisAlignedBB offset = b.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                if (!bb.func_72326_a(offset)) continue;
                out.add(offset);
            }
        } else {
            super.func_185477_a(state, w, pos, bb, out, e, p_185477_7_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World w, BlockPos pos) {
        ICustomCollision collisionHandler = this.getCustomCollision(w, pos);
        if (collisionHandler != null) {
            if (Platform.isClient()) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                LookDirection ld = Platform.getPlayerRay((EntityPlayer)player, Platform.getEyeOffset((EntityPlayer)player));
                Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, pos, (Entity)Minecraft.func_71410_x().field_71439_g, true);
                AxisAlignedBB br = null;
                double lastDist = 0.0;
                Iterator<AxisAlignedBB> iterator = bbs.iterator();
                while (iterator.hasNext()) {
                    AxisAlignedBB bb;
                    this.boundingBox = bb = iterator.next();
                    RayTraceResult r = super.func_180636_a(state, w, pos, ld.getA(), ld.getB());
                    this.boundingBox = field_185505_j;
                    if (r == null) continue;
                    double xLen = ld.getA().field_72450_a - r.field_72307_f.field_72450_a;
                    double yLen = ld.getA().field_72448_b - r.field_72307_f.field_72448_b;
                    double zLen = ld.getA().field_72449_c - r.field_72307_f.field_72449_c;
                    double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                    if (br != null && !(lastDist > thisDist)) continue;
                    lastDist = thisDist;
                    br = bb;
                }
                if (br != null) {
                    br = new AxisAlignedBB(br.field_72340_a + (double)pos.func_177958_n(), br.field_72338_b + (double)pos.func_177956_o(), br.field_72339_c + (double)pos.func_177952_p(), br.field_72336_d + (double)pos.func_177958_n(), br.field_72337_e + (double)pos.func_177956_o(), br.field_72334_f + (double)pos.func_177952_p());
                    return br;
                }
            }
            AxisAlignedBB b = null;
            for (AxisAlignedBB bx : collisionHandler.getSelectedBoundingBoxesFromPool(w, pos, null, false)) {
                if (b == null) {
                    b = bx;
                    continue;
                }
                double minX = Math.min(b.field_72340_a, bx.field_72340_a);
                double minY = Math.min(b.field_72338_b, bx.field_72338_b);
                double minZ = Math.min(b.field_72339_c, bx.field_72339_c);
                double maxX = Math.max(b.field_72336_d, bx.field_72336_d);
                double maxY = Math.max(b.field_72337_e, bx.field_72337_e);
                double maxZ = Math.max(b.field_72334_f, bx.field_72334_f);
                b = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
            }
            b = b == null ? new AxisAlignedBB(16.0, 16.0, 16.0, 0.0, 0.0, 0.0) : new AxisAlignedBB(b.field_72340_a + (double)pos.func_177958_n(), b.field_72338_b + (double)pos.func_177956_o(), b.field_72339_c + (double)pos.func_177952_p(), b.field_72336_d + (double)pos.func_177958_n(), b.field_72337_e + (double)pos.func_177956_o(), b.field_72334_f + (double)pos.func_177952_p());
            return b;
        }
        return super.func_180640_a(state, w, pos);
    }

    public final boolean func_149662_c(IBlockState state) {
        return this.isOpaque();
    }

    public RayTraceResult func_180636_a(IBlockState state, World w, BlockPos pos, Vec3d a, Vec3d b) {
        ICustomCollision collisionHandler = this.getCustomCollision(w, pos);
        if (collisionHandler != null) {
            Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, pos, null, true);
            RayTraceResult br = null;
            double lastDist = 0.0;
            Iterator<AxisAlignedBB> iterator = bbs.iterator();
            while (iterator.hasNext()) {
                AxisAlignedBB bb;
                this.boundingBox = bb = iterator.next();
                RayTraceResult r = super.func_180636_a(state, w, pos, a, b);
                this.boundingBox = field_185505_j;
                if (r == null) continue;
                double xLen = a.field_72450_a - r.field_72307_f.field_72450_a;
                double yLen = a.field_72448_b - r.field_72307_f.field_72448_b;
                double zLen = a.field_72449_c - r.field_72307_f.field_72449_c;
                double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                if (br != null && !(lastDist > thisDist)) continue;
                lastDist = thisDist;
                br = r;
            }
            return br;
        }
        this.boundingBox = field_185505_j;
        return super.func_180636_a(state, w, pos, a, b);
    }

    public boolean func_149740_M(IBlockState state) {
        return this.isInventory();
    }

    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return 0;
    }

    public final boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isFullSize();
    }

    public boolean rotateBlock(World w, BlockPos pos, EnumFacing axis) {
        IOrientable rotatable = this.getOrientable((IBlockAccess)w, pos);
        if (rotatable != null && rotatable.canBeRotated()) {
            if (this.hasCustomRotation()) {
                this.customRotateBlock(rotatable, axis);
                return true;
            }
            EnumFacing forward = rotatable.getForward();
            EnumFacing up = rotatable.getUp();
            for (int rs = 0; rs < 4; ++rs) {
                if (!this.isValidOrientation(w, pos, forward = Platform.rotateAround(forward, axis), up = Platform.rotateAround(up, axis))) continue;
                rotatable.setOrientation(forward, up);
                return true;
            }
        }
        return super.rotateBlock(w, pos, axis);
    }

    public EnumFacing[] getValidRotations(World w, BlockPos pos) {
        return new EnumFacing[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack is, World world, List<String> lines, ITooltipFlag advancedItemTooltips) {
    }

    public boolean onActivated(World w, BlockPos pos, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public final EnumFacing mapRotation(IOrientable ori, EnumFacing dir) {
        EnumFacing forward = ori.getForward();
        EnumFacing up = ori.getUp();
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.func_96559_d() * up.func_82599_e() - forward.func_82599_e() * up.func_96559_d();
        int west_y = forward.func_82599_e() * up.func_82601_c() - forward.func_82601_c() * up.func_82599_e();
        int west_z = forward.func_82601_c() * up.func_96559_d() - forward.func_96559_d() * up.func_82601_c();
        EnumFacing west = null;
        for (EnumFacing dx : EnumFacing.field_82609_l) {
            if (dx.func_82601_c() != west_x || dx.func_96559_d() != west_y || dx.func_82599_e() != west_z) continue;
            west = dx;
        }
        if (west == null) {
            return dir;
        }
        if (dir == forward) {
            return EnumFacing.SOUTH;
        }
        if (dir == forward.func_176734_d()) {
            return EnumFacing.NORTH;
        }
        if (dir == up) {
            return EnumFacing.UP;
        }
        if (dir == up.func_176734_d()) {
            return EnumFacing.DOWN;
        }
        if (dir == west) {
            return EnumFacing.WEST;
        }
        if (dir == west.func_176734_d()) {
            return EnumFacing.EAST;
        }
        return null;
    }

    public String toString() {
        String regName = this.getRegistryName() != null ? this.getRegistryName().func_110623_a() : "unregistered";
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + regName + "]";
    }

    protected String getTranslationKey(ItemStack is) {
        return this.func_149739_a();
    }

    protected boolean hasCustomRotation() {
        return false;
    }

    protected void customRotateBlock(IOrientable rotatable, EnumFacing axis) {
    }

    protected IOrientable getOrientable(IBlockAccess w, BlockPos pos) {
        AEBaseBlock aEBaseBlock = this;
        if (aEBaseBlock instanceof IOrientableBlock) {
            IOrientableBlock orientable = (IOrientableBlock)((Object)aEBaseBlock);
            return orientable.getOrientable(w, pos);
        }
        return null;
    }

    protected boolean isValidOrientation(World w, BlockPos pos, EnumFacing forward, EnumFacing up) {
        return true;
    }

    protected ICustomCollision getCustomCollision(World w, BlockPos pos) {
        if (this instanceof ICustomCollision) {
            return (ICustomCollision)((Object)this);
        }
        return null;
    }

    protected IProperty[] getAEStates() {
        return new IProperty[0];
    }

    protected boolean isOpaque() {
        return this.isOpaque;
    }

    protected boolean setOpaque(boolean isOpaque) {
        this.isOpaque = isOpaque;
        return isOpaque;
    }

    protected boolean hasSubtypes() {
        return this.hasSubtypes;
    }

    protected void setHasSubtypes(boolean hasSubtypes) {
        this.hasSubtypes = hasSubtypes;
    }

    protected boolean isFullSize() {
        return this.isFullSize;
    }

    protected boolean setFullSize(boolean isFullSize) {
        this.isFullSize = isFullSize;
        return isFullSize;
    }

    protected boolean isInventory() {
        return this.isInventory;
    }

    protected void setInventory(boolean isInventory) {
        this.isInventory = isInventory;
    }
}

