/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.generator.RecipeGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LanternRecipeGenerator
extends RecipeGenerator {
    public LanternRecipeGenerator(ResourceCache cache) {
        super("additionallanterns", cache);
    }

    public void generate() {
        for (LanternMaterial material : LanternMaterial.values()) {
            this.addMaterialRecipes(material);
        }
    }

    private void addMaterialRecipes(LanternMaterial material) {
        this.addLanternRecipe(material);
        if (material.canBeColored) {
            this.addColorRecipe(material, null);
            for (LanternColor color : LanternColor.values()) {
                this.addColorRecipe(material, color);
            }
        }
        if (material.hasChains) {
            this.addChainRecipe(material);
        }
    }

    private void addLanternRecipe(LanternMaterial material) {
        if (material.primaryLanternIngredient == null && material.secondaryLanternIngredient == null) {
            return;
        }
        if (material.primaryLanternIngredient == null) {
            this.shaped(Item.func_150898_a((Block)material.getLanternBlock()), material.lanternRecipeCount).pattern("B B").pattern(" C ").pattern("B B").input('B', new ItemStack[]{material.secondaryLanternIngredient.get()}).input('C', new Item[]{Item.func_150898_a((Block)Blocks.field_150478_aa)}).unlockedBy(new Item[]{Item.func_150898_a((Block)Blocks.field_150478_aa)});
        } else if (material.secondaryLanternIngredient == null) {
            this.shaped(Item.func_150898_a((Block)material.getLanternBlock()), material.lanternRecipeCount).pattern(" A ").pattern("ACA").pattern(" A ").input('A', new ItemStack[]{material.primaryLanternIngredient.get()}).input('C', new Item[]{Item.func_150898_a((Block)Blocks.field_150478_aa)}).unlockedBy(new Item[]{Item.func_150898_a((Block)Blocks.field_150478_aa)});
        } else {
            this.shaped(Item.func_150898_a((Block)material.getLanternBlock()), material.lanternRecipeCount).pattern("BAB").pattern("ACA").pattern("BAB").input('A', new ItemStack[]{material.primaryLanternIngredient.get()}).input('B', new ItemStack[]{material.secondaryLanternIngredient.get()}).input('C', new Item[]{Item.func_150898_a((Block)Blocks.field_150478_aa)}).unlockedBy(new Item[]{Item.func_150898_a((Block)Blocks.field_150478_aa)});
        }
    }

    private void addColorRecipe(LanternMaterial material, LanternColor color) {
        if (color == null) {
            this.shapeless(new ResourceLocation("additionallanterns", material.getSuffix() + "_lantern_colorless"), Item.func_150898_a((Block)material.getLanternBlock())).input(LanternRecipeGenerator.getMaterialLanternTag(material)).unlockedByOreDict(LanternRecipeGenerator.getMaterialLanternTag(material));
        } else {
            this.shapeless(new ResourceLocation("additionallanterns", material.getSuffix() + "_lantern_" + color.getSuffix()), Item.func_150898_a((Block)material.getLanternBlock(color))).input(LanternRecipeGenerator.getMaterialLanternTag(material)).input(LanternRecipeGenerator.getColorDyeTag(color)).unlockedByOreDict(LanternRecipeGenerator.getMaterialLanternTag(material));
        }
    }

    private static String getMaterialLanternTag(LanternMaterial material) {
        return material.getSuffix() + "_lanterns";
    }

    private static String getColorDyeTag(LanternColor color) {
        return color == LanternColor.LIGHT_GRAY ? "dyeLightGray" : "dye" + color.dyeColor.func_176762_d().substring(0, 1).toUpperCase() + color.dyeColor.func_176762_d().substring(1);
    }

    private void addChainRecipe(LanternMaterial material) {
        if (material.primaryChainIngredient == null && material.secondaryChainIngredient == null) {
            return;
        }
        if (material.primaryChainIngredient == null) {
            this.shaped(Item.func_150898_a((Block)material.getChainBlock()), material.chainRecipeCount).pattern("B").pattern(" ").pattern("B").input('B', new ItemStack[]{material.secondaryChainIngredient.get()}).unlockedBy(new ItemStack[]{material.secondaryChainIngredient.get()});
        } else if (material.secondaryChainIngredient == null) {
            this.shaped(Item.func_150898_a((Block)material.getChainBlock()), material.chainRecipeCount).pattern("A").input('A', new ItemStack[]{material.primaryChainIngredient.get()}).unlockedBy(new ItemStack[]{material.primaryChainIngredient.get()});
        } else {
            this.shaped(Item.func_150898_a((Block)material.getChainBlock()), material.chainRecipeCount).pattern("B").pattern("A").pattern("B").input('A', new ItemStack[]{material.primaryChainIngredient.get()}).input('B', new ItemStack[]{material.secondaryChainIngredient.get()}).unlockedBy(new ItemStack[]{material.primaryChainIngredient.get()});
        }
    }
}

