/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.tag.entries;

import com.google.gson.JsonObject;
import com.supermartijn642.core.data.tag.CustomTagEntry;
import com.supermartijn642.core.data.tag.CustomTagEntrySerializer;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.util.ResourceLocation;

public class TagTagEntry
implements CustomTagEntry {
    public static final CustomTagEntrySerializer<TagTagEntry> SERIALIZER = new Serializer();
    private final ResourceLocation tag;
    private final boolean required;

    public TagTagEntry(ResourceLocation tag, boolean required) {
        this.tag = tag;
        this.required = required;
    }

    public ResourceLocation getTagIdentifier() {
        return this.tag;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public <T> Collection<T> resolve(CustomTagEntry.TagEntryResolutionContext<T> context) {
        Collection<T> tag = context.getTag(this.tag);
        if (tag == null && this.required) {
            throw new RuntimeException("Unknown tag '" + this.tag + "'!");
        }
        return tag;
    }

    @Override
    public Collection<ResourceLocation> getTagDependencies() {
        return Collections.singleton(this.tag);
    }

    @Override
    public CustomTagEntrySerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements CustomTagEntrySerializer<TagTagEntry> {
        private Serializer() {
        }

        @Override
        public void serialize(JsonObject json, TagTagEntry entry) {
            json.addProperty("tag", entry.tag.toString());
            json.addProperty("required", Boolean.valueOf(entry.required));
        }

        @Override
        public TagTagEntry deserialize(JsonObject json) {
            return new TagTagEntry(new ResourceLocation(json.get("tag").getAsString()), !json.has("required") || json.get("required").getAsBoolean());
        }
    }
}

