/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.WaypointDimensionTypeInfo;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldConnectionManager;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;

public class WaypointWorldRootContainer
extends WaypointWorldContainer {
    public boolean configLoaded = false;
    private boolean usingMultiworldDetection = false;
    private boolean ignoreServerLevelId = false;
    private String defaultMultiworldId;
    private boolean teleportationEnabled = true;
    private boolean usingDefaultTeleportCommand = true;
    private String serverTeleportCommandFormat;
    private String serverTeleportCommandRotationFormat;
    private WaypointsSort sortType = WaypointsSort.NONE;
    private boolean sortReversed;
    private boolean ignoreHeightmaps;
    private WaypointWorldConnectionManager subWorldConnections;
    private Int2ObjectMap<WaypointDimensionTypeInfo> dimensionTypes;

    public WaypointWorldRootContainer(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, String key) {
        super(modMain, minimapSession, key, null);
        this.updateConnectionsField(minimapSession);
        this.dimensionTypes = new Int2ObjectOpenHashMap();
    }

    public void updateConnectionsField(XaeroMinimapSession minimapSession) {
        this.subWorldConnections = minimapSession.getWaypointsManager().isMultiplayer(this.key) ? new WaypointWorldConnectionManager() : new WaypointWorldConnectionManager(){

            @Override
            public boolean isConnected(WaypointWorld world1, WaypointWorld world2) {
                return true;
            }

            @Override
            public void save(PrintWriter writer) {
            }
        };
    }

    private File getConfigFile() {
        Path directoryPath = this.getDirectory().toPath();
        try {
            if (!Files.exists(directoryPath, new LinkOption[0])) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        return directoryPath.resolve("config.txt").toFile();
    }

    public void saveConfig() {
        File configFile = this.getConfigFile();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(configFile));
            writer.println("//waypoints config options");
            writer.println("usingMultiworldDetection:" + this.usingMultiworldDetection);
            writer.println("ignoreServerLevelId:" + this.ignoreServerLevelId);
            if (this.defaultMultiworldId != null) {
                writer.println("defaultMultiworldId:" + this.defaultMultiworldId);
            }
            writer.println("teleportationEnabled:" + this.teleportationEnabled);
            writer.println("usingDefaultTeleportCommand:" + this.usingDefaultTeleportCommand);
            if (this.serverTeleportCommandFormat != null) {
                writer.println("serverTeleportCommandFormat:" + this.serverTeleportCommandFormat.replace(":", "^col^"));
            }
            if (this.serverTeleportCommandRotationFormat != null) {
                writer.println("serverTeleportCommandRotationFormat:" + this.serverTeleportCommandRotationFormat.replace(":", "^col^"));
            }
            writer.println("sortType:" + this.sortType.name());
            writer.println("sortReversed:" + this.sortReversed);
            writer.println("");
            writer.println("//other config options");
            writer.println("ignoreHeightmaps:" + this.ignoreHeightmaps);
            this.subWorldConnections.save(writer);
            writer.println("");
            writer.println("//dimension types (DO NOT EDIT)");
            for (Int2ObjectMap.Entry entry : this.dimensionTypes.int2ObjectEntrySet()) {
                writer.println("dimensionType:" + entry.getIntKey() + ":" + ((WaypointDimensionTypeInfo)entry.getValue()).toString());
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (writer != null) {
            writer.close();
        }
    }

    public void loadConfig() {
        this.configLoaded = true;
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.saveConfig();
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(configFile));
            while ((line = reader.readLine()) != null) {
                String valueString;
                String[] args = line.split(":");
                String string = valueString = args.length < 2 ? "" : args[1];
                if (args[0].equals("usingMultiworldDetection")) {
                    this.usingMultiworldDetection = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("ignoreServerLevelId")) {
                    this.ignoreServerLevelId = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("defaultMultiworldId")) {
                    this.defaultMultiworldId = valueString;
                    continue;
                }
                if (args[0].equals("teleportationEnabled")) {
                    this.teleportationEnabled = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("usingDefaultTeleportCommand")) {
                    this.usingDefaultTeleportCommand = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("teleportCommand")) {
                    this.serverTeleportCommandFormat = "/" + valueString.replace("^col^", ":") + " {x} {y} {z}";
                    this.serverTeleportCommandRotationFormat = "/" + valueString.replace("^col^", ":") + " {x} {y} {z} {yaw} ~";
                    continue;
                }
                if (args[0].equals("serverTeleportCommand")) {
                    this.serverTeleportCommandFormat = valueString.replace("^col^", ":") + " {x} {y} {z}";
                    this.serverTeleportCommandRotationFormat = valueString.replace("^col^", ":") + " {x} {y} {z} {yaw} ~";
                    continue;
                }
                if (args[0].equals("serverTeleportCommandFormat")) {
                    this.serverTeleportCommandFormat = valueString.replace("^col^", ":");
                    continue;
                }
                if (args[0].equals("serverTeleportCommandRotationFormat")) {
                    this.serverTeleportCommandRotationFormat = valueString.replace("^col^", ":");
                    continue;
                }
                if (args[0].equals("sortType")) {
                    this.sortType = WaypointsSort.valueOf(valueString);
                    continue;
                }
                if (args[0].equals("sortReversed")) {
                    this.sortReversed = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("ignoreHeightmaps")) {
                    this.ignoreHeightmaps = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("connection")) {
                    String worldKey1 = valueString;
                    if (args.length <= 2) continue;
                    String worldKey2 = args[2];
                    this.subWorldConnections.addConnection(worldKey1, worldKey2);
                    continue;
                }
                if (!args[0].equals("dimensionType")) continue;
                try {
                    WaypointDimensionTypeInfo dimType = WaypointDimensionTypeInfo.fromString(args[2], args[3]);
                    if (dimType == null) continue;
                    this.dimensionTypes.put(Integer.parseInt(args[1]), (Object)dimType);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (FileNotFoundException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }

    public boolean isUsingMultiworldDetection() {
        return this.usingMultiworldDetection;
    }

    public void setUsingMultiworldDetection(boolean usingMultiworldDetection) {
        this.usingMultiworldDetection = usingMultiworldDetection;
    }

    public String getDefaultMultiworldId() {
        return this.defaultMultiworldId;
    }

    public void setDefaultMultiworldId(String defaultMultiworldId) {
        this.defaultMultiworldId = defaultMultiworldId;
    }

    public boolean isTeleportationEnabled() {
        return this.teleportationEnabled;
    }

    public void setTeleportationEnabled(boolean teleportation) {
        this.teleportationEnabled = teleportation;
    }

    public boolean isUsingDefaultTeleportCommand() {
        return this.usingDefaultTeleportCommand;
    }

    public void setUsingDefaultTeleportCommand(boolean usingDefaultTeleportCommand) {
        this.usingDefaultTeleportCommand = usingDefaultTeleportCommand;
    }

    public String getServerTeleportCommandFormat() {
        return this.serverTeleportCommandFormat;
    }

    public String getServerTeleportCommandRotationFormat() {
        return this.serverTeleportCommandRotationFormat;
    }

    public void setServerTeleportCommandFormat(String serverTeleportCommandFormat) {
        this.serverTeleportCommandFormat = serverTeleportCommandFormat;
    }

    public void setServerTeleportCommandRotationFormat(String serverTeleportCommandRotationFormat) {
        this.serverTeleportCommandRotationFormat = serverTeleportCommandRotationFormat;
    }

    public WaypointsSort getSortType() {
        return this.sortType;
    }

    public void toggleSortType() {
        this.sortType = WaypointsSort.values()[(this.sortType.ordinal() + 1) % WaypointsSort.values().length];
    }

    public boolean isSortReversed() {
        return this.sortReversed;
    }

    public void toggleSortReversed() {
        this.sortReversed = !this.sortReversed;
    }

    public boolean isIgnoreServerLevelId() {
        return this.ignoreServerLevelId;
    }

    public WaypointWorldConnectionManager getSubWorldConnections() {
        return this.subWorldConnections;
    }

    public boolean isIgnoreHeightmaps() {
        return this.ignoreHeightmaps;
    }

    public void setIgnoreHeightmaps(boolean ignoreHeightmaps) {
        this.ignoreHeightmaps = ignoreHeightmaps;
    }

    public WaypointDimensionTypeInfo getDimensionType(int dimId) {
        WaypointDimensionTypeInfo dimensionType = (WaypointDimensionTypeInfo)this.dimensionTypes.get(dimId);
        if (dimensionType == null) {
            if (dimId == -1) {
                dimensionType = new WaypointDimensionTypeInfo(DimensionType.NETHER.func_186065_b(), false, 0.1f, 256, 128, true, false, false, 0.5f, 8.0, "DIM-1");
            } else if (dimId == 0) {
                dimensionType = new WaypointDimensionTypeInfo(DimensionType.OVERWORLD.func_186065_b(), true, 0.0f, 256, 256, false, true, false, new WorldProviderSurface().func_76563_a(6000L, 1.0f), 1.0, null);
            } else if (dimId == 1) {
                dimensionType = new WaypointDimensionTypeInfo(DimensionType.THE_END.func_186065_b(), false, 0.0f, 256, 256, false, false, true, 0.0f, 1.0, "DIM1");
            } else {
                IntegratedServer integratedServer = Minecraft.func_71410_x().func_71401_C();
                if (integratedServer == null) {
                    return null;
                }
                WorldServer serverLevel = integratedServer.func_71218_a(dimId);
                if (serverLevel == null) {
                    return null;
                }
                dimensionType = WaypointWorldRootContainer.createDimensionType((World)serverLevel);
            }
            this.dimensionTypes.put(dimId, (Object)dimensionType);
        }
        return dimensionType;
    }

    public double getDimensionScale(int dimId) {
        WaypointDimensionTypeInfo dimType = this.getDimensionType(dimId);
        if (dimType == null) {
            return 1.0;
        }
        return dimType.getCoordinateScale();
    }

    public void updateDimensionType(WorldClient level) {
        WaypointDimensionTypeInfo currentDimType;
        int dimId = level.field_73011_w.getDimension();
        WaypointDimensionTypeInfo newDimType = WaypointWorldRootContainer.createDimensionType((World)level);
        if (!Objects.equals(newDimType, currentDimType = (WaypointDimensionTypeInfo)this.dimensionTypes.get(dimId))) {
            this.dimensionTypes.put(dimId, (Object)newDimType);
            this.saveConfig();
        }
    }

    @Override
    public WaypointWorldRootContainer getRootContainer() {
        return this;
    }

    public static WaypointDimensionTypeInfo createDimensionType(World level) {
        return new WaypointDimensionTypeInfo(level.field_73011_w.func_186058_p().func_186065_b(), level.field_73011_w.func_191066_m(), level.field_73011_w.func_177497_p()[0], level.field_73011_w.getHeight(), level.field_73011_w.getActualHeight(), level.field_73011_w.func_177495_o(), level.field_73011_w.func_76569_d(), level.field_73011_w.func_186058_p() == DimensionType.THE_END, level.field_73011_w.func_76563_a(6000L, 1.0f), Misc.getDimensionTypeScale(level), level.field_73011_w.getSaveFolder());
    }
}

