/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.resource;

import com.google.gson.annotations.Expose;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.hud.minimap.MinimapLogs;

public class EntityIconDefinition {
    public static final ResourceLocation MODEL_TYPE = new ResourceLocation("xaerominimap", "entity/icon/model");
    public static final ResourceLocation DOT_TYPE = new ResourceLocation("xaerominimap", "entity/icon/dot");
    public static final ResourceLocation OUTLINED_SPRITE = new ResourceLocation("xaerominimap", "entity/icon/outlined_sprite");
    public static final ResourceLocation NORMAL_SPRITE = new ResourceLocation("xaerominimap", "entity/icon/normal_sprite");
    public static final ResourceLocation OLD_SPRITE = new ResourceLocation("xaerominimap", "entity/icon/old_sprite");
    @Expose
    private HashMap<String, String> variants;
    @Expose
    private ArrayList<EntityIconModelConfig> modelConfigs;
    private HashMap<String, ResourceLocation> variantTypes;
    private HashMap<String, EntityIconModelConfig> variantModelConfigs;
    private HashMap<String, ResourceLocation> variantSprites;
    @Expose
    private String variantMethod;
    private Method variantMethodReflect;
    @Expose
    private String variantIdMethod;
    private Method variantIdMethodReflect;
    @Expose
    private String variantIdBuilderMethod;
    private Method variantIdBuilderMethodReflect;

    public ResourceLocation getVariantType(String variantId) {
        if (this.variantTypes == null) {
            return MODEL_TYPE;
        }
        return this.variantTypes.get(variantId);
    }

    public EntityIconModelConfig getModelConfig(String variantId) {
        if (this.variantModelConfigs == null) {
            return null;
        }
        return this.variantModelConfigs.get(variantId);
    }

    public ResourceLocation getSprite(String variantId) {
        if (this.variantSprites == null) {
            return null;
        }
        return this.variantSprites.get(variantId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onConstruct(ResourceLocation entityId) {
        if (this.variantMethod != null) {
            this.variantMethodReflect = this.convertStringToMethod(this.variantMethod, entityId.toString(), "variant", null, ResourceLocation.class, Render.class, Entity.class);
        }
        if (this.variantIdBuilderMethod != null) {
            this.variantIdBuilderMethodReflect = this.convertStringToMethod(this.variantIdBuilderMethod, entityId.toString(), "variant ID builder", Void.TYPE, StringBuilder.class, Render.class, Entity.class);
        }
        if (this.variantIdMethod != null) {
            this.variantIdMethodReflect = this.convertStringToMethod(this.variantIdMethod, entityId.toString(), "variant ID", String.class, Render.class, Entity.class);
        }
        if (this.variants == null) {
            this.variants = new HashMap();
        }
        if (this.variants.get("default") == null) {
            this.variants.put("default", "model");
        }
        Iterator<Map.Entry<String, String>> iterator = this.variants.entrySet().iterator();
        while (true) {
            ResourceLocation type;
            Map.Entry<String, String> entry;
            block21: {
                block22: {
                    String iconType;
                    String[] valueSplit;
                    String value;
                    block25: {
                        block24: {
                            block23: {
                                if (!iterator.hasNext()) {
                                    return;
                                }
                                entry = iterator.next();
                                value = entry.getValue();
                                if (value.equals("model")) break block22;
                                valueSplit = value.split(":");
                                iconType = valueSplit[0];
                                if (!iconType.equals("outlined_sprite")) break block23;
                                if (valueSplit.length != 2) {
                                    MinimapLogs.LOGGER.info("Skipping invalid icon type: " + value + " for " + entityId);
                                    continue;
                                }
                                type = OUTLINED_SPRITE;
                                ResourceLocation sprite = new ResourceLocation("xaerominimap", "entity/icon/sprite/" + valueSplit[1]);
                                if (this.variantSprites == null) {
                                    this.variantSprites = new HashMap();
                                }
                                this.variantSprites.put(entry.getKey(), sprite);
                                break block21;
                            }
                            if (!iconType.equals("sprite") && !iconType.equals("normal_sprite")) break block24;
                            if (valueSplit.length != 2) {
                                MinimapLogs.LOGGER.info("Skipping invalid icon type: " + value + " for " + entityId);
                                continue;
                            }
                            type = iconType.equals("sprite") ? OLD_SPRITE : NORMAL_SPRITE;
                            ResourceLocation sprite = new ResourceLocation("xaerominimap", "entity/icon/sprite/" + valueSplit[1]);
                            if (this.variantSprites == null) {
                                this.variantSprites = new HashMap();
                            }
                            this.variantSprites.put(entry.getKey(), sprite);
                            break block21;
                        }
                        if (!iconType.equals("dot")) break block25;
                        if (valueSplit.length != 1) {
                            MinimapLogs.LOGGER.info("Skipping invalid icon type: " + value + " for " + entityId);
                            continue;
                        }
                        type = DOT_TYPE;
                        break block21;
                    }
                    if (iconType.equals("model")) {
                        EntityIconModelConfig referencedModelConfig;
                        if (valueSplit.length != 2) {
                            MinimapLogs.LOGGER.info("Skipping invalid icon type: " + value + " for " + entityId);
                            continue;
                        }
                        type = MODEL_TYPE;
                        int configIndex = 0;
                        try {
                            configIndex = Integer.parseInt(valueSplit[1]);
                        }
                        catch (NumberFormatException nfe) {
                            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)nfe);
                        }
                        EntityIconModelConfig entityIconModelConfig = referencedModelConfig = this.modelConfigs != null && configIndex >= 0 && configIndex < this.modelConfigs.size() ? this.modelConfigs.get(configIndex) : null;
                        if (referencedModelConfig == null) {
                            MinimapLogs.LOGGER.info("Specified model config is not defined: " + value + " for " + entityId);
                            break block21;
                        } else {
                            if (this.variantModelConfigs == null) {
                                this.variantModelConfigs = new HashMap();
                            }
                            this.variantModelConfigs.put(entry.getKey(), referencedModelConfig);
                        }
                        break block21;
                    } else {
                        MinimapLogs.LOGGER.info("Skipping invalid icon type: " + value + " for " + entityId);
                        continue;
                    }
                }
                type = MODEL_TYPE;
            }
            if (this.variantTypes == null) {
                this.variantTypes = new HashMap();
            }
            this.variantTypes.put(entry.getKey(), type);
        }
    }

    public String getVariantMethodString() {
        return this.variantMethod;
    }

    public Method getVariantMethod() {
        return this.variantMethodReflect;
    }

    public void setVariantMethod(Method variantMethod) {
        this.variantMethodReflect = variantMethod;
    }

    public String getVariantIdBuilderMethodString() {
        return this.variantIdBuilderMethod;
    }

    public Method getVariantIdBuilderMethod() {
        return this.variantIdBuilderMethodReflect;
    }

    public void setVariantIdBuilderMethod(Method variantIdBuilderMethodReflect) {
        this.variantIdBuilderMethodReflect = variantIdBuilderMethodReflect;
    }

    private Method convertStringToMethod(String methodPath, String entityId, String methodDisplayName, Class<?> returnType, Class<?> ... parameterTypes) {
        Method result = null;
        if (methodPath != null) {
            int lastDot = methodPath.lastIndexOf(46);
            String classPath = methodPath.substring(0, lastDot);
            String methodName = methodPath.substring(lastDot + 1);
            try {
                Class<?> c = Class.forName(classPath);
                result = c.getDeclaredMethod(methodName, parameterTypes);
                if (returnType != null && result.getReturnType() != returnType) {
                    MinimapLogs.LOGGER.info(String.format("The return type of the %s method for %s is not %s. Can't use it.", methodDisplayName, entityId, returnType));
                    result = null;
                }
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error(String.format("Could not find %s method %s defined for %s", methodDisplayName, this.variantIdBuilderMethod, entityId), (Throwable)e);
            }
        }
        return result;
    }

    public String getOldVariantIdMethodString() {
        return this.variantIdMethod;
    }

    public Method getOldVariantIdMethod() {
        return this.variantIdMethodReflect;
    }

    public void setOldVariantIdMethod(Method variantIdMethodReflect) {
        this.variantIdMethodReflect = variantIdMethodReflect;
    }
}

