/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.icon.XaeroIcon;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconCache;
import xaero.common.minimap.render.radar.EntityIconKey;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.armor.EntityIconArmor;
import xaero.common.minimap.render.radar.armor.EntityIconArmorHandler;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.common.minimap.render.radar.resource.EntityIconDefinitionManager;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.common.minimap.render.radar.variant.EntityIconVariantHandler;
import xaero.hud.minimap.MinimapLogs;

public class EntityIconManager {
    public static final XaeroIcon FAILED = new XaeroIcon(null, 0, 0);
    public static final XaeroIcon DOT = new XaeroIcon(null, 0, 0);
    private EntityIconPrerenderer prerenderer;
    private final IXaeroMinimap modMain;
    private Map<ResourceLocation, EntityIconCache> cachedIcons;
    private boolean canPrerender;
    private EntityIconModelConfig defaultModelConfig;
    private final EntityIconDefinitionManager definitionManager;
    private final EntityIconVariantHandler variantHandler;
    private final EntityIconArmorHandler armorHandler;

    public EntityIconManager(IXaeroMinimap modMain, EntityIconPrerenderer prerenderer) {
        this.modMain = modMain;
        this.prerenderer = prerenderer;
        this.definitionManager = new EntityIconDefinitionManager();
        this.variantHandler = new EntityIconVariantHandler();
        this.cachedIcons = new HashMap<ResourceLocation, EntityIconCache>();
        this.definitionManager.reloadResources();
        this.defaultModelConfig = new EntityIconModelConfig();
        this.armorHandler = new EntityIconArmorHandler();
    }

    protected EntityIconCache getVariantIconCache(ResourceLocation entityType) {
        EntityIconCache result = this.cachedIcons.get(entityType);
        if (result == null) {
            result = new EntityIconCache(entityType);
            this.cachedIcons.put(entityType, result);
        }
        return result;
    }

    public <T extends Entity> XaeroIcon getEntityIcon(T entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean debug, boolean debugEntityVariantIds, ScaledResolution scaledRes) {
        ResourceLocation entityType = EntityList.func_191301_a(entity);
        EntityIconDefinition iconDefinition = this.definitionManager.get(entityType);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        Render entityRenderer = renderManager.func_78713_a(entity);
        Object variant = this.variantHandler.getEntityVariant(iconDefinition, entity, entityRenderer);
        while (GL11.glGetError() != 0) {
        }
        if (variant == null) {
            return null;
        }
        EntityIconArmor armor = null;
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer)) {
            armor = this.armorHandler.getArmor((EntityLivingBase)entity);
        }
        EntityIconCache entityIconCache = this.getVariantIconCache(entityType);
        EntityIconKey iconKey = new EntityIconKey(variant, armor);
        XaeroIcon cachedValue = entityIconCache.get(iconKey);
        if (entityIconCache.isInvalidVariantClass()) {
            return FAILED;
        }
        if (cachedValue == null) {
            ResourceLocation iconType;
            String entityVariantString;
            String variantMapKey = entityVariantString = entityIconCache.getVariantString(iconKey);
            if (iconDefinition != null) {
                ResourceLocation resourceLocation = iconType = variantMapKey == null ? null : iconDefinition.getVariantType(variantMapKey);
                if (iconType == null) {
                    variantMapKey = "default";
                    iconType = iconDefinition.getVariantType(variantMapKey);
                }
            } else {
                ResourceLocation resourceLocation = iconType = entity instanceof EntityLivingBase ? EntityIconDefinition.MODEL_TYPE : EntityIconDefinition.DOT_TYPE;
            }
            if (debugEntityVariantIds && entityVariantString != null && (this.canPrerender || iconType == EntityIconDefinition.DOT_TYPE)) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(entityVariantString));
            }
            if (iconType == EntityIconDefinition.MODEL_TYPE) {
                if (this.canPrerender) {
                    EntityIconModelConfig variantModelConfig;
                    EntityIconModelConfig modelConfig = this.defaultModelConfig;
                    EntityIconModelConfig entityIconModelConfig = variantModelConfig = iconDefinition == null ? null : iconDefinition.getModelConfig(variantMapKey);
                    if (variantModelConfig != null) {
                        modelConfig = variantModelConfig;
                    }
                    cachedValue = this.prerenderer.prerender(variant, entityRenderer, entity, defaultFramebuffer, helper, scale, modelConfig, this.defaultModelConfig, null, true, false, debug, scaledRes);
                    entityIconCache.add(iconKey, cachedValue);
                    this.canPrerender = false;
                } else {
                    cachedValue = null;
                }
            } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                cachedValue = DOT;
                entityIconCache.add(iconKey, cachedValue);
            } else if (this.canPrerender) {
                ResourceLocation sprite = iconDefinition.getSprite(variantMapKey);
                boolean isOutlined = iconType == EntityIconDefinition.OUTLINED_SPRITE;
                boolean isFlipped = !isOutlined && iconType != EntityIconDefinition.NORMAL_SPRITE;
                cachedValue = this.prerenderer.prerender(variant, entityRenderer, entity, defaultFramebuffer, helper, scale, null, this.defaultModelConfig, sprite, isOutlined, isFlipped, debug, scaledRes);
                entityIconCache.add(iconKey, cachedValue);
                this.canPrerender = false;
            } else {
                cachedValue = null;
            }
        }
        return cachedValue;
    }

    public void reset() {
        this.prerenderer.clearAtlases();
        this.cachedIcons.clear();
        MinimapLogs.LOGGER.info("Entity icon manager reset!");
    }

    public void resetResources() {
        this.definitionManager.reloadResources();
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelPartRenderDetection(ModelRenderer modelRenderer) {
        this.prerenderer.onModelPartRenderDetection(modelRenderer);
    }
}

