/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.minimap.waypoints.render.CompassRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.Minimap;
import xaero.hud.render.TextureLocations;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected IXaeroMinimap modMain;
    protected Minecraft mc;
    protected Minimap minimap;
    protected MinimapRendererHelper helper;
    protected WaypointsGuiRenderer waypointsGuiRenderer;
    private int lastMinimapSize;
    protected double zoom = 1.0;
    private BlockPos.MutableBlockPos mutableBlockPos;
    protected final CompassRenderer compassRenderer;
    private double lastMapDimensionScale = 1.0;
    private double lastPlayerDimDiv = 1.0;

    public MinimapRenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, Minimap minimap, CompassRenderer compassRenderer) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointsGuiRenderer = waypointsGuiRenderer;
        this.minimap = minimap;
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
        this.compassRenderer = compassRenderer;
    }

    public float getEntityYaw(Entity e, float partial) {
        if (e == this.mc.field_71439_g) {
            return e.field_70177_z;
        }
        if (e instanceof EntityLivingBase) {
            return ((EntityLivingBase)e).field_70758_at + (((EntityLivingBase)e).field_70759_as - ((EntityLivingBase)e).field_70758_at) * partial;
        }
        return e.field_70126_B + (e.field_70177_z - e.field_70126_B) * partial;
    }

    public double getRenderAngle(boolean lockedNorth) {
        if (lockedNorth) {
            return 90.0;
        }
        return this.getActualAngle();
    }

    private double getActualAngle() {
        double rotation = Math.toDegrees(Misc.getYawRadians());
        return -90.0 - rotation;
    }

    protected abstract void renderChunks(XaeroMinimapSession var1, MinimapProcessor var2, double var3, double var5, double var7, double var9, int var11, int var12, float var13, float var14, int var15, boolean var16, boolean var17, int var18, double var19, double var21, boolean var23, boolean var24, ScaledResolution var25, ModSettings var26);

    public void renderMinimap(XaeroMinimapSession minimapSession, MinimapProcessor minimap, int x, int y, int width, int height, ScaledResolution scaledRes, int size, float partial) {
        boolean crosshairDisplayed;
        int specW;
        int frameType;
        boolean renderFrame;
        int scale;
        ModSettings settings = this.modMain.getSettings();
        if (settings.getMinimapSize(scale = scaledRes.func_78325_e()) != this.lastMinimapSize) {
            this.lastMinimapSize = settings.getMinimapSize(scale);
            minimap.setToResetImage(true);
        }
        minimap.getEntityRadar().setLastRenderViewEntity(this.mc.func_175606_aa());
        int mapSize = minimapSession.getMinimapProcessor().getMinimapSize(scale);
        int bufferSize = minimapSession.getMinimapProcessor().getMinimapBufferSize(mapSize);
        if (this.minimap.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        float minimapScale = settings.getMinimapScale(scale);
        float mapScale = (float)scale / minimapScale;
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187425_g((int)3317, (int)4);
        GlStateManager.func_187425_g((int)3316, (int)0);
        GlStateManager.func_187425_g((int)3315, (int)0);
        GlStateManager.func_187425_g((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        int shape = settings.minimapShape;
        boolean lockedNorth = settings.getLockNorth(mapSize / 2, shape);
        double angle = Math.toRadians(this.getRenderAngle(lockedNorth));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && !minimap.getMinimapWriter().isLoadedNonWorldMap();
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness())) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        boolean cave = minimap.isCaveModeDisplayed();
        boolean circleShape = shape == 1;
        double playerX = minimap.getEntityRadar().getEntityX(this.mc.func_175606_aa(), partial);
        double playerY = minimap.getEntityRadar().getEntityY(this.mc.func_175606_aa(), partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(this.mc.func_175606_aa(), partial);
        double renderX = playerX;
        double renderZ = playerZ;
        double mapDimensionScale = Misc.getDimensionTypeScale((World)this.mc.field_71441_e);
        double playerDimDiv = 1.0;
        if (useWorldMap) {
            double playerCoordinateScale = mapDimensionScale;
            mapDimensionScale = this.modMain.getSupportMods().worldmapSupport.getMapDimensionScale();
            if (mapDimensionScale == 0.0) {
                mapDimensionScale = this.lastMapDimensionScale;
            }
            playerDimDiv = mapDimensionScale / playerCoordinateScale;
            renderX /= playerDimDiv;
            renderZ /= playerDimDiv;
            this.lastMapDimensionScale = mapDimensionScale;
        }
        this.lastPlayerDimDiv = playerDimDiv;
        this.renderChunks(minimapSession, minimap, renderX, renderZ, playerDimDiv, mapDimensionScale, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap, lockedNorth, shape, ps, pc, cave, circleShape, scaledRes, settings);
        if (this.minimap.usingFBO()) {
            sizeFix = 1.0f;
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0 / 4.0) * 4);
        double circleSeamAngle = -0.7853981633974483;
        int circleSeamWidth = 32;
        int circleFrameThickness = 4;
        double circleStartAngle = 0.0;
        if (!circleShape) {
            this.getHelper().drawMyTexturedModalRect((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            float outerRadius = mapSize / 4 + circleFrameThickness;
            circleStartAngle = circleSeamAngle - (double)((float)(circleSeamWidth / 2) / outerRadius);
            this.getHelper().drawTexturedElipseInsideRectangle(circleStartAngle, circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        if (!this.minimap.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        boolean bl = renderFrame = (frameType = settings.minimapFrame) < ModSettings.FRAME_OPTIONS.length - 1;
        if (frameType > 0) {
            int frameColor = ModSettings.COLORS[settings.minimapFrameColor];
            GlStateManager.func_179131_c((float)((float)(frameColor >> 16 & 0xFF) / 255.0f), (float)((float)(frameColor >> 8 & 0xFF) / 255.0f), (float)((float)(frameColor & 0xFF) / 255.0f), (float)1.0f);
        }
        MinimapRendererHelper helper = this.getHelper();
        if (renderFrame) {
            this.mc.func_110434_K().func_110577_a(TextureLocations.MINIMAP_FRAME_TEXTURES);
        }
        if (renderFrame && !circleShape) {
            int rightCornerStartX = scaledX + 9 + mapSize / 2 + 4 - 16;
            int bottomCornerStartY = scaledY + 9 + mapSize / 2 + 4 - 16;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            int cornerTextureX = frameType == 0 ? 192 : (frameType == 1 ? 208 : 224);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 - 4, scaledY + 9 - 4, cornerTextureX, 97, 16, 16);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, rightCornerStartX, scaledY + 9 - 4, cornerTextureX, 113, 16, 16);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 - 4, bottomCornerStartY, cornerTextureX, 129, 16, 16);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, rightCornerStartX, bottomCornerStartY, cornerTextureX, 145, 16, 16);
            int horLineStartX = scaledX + 9 - 4 + 16;
            int horLineWidth = rightCornerStartX - horLineStartX;
            int horPieceTextureY = frameType == 0 ? 0 : (frameType == 1 ? 32 : 64);
            int horPieceWidth = 226;
            int horLineLength = (int)Math.ceil((double)horLineWidth / (double)horPieceWidth);
            for (int i = 0; i < horLineLength; ++i) {
                int pieceX = scaledX + 9 - 4 + 16 + i * horPieceWidth;
                int pieceW = horPieceWidth;
                if (i == horLineLength - 1 && pieceX + pieceW > rightCornerStartX) {
                    pieceW = rightCornerStartX - pieceX;
                }
                helper.addTexturedRectToExistingBuffer(vertexBuffer, pieceX, scaledY + 9 - 4, 0, horPieceTextureY, pieceW, 16);
                helper.addTexturedRectToExistingBuffer(vertexBuffer, pieceX, scaledY + 9 + mapSize / 2 - 12, 0, horPieceTextureY + 16, pieceW, 16);
            }
            int verLineStartY = scaledY + 9 - 4 + 16;
            int verLineHeight = bottomCornerStartY - verLineStartY;
            int verPieceTextureX = frameType == 0 ? 0 : (frameType == 1 ? 64 : 128);
            int verPieceHeight = 113;
            int vertLineLength = (int)Math.ceil((double)verLineHeight / (double)verPieceHeight);
            for (int i = 0; i < vertLineLength; ++i) {
                int pieceY = scaledY + 9 - 4 + 16 + i * verPieceHeight;
                int pieceU = verPieceTextureX + 32 * (i & 1);
                int pieceH = verPieceHeight;
                if (i == vertLineLength - 1 && pieceY + pieceH > bottomCornerStartY) {
                    pieceH = bottomCornerStartY - pieceY;
                }
                helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 - 4, pieceY, pieceU, 97, 16, pieceH);
                helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 + mapSize / 2 - 12, pieceY, pieceU + 16, 97, 16, pieceH);
            }
            tessellator.func_78381_a();
        } else if (renderFrame) {
            int frameTextureY = frameType == 0 ? 210 : (frameType == 1 ? 214 : 218);
            double shadeStartAngle = 0.7853981633974483 - circleStartAngle;
            int shadeStartIndex = (int)(shadeStartAngle / 2.0 / Math.PI * (double)circleSides);
            int circleLeftX = scaledX + 9;
            int circleTopY = scaledY + 9;
            int innerCircleDiameter = mapSize / 2;
            helper.drawTexturedElipseInsideRectangleFrame(false, false, circleStartAngle, 0, shadeStartIndex, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(true, false, circleStartAngle, shadeStartIndex, shadeStartIndex + circleSides / 4, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(true, true, circleStartAngle, shadeStartIndex + circleSides / 4, shadeStartIndex + circleSides / 2, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(false, false, circleStartAngle, shadeStartIndex + circleSides / 2, circleSides, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
        GlStateManager.func_179152_a((float)(1.0f / minimapScale), (float)(1.0f / minimapScale), (float)1.0f);
        int halfFrame = (int)((float)mapSize * minimapScale / 2.0f / 2.0f);
        GlStateManager.func_179109_b((float)halfFrame, (float)halfFrame, (float)0.0f);
        int specH = specW = halfFrame + (int)(3.0f * minimapScale);
        boolean safeMode = this instanceof MinimapSafeModeRenderer;
        double scaledZoom = this.zoom * (double)minimapScale / 2.0;
        if (!this.modMain.getSettings().compassOverEverything) {
            this.renderCompass(settings, specW, specH, halfFrame, ps, pc, circleShape, minimapScale);
        }
        double overMapFinalDepth = this.minimap.getOverMapRendererHandler().render(this.mc.func_175606_aa(), (EntityPlayer)this.mc.field_71439_g, renderX, playerY, renderZ, playerDimDiv, ps, pc, scaledZoom, cave, partial, null, this.modMain, helper, this.mc.field_71466_p, scaledRes, specW, specH, halfFrame, halfFrame, circleShape, minimapScale);
        if (this.modMain.getSettings().compassOverEverything) {
            this.renderCompass(settings, specW, specH, halfFrame, ps, pc, circleShape, minimapScale);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)overMapFinalDepth);
        GlStateManager.func_179147_l();
        boolean bl2 = crosshairDisplayed = settings.mainEntityAs == 0 && !lockedNorth;
        if (crosshairDisplayed) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179109_b((float)(mapSize / 2), (float)(mapSize / 2), (float)0.0f);
            GlStateManager.func_179120_a((int)775, (int)0, (int)1, (int)0);
            this.getHelper().drawMyColoredRect(-5.0f, -1.0f, 5.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-1.0f, 3.0f, 1.0f, 5.0f);
            this.getHelper().drawMyColoredRect(-1.0f, -5.0f, 1.0f, -3.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
            MinimapRadar minimapRadar = minimap.getEntityRadar();
            EntityRadarCategory mainEntityCategory = minimapRadar.getEntityCategoryManager().getRuleResolver().resolve(minimapRadar.getEntityCategoryManager().getRootCategory(), this.mc.func_175606_aa(), this.mc.field_71439_g);
            if (mainEntityCategory == null) {
                mainEntityCategory = minimapRadar.getEntityCategoryManager().getRootCategory();
            }
            int crosshairColor = minimapRadar.getEntityColour((EntityPlayer)this.mc.field_71439_g, this.mc.func_175606_aa(), 0.0f, false, mainEntityCategory, 100, 100, false, mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue());
            GlStateManager.func_179131_c((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.getHelper().drawMyColoredRect(1.0f, -1.0f, 3.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-3.0f, -1.0f, -1.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-1.0f, 1.0f, 1.0f, 3.0f);
            this.getHelper().drawMyColoredRect(-1.0f, -3.0f, 1.0f, -1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179121_F();
        }
        this.mc.func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        double centerX = 2 * scaledX + 18 + mapSize / 2;
        double centerY = 2 * scaledY + 18 + mapSize / 2;
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179137_b((double)centerX, (double)centerY, (double)0.0);
        Entity mainEntity = this.mc.func_175606_aa();
        if (!safeMode && !crosshairDisplayed) {
            MinimapRadar radar = minimap.getEntityRadar();
            this.minimap.getMinimapFBORenderer().renderMainEntityDot(minimap, (EntityPlayer)this.mc.field_71439_g, mainEntity, ps, pc, radar.getEntityX(mainEntity, partial), radar.getEntityZ(mainEntity, partial), partial, radar, lockedNorth, settings.getDotsStyle(), true, settings.debugEntityIcons, cave, settings.getDotNameScale(), settings, scaledRes, 2.0f);
        }
        GlStateManager.func_179147_l();
        if (lockedNorth || settings.mainEntityAs == 2) {
            float a;
            float b;
            float g;
            float r;
            float arrowAngle = lockedNorth ? this.getEntityYaw(mainEntity, partial) : 180.0f;
            float arrowOpacity = (float)settings.playerArrowOpacity / 100.0f;
            if (arrowOpacity == 1.0f) {
                this.drawArrow(arrowAngle, 0.0, 1.0, 0.0f, 0.0f, 0.0f, 0.5f, settings);
            }
            if (settings.arrowColour != -1) {
                float[] c = settings.arrowColours[settings.arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getEntityRadar().getTeamColour((Entity)(this.mc.field_71439_g == null ? mainEntity : this.mc.field_71439_g));
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = settings.arrowColours[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(arrowAngle, 0.0, 0.0, r, g, b, a *= arrowOpacity, settings);
        }
        GL11.glPopMatrix();
        GlStateManager.func_179121_F();
        int depthClearerX = scaledX - 25;
        int depthClearerY = scaledY - 25;
        int depthClearerW = 18 + mapSize / 2 + 50;
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-999.0f);
        Gui.func_73734_a((int)depthClearerX, (int)depthClearerY, (int)(depthClearerX + depthClearerW), (int)(depthClearerY + depthClearerW), (int)-16777216);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)999.0f);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179143_c((int)515);
        this.mc.func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        int playerBlockX = OptimizedMath.myFloor(mainEntity.field_70165_t);
        int playerBlockY = OptimizedMath.myFloor(mainEntity.field_70163_u);
        int playerBlockZ = OptimizedMath.myFloor(mainEntity.field_70161_v);
        BlockPos.MutableBlockPos pos = this.mutableBlockPos.func_181079_c(playerBlockX, playerBlockY, playerBlockZ);
        this.minimap.getInfoDisplayRenderer().render(minimapSession, minimap, this.minimap, helper, x, y, width, height, scale, size, playerBlockX, playerBlockY, playerBlockZ, (BlockPos)pos, scaledX, scaledY, mapScale, settings);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
    }

    private void renderCompass(ModSettings settings, int specW, int specH, int halfFrame, double ps, double pc, boolean circleShape, float minimapScale) {
        int compassScale = settings.getCompassScale();
        if (compassScale <= 0) {
            int n = compassScale = settings.compassLocation == 1 ? (int)Math.ceil(minimapScale / 2.0f) : (int)minimapScale;
        }
        if (settings.compassLocation == 1) {
            if (Minecraft.func_71410_x().func_152349_b()) {
                compassScale *= 2;
            }
            halfFrame = (int)((float)halfFrame - 7.0f * minimapScale / 2.0f);
            this.compassRenderer.drawCompass(this.getHelper(), halfFrame - 3 * compassScale, halfFrame - 3 * compassScale, ps, pc, 1.0, circleShape, compassScale, true);
        } else if (settings.compassLocation == 2) {
            this.compassRenderer.drawCompass(this.helper, specW, specH, ps, pc, this.zoom, circleShape, compassScale, false);
        }
    }

    private void drawArrow(float angle, double arrowX, double arrowY, float r, float g, float b, float a, ModSettings settings) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)(0.5 * settings.arrowScale), (double)(0.5 * settings.arrowScale), (double)1.0);
        int offsetY = -6;
        int h = 28;
        int ty = 0;
        GL11.glTranslated((double)-13.0, (double)offsetY, (double)0.0);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.mc.field_71456_v.func_73729_b(0, 0, 49, ty, 26, h);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public float getSunBrightness() {
        WorldClient world = this.mc.field_71441_e;
        float sunBrightness = this.mc.field_71441_e.getSunBrightnessFactor(1.0f);
        float ambient = world.field_73011_w.func_177497_p()[0] * 24.0f / 15.0f;
        if (ambient > 1.0f) {
            ambient = 1.0f;
        }
        return ambient + (1.0f - ambient) * MathHelper.func_76131_a((float)sunBrightness, (float)0.0f, (float)1.0f);
    }

    public MinimapRendererHelper getHelper() {
        return this.helper;
    }

    public double getLastPlayerDimDiv() {
        return this.lastPlayerDimDiv;
    }
}

