/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.element.render.over;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.element.render.MinimapElementReader;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.element.render.MinimapElementRendererHandler;
import xaero.common.minimap.render.MinimapRendererHelper;

public class MinimapElementOverMapRendererHandler
extends MinimapElementRendererHandler {
    private int halfViewW;
    private int halfViewH;
    private int specW;
    private int specH;
    private boolean circle;
    private float optionalScale;
    private final double[] partialTranslate;

    protected MinimapElementOverMapRendererHandler(List<MinimapElementRenderer<?, ?>> renderers, double[] partialTranslate) {
        super(renderers, 1);
        this.partialTranslate = partialTranslate;
    }

    public double render(Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, double playerDimDiv, double ps, double pc, double zoom, boolean cave, float partialTicks, Framebuffer framebuffer, IXaeroMinimap modMain, MinimapRendererHelper helper, FontRenderer font, ScaledResolution scaledRes, int specW, int specH, int halfViewW, int halfViewH, boolean circle, float minimapScale) {
        this.specW = specW;
        this.specH = specH;
        this.halfViewW = halfViewW;
        this.halfViewH = halfViewH;
        this.circle = circle;
        this.optionalScale = minimapScale;
        return super.render(renderEntity, player, renderX, renderY, renderZ, playerDimDiv, ps, pc, zoom, cave, partialTicks, framebuffer, modMain, helper, font, scaledRes);
    }

    @Override
    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(RR renderer, FontRenderer font, Framebuffer framebuffer, MinimapRendererHelper helper, Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, double playerDimDiv, double ps, double pc, double zoom, boolean cave, float partialTicks, int elementIndex, double optionalDepth, E element, MinimapElementReader<E, RRC> elementReader, RRC context, ScaledResolution scaledRes) {
        double offx = elementReader.getRenderX(element, context, partialTicks) / playerDimDiv - renderX;
        double offy = elementReader.getRenderZ(element, context, partialTicks) / playerDimDiv - renderZ;
        GlStateManager.func_179094_E();
        boolean outOfBounds = MinimapElementOverMapRendererHandler.translatePosition(this.specW, this.specH, this.halfViewW, this.halfViewH, ps, pc, offx, offy, zoom, this.circle, this.partialTranslate);
        boolean result = renderer.renderElement(this.location, false, outOfBounds, font, framebuffer, helper, renderEntity, player, renderX, renderY, renderZ, elementIndex, optionalDepth, this.optionalScale, element, this.partialTranslate[0], this.partialTranslate[1], cave, partialTicks, scaledRes);
        GlStateManager.func_179121_F();
        return result;
    }

    @Override
    protected void beforeRender() {
    }

    @Override
    protected void afterRender() {
    }

    @Override
    protected int getIndexLimit() {
        return 9800;
    }

    public static boolean translatePosition(int specW, int specH, int halfViewW, int halfViewH, double ps, double pc, double offx, double offy, double zoom, boolean circle, double[] partialTranslate) {
        double X;
        boolean outOfBounds = false;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
                outOfBounds = true;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
                outOfBounds = true;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
                outOfBounds = true;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
                outOfBounds = true;
            }
            if (!outOfBounds && (borderedX > (double)halfViewW || borderedX < (double)(-halfViewW) || borderedY > (double)halfViewH || borderedY < (double)(-halfViewH))) {
                outOfBounds = true;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
                outOfBounds = true;
            }
            if (!outOfBounds && distSquared > (double)(halfViewW * halfViewW)) {
                outOfBounds = true;
            }
        }
        long roundedX = Math.round(borderedX);
        long roundedY = Math.round(borderedY);
        partialTranslate[0] = borderedX - (double)roundedX;
        partialTranslate[1] = borderedY - (double)roundedY;
        GlStateManager.func_179109_b((float)roundedX, (float)roundedY, (float)0.0f);
        return outOfBounds;
    }

    public static final class Builder
    extends MinimapElementRendererHandler.Builder {
        @Override
        public MinimapElementOverMapRendererHandler build() {
            return (MinimapElementOverMapRendererHandler)super.build();
        }

        @Override
        protected MinimapElementOverMapRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> renderers) {
            return new MinimapElementOverMapRendererHandler(renderers, new double[2]);
        }

        @Override
        protected Builder setDefault() {
            super.setDefault();
            return this;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

