/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorSimpleButtonData;
import xaero.common.category.ui.data.options.text.GuiCategoryUIEditorTextFieldOptionsData;
import xaero.common.category.ui.entry.CategorySettingsListEntry;
import xaero.common.category.ui.entry.CategorySettingsListEntryWidget;
import xaero.common.category.ui.entry.CategorySettingsListEntryWrapper;
import xaero.common.category.ui.entry.CategorySettingsListMainEntry;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.category.ui.entry.ConnectionLineType;
import xaero.common.category.ui.entry.widget.CategorySettingsButton;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;

public final class GuiCategoryUIEditorAdderData
extends GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> {
    private final String displayName;
    private final GuiCategoryUIEditorTextFieldOptionsData nameField;
    private final GuiCategoryUIEditorSimpleButtonData confirmButton;
    private boolean confirmed;

    private GuiCategoryUIEditorAdderData(@Nonnull String displayName, @Nonnull GuiCategoryUIEditorTextFieldOptionsData nameField, @Nonnull GuiCategoryUIEditorSimpleButtonData confirmButton, boolean movable, @Nonnull CategorySettingsListMainEntryFactory listEntryFactory, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> tooltipSupplier) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.displayName = displayName;
        this.confirmButton = confirmButton;
        this.nameField = nameField;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    @Override
    public void setExpanded(boolean expanded) {
        super.setExpanded(expanded);
        if (expanded) {
            this.reset();
        }
    }

    public void reset() {
        this.confirmed = false;
        this.nameField.resetInput("");
    }

    public GuiCategoryUIEditorTextFieldOptionsData getNameField() {
        return this.nameField;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public List<GuiCategoryUIEditorExpandableData<?>> getSubExpandables() {
        return Lists.newArrayList((Object[])new GuiCategoryUIEditorExpandableData[]{this.nameField, this.confirmButton});
    }

    public static final class Builder
    extends GuiCategoryUIEditorExpandableData.Builder<GuiCategoryUIEditorExpandableData<?>, Builder> {
        private String displayName;
        private final GuiCategoryUIEditorTextFieldOptionsData.Builder nameFieldBuilder;
        private final GuiCategoryUIEditorSimpleButtonData.Builder confirmButtonBuilder;

        private Builder(ListFactory listFactory) {
            this.nameFieldBuilder = GuiCategoryUIEditorTextFieldOptionsData.Builder.getDefault(listFactory);
            this.confirmButtonBuilder = GuiCategoryUIEditorSimpleButtonData.Builder.getDefault();
        }

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setDisplayName(null);
            this.nameFieldBuilder.setDefault().setDisplayName(I18n.func_135052_a((String)"gui.xaero_category_name", (Object[])new Object[0]));
            this.confirmButtonBuilder.setDefault().setDisplayName(I18n.func_135052_a((String)"gui.xaero_category_confirm", (Object[])new Object[0]));
            this.confirmButtonBuilder.setCallback(new GuiCategoryUIEditorSimpleButtonData.ISimpleButtonCallback(){

                @Override
                public void onButtonPress(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorSimpleButtonData bd, GuiCategorySettings.SettingRowList rl) {
                    GuiCategoryUIEditorAdderData adder;
                    adder.confirmed = !(adder = (GuiCategoryUIEditorAdderData)parent).getNameField().getResult().isEmpty();
                    adder.setExpanded(false);
                    rl.setLastExpandedData(adder);
                    rl.updateEntries();
                }
            });
            this.setListEntryFactory(new CategorySettingsListMainEntryFactory(){

                @Override
                public CategorySettingsListMainEntry<?> get(final GuiCategoryUIEditorExpandableData<?> data, final GuiCategoryUIEditorExpandableData<?> parent, final int index, ConnectionLineType lineType, final GuiCategorySettings.SettingRowList rowList, int screenWidth, boolean isFinalExpanded) {
                    return new CategorySettingsListEntryWrapper(new CategorySettingsListMainEntry.CenteredEntryFactory(){

                        @Override
                        public CategorySettingsListEntry get(int x, int y, int width, int height, CategorySettingsListMainEntry<?> root) {
                            return new CategorySettingsListEntryWidget(x, y, width, height, index, rowList, root, new CategorySettingsButton(parent, new Supplier<String>(){

                                @Override
                                public String get() {
                                    return data.getDisplayName();
                                }
                            }, true, 216, 20, new CategorySettingsButton.PressAction(){

                                @Override
                                public void onPress(CategorySettingsButton b) {
                                    data.getExpandAction(rowList).run();
                                }
                            }, rowList), data.getTooltipSupplier(parent));
                        }
                    }, screenWidth, index, rowList, lineType, data);
                }
            });
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return (Builder)this.self;
        }

        public GuiCategoryUIEditorTextFieldOptionsData.Builder getNameFieldBuilder() {
            return this.nameFieldBuilder;
        }

        public GuiCategoryUIEditorSimpleButtonData.Builder getConfirmButtonBuilder() {
            return this.confirmButtonBuilder;
        }

        public static Builder getDefault(ListFactory listFactory) {
            return new Builder(listFactory).setDefault();
        }

        public GuiCategoryUIEditorAdderData build() {
            if (this.displayName == null) {
                throw new IllegalStateException("required fields not set!");
            }
            GuiCategoryUIEditorAdderData result = (GuiCategoryUIEditorAdderData)super.build();
            return result;
        }

        protected GuiCategoryUIEditorAdderData buildInternally() {
            if (this.nameFieldBuilder.needsInputStringValidator()) {
                this.nameFieldBuilder.setInputStringValidator(new Predicate<String>(){

                    @Override
                    public boolean test(String s) {
                        return true;
                    }
                });
            }
            return new GuiCategoryUIEditorAdderData(this.displayName, this.nameFieldBuilder.build(), this.confirmButtonBuilder.build(), this.movable, this.listEntryFactory, this.tooltipSupplier);
        }
    }
}

