/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import wanion.lib.common.Dependencies;
import wanion.lib.common.IController;
import wanion.lib.common.control.ControlController;
import wanion.lib.common.field.FieldController;
import wanion.lib.common.matching.MatchingController;

public abstract class WTileEntity
extends TileEntity
implements ISidedInventory {
    private final Dependencies<IController<?, ?>> controllerHandler = new Dependencies();
    private final Collection<IController<?, ?>> controllers = this.controllerHandler.getInstances();
    private final Map<Capability<?>, Object> capabilitiesMap = new HashMap();
    private String customName = null;
    protected final NonNullList<ItemStack> itemStacks = this.getItemStacks();

    public WTileEntity() {
        this.controllerHandler.subscribe(ControlController.class, () -> new ControlController((IInventory)this));
        this.controllerHandler.subscribe(FieldController.class, () -> new FieldController((IInventory)this));
        this.controllerHandler.subscribe(MatchingController.class, () -> new MatchingController((IInventory)this));
    }

    protected NonNullList<ItemStack> getItemStacks() {
        return NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public <C> void addCapability(@Nonnull Capability<C> capability, C cObj) {
        this.capabilitiesMap.put(capability, cObj);
    }

    @Nonnull
    public abstract String getDefaultName();

    public final <A extends IController<?, ?>> A getController(@Nonnull Class<A> aClass) {
        return (A)((IController)((Object)this.controllerHandler.get(aClass)));
    }

    public final Collection<IController<?, ?>> getControllers() {
        return this.controllers;
    }

    public final <A extends IController<?, ?>> boolean hasController(@Nonnull Class<A> aClass) {
        return this.controllerHandler.contains(aClass);
    }

    public final void func_145839_a(@Nonnull NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readCustomNBT(nbtTagCompound);
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        NBTTagCompound displayTag = nbtTagCompound.func_74775_l("display");
        if (displayTag.func_74764_b("Name")) {
            this.customName = displayTag.func_74779_i("Name");
        }
        NBTTagList nbtTagList = nbtTagCompound.func_150295_c("Contents", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound slotCompound = nbtTagList.func_150305_b(i);
            short slot = slotCompound.func_74765_d("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, new ItemStack(slotCompound));
        }
        this.controllers.forEach(controller -> controller.readNBT(nbtTagCompound));
    }

    @Nonnull
    public final NBTTagCompound func_189515_b(@Nonnull NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        return this.writeCustomNBT(nbtTagCompound);
    }

    public NBTTagCompound writeCustomNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        if (this.customName != null) {
            NBTTagCompound nameNBT = new NBTTagCompound();
            nameNBT.func_74778_a("Name", this.customName);
            nbtTagCompound.func_74782_a("display", (NBTBase)nameNBT);
        }
        NBTTagList nbtTagList = new NBTTagList();
        int max = MathHelper.func_76125_a((int)this.func_70302_i_(), (int)0, (int)this.itemStacks.size());
        for (int i = 0; i < max; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            NBTTagCompound slotCompound = new NBTTagCompound();
            slotCompound.func_74777_a("Slot", (short)i);
            nbtTagList.func_74742_a((NBTBase)itemStack.func_77955_b(slotCompound));
        }
        this.controllers.forEach(controller -> nbtTagCompound.func_179237_a(controller.writeNBT()));
        this.controllers.forEach(controller -> controller.afterWriteNBT(nbtTagCompound));
        if (!nbtTagList.func_82582_d()) {
            nbtTagCompound.func_74782_a("Contents", (NBTBase)nbtTagList);
        }
        return nbtTagCompound;
    }

    @Nonnull
    public final ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return false;
    }

    public boolean func_191420_l() {
        return this.itemStacks.stream().allMatch(ItemStack::func_190926_b);
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        ItemStack slotStack = (ItemStack)this.itemStacks.get(index);
        if (slotStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack newStack = slotStack.func_77946_l();
        newStack.func_190920_e(count);
        slotStack.func_190920_e(slotStack.func_190916_E() - count);
        if (slotStack.func_190916_E() == 0) {
            this.itemStacks.set(index, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
        return newStack;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack itemStack = (ItemStack)this.itemStacks.get(index);
        this.itemStacks.set(index, (Object)ItemStack.field_190927_a);
        this.func_70296_d();
        return itemStack;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public final boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return true;
    }

    public final int func_174887_a_(int id) {
        return 0;
    }

    public final void func_174885_b(int id, int value) {
    }

    public final int func_174890_g() {
        return 0;
    }

    public final void func_174888_l() {
    }

    @Nonnull
    public final String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : this.getDefaultName();
    }

    public final boolean func_145818_k_() {
        return this.customName != null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.capabilitiesMap.containsKey(capability) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return (T)(this.capabilitiesMap.containsKey(capability) ? this.capabilitiesMap.get(capability) : super.getCapability(capability, facing));
    }
}

