/*
 * Decompiled with CFR 0.152.
 */
package shadows.singularity.proxy;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shadows.placebo.Placebo;
import shadows.singularity.Singularities;
import shadows.singularity.block.TileCompressor;
import shadows.singularity.client.ItemLayerWrapper;
import shadows.singularity.client.RenderCompressor;
import shadows.singularity.client.RenderSingularity;
import shadows.singularity.item.Singularity;
import shadows.singularity.proxy.Proxy;

public class ClientProxy
extends Proxy {
    private static final ModelResourceLocation MRL = new ModelResourceLocation(new ResourceLocation("singularities", "default"), "type=singularity");

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.bindTileEntitySpecialRenderer(TileCompressor.class, (TileEntitySpecialRenderer)new RenderCompressor());
        Singularities.SINGULARITY.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new RenderSingularity());
    }

    @SubscribeEvent
    public void models(ModelRegistryEvent e) {
        Placebo.PROXY.useRenamedMapper(Singularities.COMPRESSOR, "default", ",type=compressor");
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Singularities.COMPRESSOR), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("singularities", "default"), "facing=north,type=compressor"));
        for (Singularity s : Singularity.getSingularities()) {
            ModelLoader.setCustomModelResourceLocation((Item)Singularities.SINGULARITY, (int)s.getID(), (ModelResourceLocation)MRL);
        }
    }

    @Override
    public void init(FMLInitializationEvent e) {
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tint) -> {
            Singularity sing = Singularity.getByID(stack.func_77960_j());
            if (tint == 0) {
                return sing.getColor2();
            }
            if (tint == 1) {
                return sing.getColor1();
            }
            return -1;
        }, new Item[]{Singularities.SINGULARITY});
    }

    @SubscribeEvent
    public void onTexStitch(TextureStitchEvent event) {
        event.getMap().func_174942_a(new ResourceLocation("singularities", "items/halo"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        RenderSingularity.model = new ItemLayerWrapper((IBakedModel)event.getModelRegistry().func_82594_a((Object)MRL));
        event.getModelRegistry().func_82595_a((Object)MRL, (Object)RenderSingularity.model);
    }

    @Override
    public String translate(String lang, Object ... args) {
        return I18n.func_135052_a((String)lang, (Object[])args);
    }
}

