/*
 * Decompiled with CFR 0.152.
 */
package shadows.singularity.item;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import shadows.singularity.Singularities;

public class Singularity {
    private static final Map<String, Singularity> NAME_TO_SINGULARITY = new HashMap<String, Singularity>();
    private static final Map<Integer, Singularity> META_TO_SINGULARITY = new HashMap<Integer, Singularity>();
    private static final Singularity MISSING = new Singularity("MISSING", 0, 0, Short.MAX_VALUE, EnumRarity.EPIC, false);
    private static final List<Singularity> SORTED = new ArrayList<Singularity>();
    private final String name;
    private final int color1;
    private final int color2;
    private final int id;
    private final EnumRarity rarity;
    private final boolean hasEffect;

    public Singularity(String name, int color1, int color2, int meta, EnumRarity rarity, boolean hasEffect) {
        Preconditions.checkArgument((NAME_TO_SINGULARITY.get(name) == null ? 1 : 0) != 0, (Object)("Duplicate singularity! Name: " + name));
        Preconditions.checkArgument((META_TO_SINGULARITY.get(meta) == null ? 1 : 0) != 0, (Object)("Meta already in use! Name: " + name + ", Meta: " + meta));
        this.name = name;
        this.color1 = color1;
        this.color2 = color2;
        this.id = meta;
        this.rarity = rarity;
        this.hasEffect = hasEffect;
    }

    public Singularity(String name, int color1, int color2, int meta, boolean hasEffect) {
        this(name, color1, color2, meta, EnumRarity.UNCOMMON, hasEffect);
    }

    public String getName() {
        return this.name;
    }

    public String makeOreName() {
        String[] split = this.name.split(" ");
        String concat = "";
        for (String s : split) {
            concat = concat + s;
        }
        return "singularity" + StringUtils.capitalize((String)concat);
    }

    public int getColor1() {
        return this.color1;
    }

    public int getColor2() {
        return this.color2;
    }

    public int getID() {
        return this.id;
    }

    public ItemStack getStack() {
        return new ItemStack(Singularities.SINGULARITY, 1, this.id);
    }

    public EnumRarity getRarity() {
        return this.rarity;
    }

    public boolean hasEffect() {
        return this.hasEffect;
    }

    public static Collection<Singularity> getSingularities() {
        return NAME_TO_SINGULARITY.values();
    }

    public static Singularity getByName(String name) {
        return NAME_TO_SINGULARITY.getOrDefault(name, MISSING);
    }

    public static Singularity getByID(int id) {
        return META_TO_SINGULARITY.getOrDefault(id, MISSING);
    }

    public static Singularity fromString(String s) {
        String[] split = s.split(", ");
        Preconditions.checkArgument((split.length == 5 || split.length == 6 ? 1 : 0) != 0, (Object)("Invalid Singularity! String: " + s));
        String name = split[0];
        int color1 = Integer.parseInt(split[1].contains("0x") ? split[1].substring(2) : split[1], split[1].contains("0x") ? 16 : 10);
        int color2 = Integer.parseInt(split[2].contains("0x") ? split[2].substring(2) : split[2], split[2].contains("0x") ? 16 : 10);
        int rarity = Integer.parseInt(split[3]);
        int meta = Integer.parseInt(split[4]);
        boolean hasEffect = split.length == 6 ? Boolean.parseBoolean(split[5]) : false;
        Preconditions.checkArgument((rarity >= 0 && rarity <= 3 ? 1 : 0) != 0, (Object)("Invalid rarity int value, must be between 0 and 3.  Current: " + rarity));
        return new Singularity(name, color1, color2, meta, EnumRarity.values()[rarity], hasEffect);
    }

    public static void register(Singularity s) {
        NAME_TO_SINGULARITY.put(s.getName(), s);
        META_TO_SINGULARITY.put(s.getID(), s);
    }

    public static String[] updateToV220(String[] sing) {
        String[] ret = new String[sing.length];
        for (int i = 0; i < sing.length; ++i) {
            String[] split = sing[i].split(", ");
            ret[i] = split.length == 5 ? sing[i] : sing[i] + ", " + i;
        }
        return ret;
    }

    public static void operateSorted(Consumer<? super Singularity> c) {
        if (SORTED.isEmpty()) {
            SORTED.addAll(Singularity.getSingularities().stream().sorted(Singularities.SingularityComparator.INSTANCE).collect(Collectors.toList()));
        }
        SORTED.forEach(c);
    }
}

