/*
 * Decompiled with CFR 0.152.
 */
package shadows.singularity;

import it.unimi.dsi.fastutil.ints.IntComparators;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.registry.RegistryInformation;
import shadows.placebo.util.RecipeHelper;
import shadows.singularity.avaritia.AvaritiaCompat;
import shadows.singularity.block.BlockCompressor;
import shadows.singularity.block.TileCompressor;
import shadows.singularity.item.ItemSingularity;
import shadows.singularity.item.Singularity;
import shadows.singularity.proxy.Proxy;
import shadows.singularity.recipe.SingularityConfig;

@Mod(modid="singularities", name="Singularities", version="2.4.1", dependencies="required-after:placebo@[1.2.0,);before:crafttweaker;after:avaritia", acceptedMinecraftVersions="[1.12.2]")
public class Singularities {
    public static final String MODID = "singularities";
    public static final String MODNAME = "Singularities";
    public static final String VERSION = "2.4.1";
    public static final String DEPS = "required-after:placebo@[1.2.0,);before:crafttweaker;after:avaritia";
    public static final CreativeTabs TAB = new CreativeTabs("singularities"){

        public ItemStack func_78016_d() {
            return new ItemStack(SINGULARITY);
        }
    };
    public static final RegistryInformation INFO = new RegistryInformation("singularities", TAB);
    public static final RecipeHelper HELPER = new RecipeHelper("singularities", "Singularities", INFO.getRecipeList());
    public static final Item SINGULARITY = new ItemSingularity();
    public static final Block COMPRESSOR = new BlockCompressor();
    @SidedProxy(clientSide="shadows.singularity.proxy.ClientProxy", serverSide="shadows.singularity.proxy.Proxy")
    public static Proxy PROXY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        SingularityConfig.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PROXY.preInit(e);
    }

    @SubscribeEvent
    public void block(RegistryEvent.Register<Block> e) {
        e.getRegistry().register((IForgeRegistryEntry)COMPRESSOR);
        GameRegistry.registerTileEntity(TileCompressor.class, (ResourceLocation)COMPRESSOR.getRegistryName());
    }

    @SubscribeEvent
    public void item(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])INFO.getItemList().toArray(new Item[2]));
        Singularity.operateSorted(s -> OreDictionary.registerOre((String)s.makeOreName(), (ItemStack)new ItemStack(SINGULARITY, 1, s.getID())));
    }

    @SubscribeEvent
    public void recipe(RegistryEvent.Register<IRecipe> e) {
        if (SingularityConfig.hideCompressor) {
            return;
        }
        HELPER.addShaped((IForgeRegistryEntry)COMPRESSOR, 3, 3, new Object[]{"blockDiamond", Blocks.field_150331_J, "blockDiamond", Blocks.field_150477_bB, Items.field_151156_bN, Blocks.field_150477_bB, "blockDiamond", Blocks.field_150331_J, "blockDiamond"});
        e.getRegistry().registerAll((IForgeRegistryEntry[])INFO.getRecipeList().toArray(new IRecipe[1]));
        if (Loader.isModLoaded((String)"avaritia") && SingularityConfig.adjustCatalyst) {
            AvaritiaCompat.messWithCatalyst();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        SingularityConfig.init(e);
        PROXY.init(e);
        INFO.purge();
    }

    public static class SingularityComparator
    implements Comparator<Singularity> {
        public static SingularityComparator INSTANCE = new SingularityComparator();

        @Override
        public int compare(Singularity o1, Singularity o2) {
            return IntComparators.NATURAL_COMPARATOR.compare(o1.getID(), o2.getID());
        }
    }
}

