/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.recipe;

import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.lib.RecipeManager;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.common.util.RecipeMatcher;
import org.apache.commons.lang3.ArrayUtils;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.util.PatternHelper;
import thelm.packageddraconic.recipe.IRecipeInfoFusion;
import thelm.packageddraconic.recipe.RecipeTypeFusion;

public class RecipeInfoFusion
implements IRecipeInfoFusion {
    IFusionRecipe recipe;
    ItemStack inputCore = ItemStack.field_190927_a;
    List<ItemStack> inputInjector = new ArrayList<ItemStack>();
    List<ItemStack> input = new ArrayList<ItemStack>();
    ItemStack output;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public void readFromNBT(NBTTagCompound nbt) {
        this.inputInjector.clear();
        this.input.clear();
        this.output = ItemStack.field_190927_a;
        this.inputCore = new ItemStack(nbt.func_74775_l("InputCore"));
        MiscUtil.loadAllItems((NBTTagList)nbt.func_150295_c("InputInjector", 10), this.inputInjector);
        this.patterns.clear();
        if (this.inputInjector.isEmpty()) {
            return;
        }
        for (IFusionRecipe recipe : RecipeManager.FUSION_REGISTRY.getRecipes()) {
            List matchers;
            if (!recipe.isRecipeCatalyst(this.inputCore) || recipe.getRecipeIngredients().size() != this.inputInjector.size() || RecipeMatcher.findMatches(this.inputInjector, (List)(matchers = Lists.transform((List)recipe.getRecipeIngredients(), RecipeInfoFusion::getIngredient))) == null) continue;
            this.recipe = recipe;
            if (recipe.getRecipeCatalyst().func_190926_b()) break;
            this.inputCore.func_190920_e(recipe.getRecipeCatalyst().func_190916_E());
            break;
        }
        if (this.recipe != null) {
            ArrayList<ItemStack> toCondense = new ArrayList<ItemStack>(this.inputInjector);
            toCondense.add(this.inputCore);
            this.input.addAll(MiscUtil.condenseStacks(toCondense));
            this.output = this.recipe.getRecipeOutput(this.inputCore);
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PatternHelper((IRecipeInfo)this, i));
                ++i;
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound inputCoreTag = this.inputCore.func_77955_b(new NBTTagCompound());
        NBTTagList inputInjectorTag = MiscUtil.saveAllItems((NBTTagList)new NBTTagList(), this.inputInjector);
        nbt.func_74782_a("InputCore", (NBTBase)inputCoreTag);
        nbt.func_74782_a("InputInjector", (NBTBase)inputInjectorTag);
        return nbt;
    }

    public IRecipeType getRecipeType() {
        return RecipeTypeFusion.INSTANCE;
    }

    public boolean isValid() {
        return this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public ItemStack getCoreInput() {
        return this.inputCore.func_77946_l();
    }

    @Override
    public List<ItemStack> getInjectorInputs() {
        return Collections.unmodifiableList(this.inputInjector);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public int getTierRequired() {
        return MathHelper.func_76125_a((int)this.recipe.getRecipeTier(), (int)0, (int)3);
    }

    @Override
    public long getEnergyRequired() {
        return this.recipe.getIngredientEnergyCost();
    }

    @Override
    public IFusionRecipe getRecipe() {
        return this.recipe;
    }

    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.recipe = null;
        this.inputCore = ItemStack.field_190927_a;
        this.inputInjector.clear();
        this.input.clear();
        this.patterns.clear();
        int[] slotArray = RecipeTypeFusion.SLOTS.toIntArray();
        ArrayUtils.shift((int[])slotArray, (int)0, (int)25, (int)1);
        for (int i = 0; i < 49; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            if (!toSet.func_190926_b()) {
                toSet.func_190920_e(1);
                if (i == 0) {
                    this.inputCore = toSet;
                    continue;
                }
                this.inputInjector.add(toSet.func_77946_l());
                continue;
            }
            if (i != 0) continue;
            return;
        }
        for (IFusionRecipe recipe : RecipeManager.FUSION_REGISTRY.getRecipes()) {
            List matchers;
            if (!recipe.isRecipeCatalyst(this.inputCore) || recipe.getRecipeIngredients().size() != this.inputInjector.size() || RecipeMatcher.findMatches(this.inputInjector, (List)(matchers = Lists.transform((List)recipe.getRecipeIngredients(), RecipeInfoFusion::getIngredient))) == null) continue;
            this.recipe = recipe;
            if (!recipe.getRecipeCatalyst().func_190926_b()) {
                this.inputCore.func_190920_e(recipe.getRecipeCatalyst().func_190916_E());
                this.inputCore = this.inputCore.func_77946_l();
            }
            ArrayList<ItemStack> toCondense = new ArrayList<ItemStack>(this.inputInjector);
            toCondense.add(this.inputCore);
            this.input.addAll(MiscUtil.condenseStacks(toCondense));
            this.output = recipe.getRecipeOutput(this.inputCore).func_77946_l();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PatternHelper((IRecipeInfo)this, i));
                ++i;
            }
            return;
        }
    }

    protected static Ingredient getIngredient(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            return stack.func_77942_o() ? new IngredientNBT(stack){} : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
        }
        return CraftingHelper.getIngredient((Object)obj);
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = RecipeTypeFusion.SLOTS.toIntArray();
        ArrayUtils.remove((int[])slotArray, (int)24);
        map.put(40, (Object)this.inputCore);
        for (int i = 0; i < this.inputInjector.size(); ++i) {
            map.put(slotArray[i], (Object)this.inputInjector.get(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecipeInfoFusion) {
            RecipeInfoFusion other = (RecipeInfoFusion)obj;
            return MiscUtil.recipeEquals((IRecipeInfo)this, (Object)this.recipe, (IRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscUtil.recipeHashCode((IRecipeInfo)this, (Object)this.recipe);
    }
}

