/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.recipe.RecipeTypeProcessingOrdered;
import thelm.packagedauto.util.PatternHelper;

public class RecipeInfoProcessingOrdered
implements IRecipeInfo {
    List<ItemStack> input = new ArrayList<ItemStack>();
    List<ItemStack> output = new ArrayList<ItemStack>();
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        MiscUtil.loadAllItems(nbt.func_150295_c("Input", 10), this.input);
        MiscUtil.loadAllItems(nbt.func_150295_c("Output", 10), this.output);
        this.patterns.clear();
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PatternHelper(this, i, true));
            ++i;
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList inputTag = MiscUtil.saveAllItems(new NBTTagList(), this.input);
        nbt.func_74782_a("Input", (NBTBase)inputTag);
        NBTTagList outputTag = MiscUtil.saveAllItems(new NBTTagList(), this.output);
        nbt.func_74782_a("Output", (NBTBase)outputTag);
        return nbt;
    }

    @Override
    public IRecipeType getRecipeType() {
        return RecipeTypeProcessingOrdered.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return !this.input.isEmpty();
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.unmodifiableList(this.output);
    }

    private static List<ItemStack> removeEmptyStacks(List<ItemStack> stacks) {
        return stacks.stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }

    @Override
    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.input.clear();
        this.input.addAll(RecipeInfoProcessingOrdered.removeEmptyStacks(input));
        this.output.clear();
        this.output.addAll(RecipeInfoProcessingOrdered.removeEmptyStacks(output));
        this.patterns.clear();
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PatternHelper(this, i, true));
            ++i;
        }
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        int i;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (i = 0; i < this.input.size(); ++i) {
            map.put(i, (Object)this.input.get(i));
        }
        for (i = 0; i < this.output.size(); ++i) {
            map.put(i + 81, (Object)this.output.get(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RecipeInfoProcessingOrdered) {
            RecipeInfoProcessingOrdered other = (RecipeInfoProcessingOrdered)obj;
            return MiscUtil.recipeEquals(this, null, other, null);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscUtil.recipeHashCode(this, null);
    }
}

