/*
 * Decompiled with CFR 0.152.
 */
package com.ethercd.mysticalagriexpansion.block;

import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.ethercd.mysticalagriexpansion.MACreativeTabs;
import com.ethercd.mysticalagriexpansion.block.ModBlock;
import com.ethercd.mysticalagriexpansion.block.ModBlocks;
import com.ethercd.mysticalagriexpansion.item.ModItems;
import com.ethercd.mysticalagriexpansion.lib.ModChecker;
import com.ethercd.mysticalagriexpansion.lib.ModTooltips;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum BlockGrowthAccelerator {
    TIER2(150, 2, true),
    TIER3(200, 3, true),
    TIER4(250, 4, true),
    TIER5(300, 5, true),
    TIER6(500, 6, ModChecker.INSANIUM);

    private final BlockGrowth block;
    private final boolean active;
    private final String name;

    private BlockGrowthAccelerator(int accelerate, int tier, boolean active) {
        this.block = new BlockGrowth(accelerate, tier);
        this.active = active;
        this.name = "tier" + tier + "_growth_accelerator";
    }

    public BlockGrowth getBlock() {
        return this.block;
    }

    public static void init() {
        for (BlockGrowthAccelerator block : BlockGrowthAccelerator.values()) {
            if (!block.active) continue;
            ModBlocks.add(block.block, block.name);
            ModItems.add(new ItemBlock((Block)block.block).func_77637_a(MACreativeTabs.CREATIVE_TAB), block.name);
        }
    }

    static class BlockGrowth
    extends ModBlock
    implements IEnableable {
        private final int delay;
        private final float accelerate;
        private final int tier;

        public BlockGrowth(int accelerate, int tier) {
            super("tier" + tier + "_growth_accelerator", Material.field_151576_e, SoundType.field_185851_d, 5.0f, 8.0f);
            this.func_149675_a(false);
            this.delay = (int)Math.ceil((double)ModConfig.confGrowthAcceleratorSpeed * (100.0 / (double)accelerate) * 20.0);
            this.accelerate = accelerate;
            this.tier = tier;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
            switch (this.tier) {
                case 2: {
                    tooltip.add(ModTooltips.GROWTH_ACCELERATOR + " " + "\u00a7a" + this.accelerate + "%");
                    break;
                }
                case 3: {
                    tooltip.add(ModTooltips.GROWTH_ACCELERATOR + " " + "\u00a76" + this.accelerate + "%");
                    break;
                }
                case 4: {
                    tooltip.add(ModTooltips.GROWTH_ACCELERATOR + " " + "\u00a7b" + this.accelerate + "%");
                    break;
                }
                case 5: {
                    tooltip.add(ModTooltips.GROWTH_ACCELERATOR + " " + "\u00a7c" + this.accelerate + "%");
                    break;
                }
                case 6: {
                    tooltip.add(ModTooltips.GROWTH_ACCELERATOR + " " + "\u00a75" + this.accelerate + "%");
                }
            }
        }

        public void func_176213_c(World world, BlockPos pos, IBlockState state) {
            world.func_180497_b(pos, state.func_177230_c(), this.delay, 1);
            super.func_176213_c(world, pos, state);
        }

        public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
            if (!world.field_72995_K) {
                this.growCropsNearby(world, pos, state);
            }
        }

        private void growCropsNearby(World world, BlockPos pos, IBlockState state) {
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(0, 1, 0), (BlockPos)pos.func_177982_a(0, 64, 0));
            for (BlockPos aoePos : blocks) {
                IBlockState cropState = world.func_180495_p(new BlockPos((Vec3i)aoePos));
                Block cropBlock = cropState.func_177230_c();
                if (!(cropBlock instanceof IGrowable) && !(cropBlock instanceof IPlantable)) continue;
                cropBlock.func_180650_b(world, new BlockPos((Vec3i)aoePos), cropState, world.field_73012_v);
            }
            world.func_180497_b(pos, state.func_177230_c(), this.delay, 1);
        }

        public boolean isEnabled() {
            return ModConfig.confGrowthAccelerator;
        }
    }
}

