/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity.furnace;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEssenceFurnace
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    protected static final int[] SLOTS_TOP = new int[]{0};
    protected static final int[] SLOTS_BOTTOM = new int[]{2, 1};
    protected static final int[] SLOTS_SIDES = new int[]{1};
    protected NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    protected int furnaceBurnTime;
    protected int currentItemBurnTime;
    protected int cookTime;
    protected int totalCookTime;
    protected String furnaceCustomName;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public boolean func_191420_l() {
        return !this.furnaceItemStacks.stream().anyMatch(s -> !s.func_190926_b());
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.furnaceItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceCustomName : "container.ma.inferium_furnace.name";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && !this.furnaceCustomName.isEmpty();
    }

    public void setCustomInventoryName(String name) {
        this.furnaceCustomName = name;
    }

    public static void registerFixesFurnace(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileEssenceFurnace.class, new String[]{"Items"}));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.furnaceItemStacks);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEssenceFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.furnaceItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEssenceFurnace.getItemBurnTime(itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.furnaceItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime() {
        return 200;
    }

    protected void setState(boolean active, World world, BlockPos pos) {
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.furnaceItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        int result = itemstack1.func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(0);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = (ItemStack)this.furnaceItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 200;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 200;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEssenceFurnace.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(1);
        return TileEssenceFurnace.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing facing) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing facing) {
        Item item;
        return facing != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String func_174875_k() {
        return "minecraft:furnace";
    }

    public Container func_174876_a(InventoryPlayer inventory, EntityPlayer player) {
        return new ContainerFurnace(inventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.furnaceItemStacks.clear();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

