/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class VerticalPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg.png");

    public VerticalPotionRenderer(Minecraft mc) {
        super(mc);
    }

    private int getX(int width) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                result = width / 2 - 30 - this.potX;
                break;
            }
            case RIGHT: {
                result = width - this.potX;
            }
        }
        return result;
    }

    private int getY(int height, int effCount) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    result = height / 2 - 12 - this.potY;
                    break;
                }
                if (this.potY < 0) {
                    result = height / 2 - 12 - (effCount - 1) * (24 + this.potGap) - this.potY;
                    break;
                }
                result = (int)((float)(height / 2 - 12) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 12.0f) - (float)this.potY);
                break;
            }
            case BOTTOM: {
                result = height - this.potY - (effCount - 1) * (this.potGap + 24);
            }
        }
        return result;
    }

    @Override
    public void render(int width, int height) {
        int y = 0;
        int effCount = this.mc.field_71439_g.func_70651_bq().size();
        if (effCount == 0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-255.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        int xPos = this.getX(width);
        int yPos = this.getY(height, effCount);
        for (PotionEffect effect : this.mc.field_71439_g.func_70651_bq()) {
            Potion pot = effect.func_188419_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
            this.mc.func_110434_K().func_110577_a(this.PBG);
            VerticalPotionRenderer.func_146110_a((int)xPos, (int)(yPos + y), (float)0.0f, (float)0.0f, (int)60, (int)24, (float)(60 * this.potSide), (float)24.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderIcon(pot, xPos + 3 + this.potIconSide, yPos + y + 3, 18, 1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int lev = effect.func_76458_c();
            if (lev < 0 || lev > 8) {
                lev = 9;
            }
            this.mc.func_110434_K().func_110577_a(this.POTLEV[lev]);
            VerticalPotionRenderer.func_146110_a((int)(xPos + 15 + this.potIconSide), (int)(yPos + y), (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
            String time = "";
            int dur = effect.func_76459_b() / 20;
            if (dur > 1600) {
                time = " **:**";
            } else {
                String mins = dur / 60 + "";
                String secs = dur % 60 + "";
                if (dur / 60 < 10) {
                    mins = "0" + mins;
                }
                if (dur % 60 < 10) {
                    secs = "0" + secs;
                }
                time = dur > 10 ? mins + ":" + secs : TextFormatting.RED + mins + TextFormatting.WHITE + ":" + TextFormatting.RED + secs;
            }
            this.fontRenderer.func_175063_a(time, (float)(xPos + 28 + this.potTextSide), (float)(yPos + y + 8), 0xFFFFFF);
            y += 24 + this.potGap;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

