/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.HudRenderer;
import dlovin.inventoryhud.utils.Color4F;
import dlovin.inventoryhud.utils.WidgetAligns;
import dlovin.inventoryhud.utils.potions.ModWithPotions;
import dlovin.inventoryhud.utils.potions.PotionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

public class PotionRenderer
extends HudRenderer {
    public int potX;
    public int potY;
    public WidgetAligns PotAligns;
    public int potSide;
    public int potIconSide;
    public int potTextSide;
    public int potVert;
    public float potAlpha;
    public boolean potMini;
    public int potGap;
    public int barDuration;
    Minecraft mc;
    FontRenderer fontRenderer;
    final ResourceLocation PMT = new ResourceLocation("inventoryhud", "textures/gui/potminitime.png");
    final ResourceLocation INVENTORY_BACKGROUND = new ResourceLocation("textures/gui/container/inventory.png");
    final ResourceLocation[] POTLEV = new ResourceLocation[]{new ResourceLocation("inventoryhud", "textures/gui/l_0.png"), new ResourceLocation("inventoryhud", "textures/gui/l_1.png"), new ResourceLocation("inventoryhud", "textures/gui/l_2.png"), new ResourceLocation("inventoryhud", "textures/gui/l_3.png"), new ResourceLocation("inventoryhud", "textures/gui/l_4.png"), new ResourceLocation("inventoryhud", "textures/gui/l_5.png"), new ResourceLocation("inventoryhud", "textures/gui/l_6.png"), new ResourceLocation("inventoryhud", "textures/gui/l_7.png"), new ResourceLocation("inventoryhud", "textures/gui/l_8.png"), new ResourceLocation("inventoryhud", "textures/gui/l_inf.png")};

    public PotionRenderer(Minecraft mc) {
        this.mc = mc;
        this.fontRenderer = mc.field_71466_p;
    }

    public void render(int width, int height) {
    }

    private void PotPosVertChanged() {
        switch (this.PotAligns.HorAlign) {
            case RIGHT: {
                if (!this.potMini) {
                    this.potSide = -1;
                    this.potIconSide = 36;
                    this.potTextSide = -22;
                    break;
                }
                this.potSide = -1;
                this.potIconSide = 4;
                this.potTextSide = -15;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    if (!this.potMini) {
                        this.potSide = -1;
                        this.potIconSide = 36;
                        this.potTextSide = -22;
                        break;
                    }
                    this.potSide = -1;
                    this.potIconSide = 4;
                    this.potTextSide = -15;
                    break;
                }
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
                break;
            }
            case LEFT: {
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
            }
        }
    }

    public void PotPosChanged() {
        InventoryHUD.getConfig();
        if (InvConfig.pot.potHor) {
            this.PotPosHorChanged();
        } else {
            this.PotPosVertChanged();
        }
    }

    private void PotPosHorChanged() {
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    this.potSide = -1;
                    this.potTextSide = 2;
                    this.potIconSide = 4;
                    break;
                }
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case BOTTOM: {
                this.potSide = -1;
                this.potTextSide = 2;
                this.potIconSide = 4;
            }
        }
    }

    public void PotPosYChanged(boolean top) {
        this.potVert = top ? 1 : -1;
    }

    void renderIcon(Potion pot, int xPos, int yPos, int size, float scale) {
        String path = pot.getRegistryName().func_110623_a();
        String domain = pot.getRegistryName().func_110624_b();
        ModWithPotions mwp = PotionUtils.getMWP(domain);
        if (mwp != null) {
            if (mwp.hasAtlas()) {
                int index = mwp.getIndex(path) != -1 ? mwp.getIndex(path) : pot.func_76392_e();
                this.mc.func_110434_K().func_110577_a(mwp.getRes());
                PotionRenderer.func_146110_a((int)xPos, (int)yPos, (float)((float)mwp.getXOffset() / scale + (float)(index % mwp.getColumns() * size)), (float)((float)mwp.getYOffset() / scale + (float)(index / mwp.getColumns() * size)), (int)size, (int)size, (float)((float)mwp.getXSize() / scale), (float)((float)mwp.getYSize() / scale));
            } else {
                this.mc.func_110434_K().func_110577_a(mwp.getPotionRes(path));
                Color4F color = mwp.getColor(path);
                if (color != null) {
                    GlStateManager.func_179131_c((float)color.r, (float)color.g, (float)color.b, (float)color.a);
                }
                PotionRenderer.func_146110_a((int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)size, (int)size, (float)size, (float)size);
            }
        } else {
            int index = pot.func_76392_e();
            this.mc.func_110434_K().func_110577_a(this.INVENTORY_BACKGROUND);
            PotionRenderer.func_146110_a((int)xPos, (int)yPos, (float)(index % 8 * size), (float)(198.0f / scale + (float)(index / 8 * size)), (int)size, (int)size, (float)(256.0f / scale), (float)(256.0f / scale));
        }
    }

    int setBarColor(int dur) {
        float r = 1.0f;
        float g = 1.0f;
        float f = (float)dur / (float)this.barDuration;
        int size = (int)(f * 12.0f) + 1;
        if (f < 0.5f) {
            g = f / 0.5f;
        } else {
            r = 1.0f - (f - 0.5f) / 0.5f;
        }
        GlStateManager.func_179131_c((float)r, (float)g, (float)0.0f, (float)1.0f);
        return size;
    }
}

