/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class HorizontalPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_hor.png");

    public HorizontalPotionRenderer(Minecraft mc) {
        super(mc);
    }

    private int getX(int width, int effCount) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - 18 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 18 - (effCount - 1) * (36 + this.potGap) - this.potX;
                    break;
                }
                result = (int)((float)(width / 2 - 18) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 18.0f) - (float)this.potX);
                break;
            }
            case RIGHT: {
                result = width - this.potX - (effCount - 1) * (this.potGap + 36);
            }
        }
        return result;
    }

    private int getY(int height) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                result = height / 2 - 18 - this.potY;
                break;
            }
            case BOTTOM: {
                result = height - this.potY;
            }
        }
        return result;
    }

    @Override
    public void render(int width, int height) {
        int x = 0;
        int effCount = this.mc.field_71439_g.func_70651_bq().size();
        if (effCount == 0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-255.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        int xPos = this.getX(width, effCount);
        int yPos = this.getY(height);
        for (PotionEffect effect : this.mc.field_71439_g.func_70651_bq()) {
            Potion pot = effect.func_188419_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
            this.mc.func_110434_K().func_110577_a(this.PBG);
            HorizontalPotionRenderer.func_146110_a((int)(xPos + x), (int)yPos, (float)0.0f, (float)0.0f, (int)36, (int)38, (float)36.0f, (float)38.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderIcon(pot, xPos + x + 9, yPos + 3, 18, 1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int lev = effect.func_76458_c();
            if (lev < 0 || lev > 8) {
                lev = 9;
            }
            this.mc.func_110434_K().func_110577_a(this.POTLEV[lev]);
            HorizontalPotionRenderer.func_146110_a((int)(xPos + x + 21), (int)yPos, (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
            String time = "";
            int dur = effect.func_76459_b() / 20;
            if (dur > 1600) {
                time = " **:**";
            } else {
                String mins = dur / 60 + "";
                String secs = dur % 60 + "";
                if (dur / 60 < 10) {
                    mins = "0" + mins;
                }
                if (dur % 60 < 10) {
                    secs = "0" + secs;
                }
                time = dur > 10 ? mins + ":" + secs : TextFormatting.RED + mins + TextFormatting.WHITE + ":" + TextFormatting.RED + secs;
            }
            this.fontRenderer.func_175063_a(time, (float)(xPos + x + 5), (float)(yPos + 25), 0xFFFFFF);
            x += 36 + this.potGap;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

