/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;

public class PotionConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton MiniModeBtn;
    private CustomButton HorModeBtn;
    private NumericTextField AlphaField;
    private NumericTextField GapField;
    private NumericTextField BarField;

    public PotionConfigScreen(boolean inGame) {
        super(2, inGame);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        InventoryHUD.getConfig();
        String toggle = InvConfig.pot.Potions ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, toggle, () -> this.ToggleSwitch(), null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        int n = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder = new StringBuilder();
        InventoryHUD.getConfig();
        this.MiniModeBtn = new CustomButton(n, 0, 40, 20, stringBuilder.append(InvConfig.pot.potMini).append("").toString(), () -> this.MiniModeSwitch(), null, false);
        this.OptionList.addWidget(this.MiniModeBtn, 2);
        int n2 = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder2 = new StringBuilder();
        InventoryHUD.getConfig();
        this.HorModeBtn = new CustomButton(n2, 0, 40, 20, stringBuilder2.append(InvConfig.pot.potHor).append("").toString(), null, false);
        this.OptionList.addWidget(this.HorModeBtn, 3);
        this.HorModeBtn.addListener(this::HorModeSwitch);
        int n3 = this.field_146294_l / 2 + 20;
        InventoryHUD.getConfig();
        this.AlphaField = new NumericTextField(0, this.field_146289_q, n3, 0, 40, 20, 0, 100, InvConfig.pot.potAlpha, tf -> this.AlphaChanged());
        this.OptionList.addWidget(this.AlphaField, 1);
        int n4 = this.field_146294_l / 2 + 20;
        InventoryHUD.getConfig();
        this.GapField = new NumericTextField(1, this.field_146289_q, n4, 0, 40, 20, -5, 5, InvConfig.pot.potGap, tf -> this.GapChanged());
        this.OptionList.addWidget(this.GapField, 4);
        int n5 = this.field_146294_l / 2 + 20;
        InventoryHUD.getConfig();
        this.BarField = new NumericTextField(2, this.field_146289_q, n5, 0, 40, 20, 1, Integer.MAX_VALUE, InvConfig.pot.barDuration, f -> this.BarChanged());
        this.OptionList.addWidget(this.BarField, 5);
        this.AlphaField.setMaxStringLength(5);
        this.GapField.setMaxStringLength(3);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_TOGGLE.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.POT_TOGGLE_TT.func_150261_e(), x, y)), 0);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_ALPHA.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.POT_ALPHA_TT.func_150261_e(), x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_MINI.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.POT_MINI_TT.func_150261_e(), x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_HOR.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.POT_HOR_TT.func_150261_e(), x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_GAP.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.POT_GAP_TT.func_150261_e(), x, y)), 4);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.BAR_DUR.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.BAR_DUR_TT.func_150261_e(), x, y)), 5);
    }

    private void HorModeSwitch() {
        InventoryHUD.getConfig();
        Boolean hor = !InvConfig.pot.potHor;
        InventoryHUD.getConfig();
        InvConfig.pot.potHor = hor;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
        InventoryHUD.getInstance().getInventoryGui().changePotionHor(hor);
        this.HorModeBtn.setMessage(hor.toString());
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
    }

    private void BarChanged() {
        int bar;
        try {
            bar = Integer.parseInt(this.BarField.getText());
        }
        catch (NumberFormatException ex) {
            bar = 300;
        }
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.barDuration = bar;
        InventoryHUD.getConfig();
        InvConfig.pot.barDuration = bar;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void AlphaChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AlphaField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.potAlpha = (float)a / 100.0f;
        InventoryHUD.getConfig();
        InvConfig.pot.potAlpha = a;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void GapChanged() {
        int a;
        try {
            a = Integer.parseInt(this.GapField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.potGap = a;
        InventoryHUD.getConfig();
        InvConfig.pot.potGap = a;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void ToggleSwitch() {
        boolean potion;
        InventoryHUD.getConfig();
        InventoryHUD.potionHUD = potion = !InvConfig.pot.Potions;
        InventoryHUD.getConfig();
        InvConfig.pot.Potions = potion;
        String toggle = potion ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn.setMessage(toggle);
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void MiniModeSwitch() {
        InventoryHUD.getConfig();
        Boolean mini = !InvConfig.pot.potMini;
        InventoryHUD.getConfig();
        InvConfig.pot.potMini = mini;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
        InventoryHUD.getInstance().getInventoryGui().changePotionMini(mini);
        this.MiniModeBtn.setMessage(mini.toString());
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
    }
}

