/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.stream.Collectors;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;

public class InventoryConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton MiniModeBtn;
    private CustomButton VerticalModeBtn;
    private CustomButton AnimatedBtn;
    private CustomButton HideBGBtn;
    private NumericTextField AlphaField;

    public InventoryConfigScreen(boolean inGame) {
        super(0, inGame);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        InventoryHUD.getConfig();
        String toggle = InvConfig.inv.byDefault ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, toggle, () -> this.ToggleSwitch(), null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        int n = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder = new StringBuilder();
        InventoryHUD.getConfig();
        this.MiniModeBtn = new CustomButton(n, 0, 40, 20, stringBuilder.append(InvConfig.inv.invMini).append("").toString(), () -> this.MiniModeSwitch(), null, false);
        this.OptionList.addWidget(this.MiniModeBtn, 2);
        int n2 = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder2 = new StringBuilder();
        InventoryHUD.getConfig();
        this.VerticalModeBtn = new CustomButton(n2, 0, 40, 20, stringBuilder2.append(InvConfig.inv.invVertical).append("").toString(), () -> this.VerticalModeSwitch(), null, false);
        this.OptionList.addWidget(this.VerticalModeBtn, 1);
        int n3 = this.field_146294_l / 2 + 20;
        InventoryHUD.getConfig();
        this.AlphaField = new NumericTextField(0, this.field_146289_q, n3, 0, 40, 20, 0, 100, InvConfig.inv.invAlpha, tf -> this.AlphaChanged());
        this.OptionList.addWidget(this.AlphaField, 3);
        int n4 = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder3 = new StringBuilder();
        InventoryHUD.getConfig();
        this.AnimatedBtn = new CustomButton(n4, 0, 40, 20, stringBuilder3.append(InvConfig.inv.invAnim).append("").toString(), null, false);
        this.OptionList.addWidget(this.AnimatedBtn, 4);
        int n5 = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder4 = new StringBuilder();
        InventoryHUD.getConfig();
        this.HideBGBtn = new CustomButton(n5, 0, 40, 20, stringBuilder4.append(InvConfig.inv.invHideBG).append("").toString(), null, false);
        this.OptionList.addWidget(this.HideBGBtn, 5);
        this.AnimatedBtn.addListener(this::AnimatedChanged);
        this.HideBGBtn.addListener(this::HideBGChanged);
        this.AlphaField.setMaxStringLength(5);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_HIDEBG.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.INV_HIDEBG_TT.func_150261_e(), x, y)), 5);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_ANIMATED.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.INV_ANIMATED_TT.func_150261_e(), x, y)), 4);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_ALPHA.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.INV_ALPHA_TT.func_150261_e(), x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_MINI.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.INV_MINI_TT.func_150261_e(), x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_VERT.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146283_a(Translation.INV_VERT_TT.stream().map(TextComponentTranslation::func_150261_e).collect(Collectors.toList()), x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_TOGGLE.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.INV_TOGGLE_TT.func_150261_e(), x, y)), 0);
    }

    private void AnimatedChanged() {
        InventoryHUD.getConfig();
        Boolean mm = !InvConfig.inv.invAnim;
        InventoryGui.animated = mm;
        InventoryHUD.getConfig();
        InvConfig.inv.invAnim = mm;
        this.AnimatedBtn.setMessage(mm.toString());
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void HideBGChanged() {
        InventoryHUD.getConfig();
        Boolean mm = !InvConfig.inv.invHideBG;
        InventoryGui.hideBackground = mm;
        InventoryHUD.getConfig();
        InvConfig.inv.invHideBG = mm;
        this.HideBGBtn.setMessage(mm.toString());
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void AlphaChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AlphaField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryGui.invAlpha = (float)a / 100.0f;
        InventoryHUD.getConfig();
        InvConfig.inv.invAlpha = a;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void MiniModeSwitch() {
        boolean mm;
        InventoryHUD.getConfig();
        InventoryGui.invMini = mm = !InvConfig.inv.invMini;
        InventoryHUD.getConfig();
        InvConfig.inv.invMini = mm;
        this.MiniModeBtn.setMessage(Boolean.toString(mm));
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void VerticalModeSwitch() {
        boolean vm;
        InventoryHUD.getConfig();
        InventoryGui.invVert = vm = !InvConfig.inv.invVertical;
        InventoryHUD.getConfig();
        InvConfig.inv.invVertical = vm;
        this.VerticalModeBtn.setMessage(Boolean.toString(vm));
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void ToggleSwitch() {
        boolean bd;
        InventoryHUD.getConfig();
        InventoryHUD.isActive = bd = !InvConfig.inv.byDefault;
        InventoryHUD.getConfig();
        InvConfig.inv.byDefault = bd;
        String toggle = bd ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn.setMessage(toggle);
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }
}

