/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import dlovin.inventoryhud.gui.renderers.BaubleRenderer;
import dlovin.inventoryhud.gui.renderers.BlockArmorRenderer;
import dlovin.inventoryhud.gui.renderers.EachArmorRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HotBarArmorRenderer;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalPotionRenderer;
import dlovin.inventoryhud.utils.BaubleItem;
import dlovin.inventoryhud.utils.BaubleSaveUtils;
import dlovin.inventoryhud.utils.BaubleSlots;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="inventoryhud")
public class InventoryGui
extends GuiIngame {
    private final RenderItem itemRenderer;
    private final FontRenderer fontRenderer;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    public static int invX;
    public static int invY;
    public static WidgetAligns InvAligns;
    public static float invAlpha;
    public static boolean invMini;
    public static boolean invVert;
    public static boolean animated;
    public static boolean hideBackground;
    private static final ResourceLocation INVBG;
    public ArmorRenderer armorRenderer;
    public PotionRenderer potionRenderer;
    public BaubleRenderer baubleRenderer;
    public HashMap<BaubleSlots, BaubleItem> baubles;

    public InventoryGui() {
        super(Minecraft.func_71410_x());
        this.itemRenderer = this.minecraft.func_175599_af();
        this.fontRenderer = this.minecraft.field_71466_p;
        if (InventoryHUD.isBaublesMod) {
            this.baubles = new HashMap();
            BaubleSaveUtils.loadFromFile(this);
        }
        this.syncConfig();
    }

    public void syncConfig() {
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign = InvConfig.set.armHalign;
        InventoryHUD.getConfig();
        WidgetAligns ArmAligns = new WidgetAligns(hAlign, InvConfig.set.armValign);
        InventoryHUD.getConfig();
        int armX = InvConfig.set.xArmPos;
        InventoryHUD.getConfig();
        int armY = InvConfig.set.yArmPos;
        InventoryHUD.getConfig();
        this.armorRenderer = !InvConfig.arm.moveAll ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        if (InventoryHUD.isBaublesMod) {
            this.baubleRenderer = new BaubleRenderer(this.minecraft);
        }
        this.setupArmorRenderer();
        InventoryHUD.getConfig();
        if (InvConfig.pot.potHor) {
            InventoryHUD.getConfig();
            this.potionRenderer = InvConfig.pot.potMini ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft);
        } else {
            InventoryHUD.getConfig();
            this.potionRenderer = InvConfig.pot.potMini ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft);
        }
        this.setupPotionRenderer();
        InventoryHUD.getConfig();
        InventoryHUD.isActive = InvConfig.inv.byDefault;
        InventoryHUD.getConfig();
        InventoryHUD.armorHUD = InvConfig.arm.ArmorDamage;
        InventoryHUD.getConfig();
        InventoryHUD.potionHUD = InvConfig.pot.Potions;
        InventoryHUD.getConfig();
        invX = InvConfig.set.xInvPos;
        InventoryHUD.getConfig();
        invY = InvConfig.set.yInvPos;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign2 = InvConfig.set.invHalign;
        InventoryHUD.getConfig();
        InvAligns = new WidgetAligns(hAlign2, InvConfig.set.invValign);
        InventoryHUD.getConfig();
        invMini = InvConfig.inv.invMini;
        InventoryHUD.getConfig();
        invVert = InvConfig.inv.invVertical;
        InventoryHUD.getConfig();
        animated = InvConfig.inv.invAnim;
        InventoryHUD.getConfig();
        hideBackground = InvConfig.inv.invHideBG;
        InventoryHUD.getConfig();
        invAlpha = (float)InvConfig.inv.invAlpha / 100.0f;
    }

    private void setupPotionRenderer() {
        ScaledResolution scaled = new ScaledResolution(this.minecraft);
        int height = scaled.func_78328_b();
        InventoryHUD.getConfig();
        this.potionRenderer.potX = InvConfig.set.xPotionPos;
        InventoryHUD.getConfig();
        this.potionRenderer.potY = InvConfig.set.yPotionPos;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign = InvConfig.set.PotHalign;
        InventoryHUD.getConfig();
        this.potionRenderer.PotAligns = new WidgetAligns(hAlign, InvConfig.set.PotValign);
        InventoryHUD.getConfig();
        this.potionRenderer.potMini = InvConfig.pot.potMini;
        InventoryHUD.getConfig();
        this.potionRenderer.potGap = InvConfig.pot.potGap;
        InventoryHUD.getConfig();
        this.potionRenderer.barDuration = InvConfig.pot.barDuration;
        this.potionRenderer.PotPosChanged();
        switch (this.potionRenderer.PotAligns.VertAlign) {
            case TOP: {
                this.potionRenderer.potVert = 1;
                break;
            }
            case CENTER: {
                if (this.potionRenderer.potY - 12 < height / 2) {
                    this.potionRenderer.potVert = -1;
                    break;
                }
                this.potionRenderer.potVert = 1;
                break;
            }
            case BOTTOM: {
                this.potionRenderer.potVert = -1;
            }
        }
        InventoryHUD.getConfig();
        this.potionRenderer.potAlpha = (float)InvConfig.pot.potAlpha / 100.0f;
    }

    private void setupArmorRenderer() {
        InventoryHUD.getConfig();
        this.armorRenderer.armX = InvConfig.set.xArmPos;
        InventoryHUD.getConfig();
        this.armorRenderer.armY = InvConfig.set.yArmPos;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign = InvConfig.set.armHalign;
        InventoryHUD.getConfig();
        this.armorRenderer.ArmAligns = new WidgetAligns(hAlign, InvConfig.set.armValign);
        InventoryHUD.getConfig();
        this.armorRenderer.armAbove = InvConfig.arm.armAbove;
        InventoryHUD.getConfig();
        this.armorRenderer.armScale = InvConfig.arm.armScale;
        InventoryHUD.getConfig();
        this.armorRenderer.showArmor = InvConfig.arm.showArmor;
        InventoryHUD.getConfig();
        this.armorRenderer.showMain = InvConfig.arm.showMain;
        InventoryHUD.getConfig();
        this.armorRenderer.showOff = InvConfig.arm.showOff;
        InventoryHUD.getConfig();
        this.armorRenderer.showArrows = InvConfig.arm.showArrows;
        InventoryHUD.getConfig();
        this.armorRenderer.showInv = InvConfig.arm.showInv;
        InventoryHUD.getConfig();
        this.armorRenderer.showEmpty = InvConfig.arm.showEmpty;
        InventoryHUD.getConfig();
        this.armorRenderer.showCount = InvConfig.arm.showCount;
        InventoryHUD.getConfig();
        this.armorRenderer.armView = InvConfig.arm.armView;
        InventoryHUD.getConfig();
        this.armorRenderer.armBars = InvConfig.arm.armBars;
        if (InventoryHUD.isBaublesMod) {
            this.baubleRenderer.armAbove = this.armorRenderer.armAbove;
            this.baubleRenderer.armScale = this.armorRenderer.armScale;
            this.baubleRenderer.showEmpty = this.armorRenderer.showEmpty;
            this.baubleRenderer.showCount = this.armorRenderer.showCount;
            this.baubleRenderer.armView = this.armorRenderer.armView;
            this.baubleRenderer.armBars = this.armorRenderer.armBars;
        }
        EachItem[] eachItemArray = this.armorRenderer.items;
        InventoryHUD.getConfig();
        int n = InvConfig.set.helmPosX;
        InventoryHUD.getConfig();
        int n2 = InvConfig.set.helmPosY;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign2 = InvConfig.set.helmHal;
        InventoryHUD.getConfig();
        eachItemArray[0] = new EachItem(n, n2, new WidgetAligns(hAlign2, InvConfig.set.helmVal));
        EachItem[] eachItemArray2 = this.armorRenderer.items;
        InventoryHUD.getConfig();
        int n3 = InvConfig.set.chestPosX;
        InventoryHUD.getConfig();
        int n4 = InvConfig.set.chestPosY;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign3 = InvConfig.set.chestHal;
        InventoryHUD.getConfig();
        eachItemArray2[1] = new EachItem(n3, n4, new WidgetAligns(hAlign3, InvConfig.set.chestVal));
        EachItem[] eachItemArray3 = this.armorRenderer.items;
        InventoryHUD.getConfig();
        int n5 = InvConfig.set.legPosX;
        InventoryHUD.getConfig();
        int n6 = InvConfig.set.legPosY;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign4 = InvConfig.set.legHal;
        InventoryHUD.getConfig();
        eachItemArray3[2] = new EachItem(n5, n6, new WidgetAligns(hAlign4, InvConfig.set.legVal));
        EachItem[] eachItemArray4 = this.armorRenderer.items;
        InventoryHUD.getConfig();
        int n7 = InvConfig.set.bootPosX;
        InventoryHUD.getConfig();
        int n8 = InvConfig.set.bootPosY;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign5 = InvConfig.set.bootHal;
        InventoryHUD.getConfig();
        eachItemArray4[3] = new EachItem(n7, n8, new WidgetAligns(hAlign5, InvConfig.set.bootVal));
        EachItem[] eachItemArray5 = this.armorRenderer.items;
        InventoryHUD.getConfig();
        int n9 = InvConfig.set.offPosX;
        InventoryHUD.getConfig();
        int n10 = InvConfig.set.offPosY;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign6 = InvConfig.set.offHal;
        InventoryHUD.getConfig();
        eachItemArray5[4] = new EachItem(n9, n10, new WidgetAligns(hAlign6, InvConfig.set.offVal));
        EachItem[] eachItemArray6 = this.armorRenderer.items;
        InventoryHUD.getConfig();
        int n11 = InvConfig.set.mainPosX;
        InventoryHUD.getConfig();
        int n12 = InvConfig.set.mainPosY;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign7 = InvConfig.set.mainHal;
        InventoryHUD.getConfig();
        eachItemArray6[5] = new EachItem(n11, n12, new WidgetAligns(hAlign7, InvConfig.set.mainVal));
        EachItem[] eachItemArray7 = this.armorRenderer.items;
        InventoryHUD.getConfig();
        int n13 = InvConfig.set.invPosX;
        InventoryHUD.getConfig();
        int n14 = InvConfig.set.invPosY;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign8 = InvConfig.set.invHal;
        InventoryHUD.getConfig();
        eachItemArray7[6] = new EachItem(n13, n14, new WidgetAligns(hAlign8, InvConfig.set.invVal));
        EachItem[] eachItemArray8 = this.armorRenderer.items;
        InventoryHUD.getConfig();
        int n15 = InvConfig.set.arrPosX;
        InventoryHUD.getConfig();
        int n16 = InvConfig.set.arrPosY;
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign9 = InvConfig.set.arrHal;
        InventoryHUD.getConfig();
        eachItemArray8[7] = new EachItem(n15, n16, new WidgetAligns(hAlign9, InvConfig.set.arrVal));
        this.changeArmorOffset();
    }

    @SubscribeEvent
    public void onPreRenderGui(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && InventoryHUD.potionHUD) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        GuiIngameForge.renderExperiance = true;
        ScaledResolution scaled = new ScaledResolution(this.minecraft);
        int width = scaled.func_78326_a();
        int height = scaled.func_78328_b();
        GlStateManager.func_179094_E();
        if (InventoryHUD.armorHUD) {
            this.armorRenderer.render(width, height);
            if (InventoryHUD.isBaublesMod) {
                this.baubleRenderer.render(width, height);
            }
        }
        if (InventoryHUD.potionHUD) {
            this.potionRenderer.render(width, height);
        }
        if (InventoryHUD.isActive && this.field_73839_d.field_71462_r == null) {
            this.RenderInventory(width, height, event.getPartialTicks());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void RenderInventory(int width, int height, float partialTicks) {
        int iMax = invVert ? 3 : 9;
        int jMax = invVert ? 9 : 3;
        double scale = invMini ? 0.75 : 1.0;
        int px = this.getX(width, (int)((double)(iMax * 18 - 2) * scale), invX, InventoryGui.InvAligns.HorAlign);
        int py = this.getY(height, (int)((double)(jMax * 18 - 2) * scale), invY, InventoryGui.InvAligns.VertAlign);
        ArrayList<Runnable> items = new ArrayList<Runnable>();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                ItemStack item = (ItemStack)this.field_73839_d.field_71439_g.field_71071_by.field_70462_a.get(index);
                if (item == null || item.func_77973_b().equals(Items.field_190931_a)) continue;
                int finalI = i;
                int finalJ = j;
                items.add(() -> {
                    float f = (float)item.func_190921_D() - partialTicks;
                    if (animated && f > 0.0f) {
                        GlStateManager.func_179094_E();
                        float f1 = 1.0f + f / 5.0f;
                        GlStateManager.func_179109_b((float)(finalI * 18 + 12), (float)(finalJ * 18 + 12), (float)0.0f);
                        GlStateManager.func_179152_a((float)((f1 + 1.0f) / 2.0f), (float)((f1 + 1.0f) / 2.0f), (float)1.0f);
                        GlStateManager.func_179109_b((float)(-(finalI * 18 + 12)), (float)(-(finalJ * 18 + 12)), (float)0.0f);
                    }
                    this.itemRenderer.func_180450_b(item, finalI * 18, finalJ * 18);
                    if (animated && f > 0.0f) {
                        GlStateManager.func_179121_F();
                    }
                    this.itemRenderer.func_180453_a(this.fontRenderer, item, finalI * 18, finalJ * 18, null);
                });
            }
        }
        if (hideBackground && items.size() == 0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)px, (float)py, (float)-255.0f);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)invAlpha);
        this.field_73839_d.func_110434_K().func_110577_a(INVBG);
        InventoryGui.func_146110_a((int)-8, (int)-8, (float)0.0f, (float)(jMax == 3 ? 0.0f : 68.0f), (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (float)256.0f, (float)256.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        items.forEach(Runnable::run);
        RenderHelper.func_74518_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private int getX(int width, int itemWidth, int x, WidgetAligns.HAlign hal) {
        int result = 0;
        switch (hal) {
            case LEFT: {
                result = x;
                break;
            }
            case MIDDLE: {
                result = width / 2 - itemWidth / 2 - x;
                break;
            }
            case RIGHT: {
                result = width - x;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > width - itemWidth) {
            result = width - itemWidth;
        }
        return result;
    }

    private int getY(int height, int itemHeight, int y, WidgetAligns.VAlign val) {
        int result = 0;
        switch (val) {
            case TOP: {
                result = y;
                break;
            }
            case CENTER: {
                result = height / 2 - itemHeight / 2 - y;
                break;
            }
            case BOTTOM: {
                result = height - y;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > height - itemHeight) {
            result = height - itemHeight;
        }
        return result;
    }

    public void changeArmorPos(WidgetAligns armal, int ax, int ay) {
        float scale = (float)this.armorRenderer.armScale / 100.0f;
        if (armal.HorAlign == WidgetAligns.HAlign.MIDDLE && armal.VertAlign == WidgetAligns.VAlign.BOTTOM && (float)ay <= 70.0f * scale + 5.0f && Math.abs(ax) <= 90) {
            if (!(this.armorRenderer instanceof HotBarArmorRenderer)) {
                this.armorRenderer = new HotBarArmorRenderer(this.minecraft);
                this.setupArmorRenderer();
            }
        } else if (this.armorRenderer instanceof HotBarArmorRenderer) {
            this.armorRenderer = new BlockArmorRenderer(this.minecraft);
            this.setupArmorRenderer();
        }
        this.armorRenderer.ArmAligns = armal;
        this.armorRenderer.armY = ay;
        this.armorRenderer.armX = ax;
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeArmorOffset() {
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeMoveAll(Boolean bd) {
        InventoryHUD.getConfig();
        WidgetAligns.HAlign hAlign = InvConfig.set.armHalign;
        InventoryHUD.getConfig();
        WidgetAligns ArmAligns = new WidgetAligns(hAlign, InvConfig.set.armValign);
        InventoryHUD.getConfig();
        int armX = InvConfig.set.xArmPos;
        InventoryHUD.getConfig();
        int armY = InvConfig.set.yArmPos;
        this.armorRenderer = bd == false ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        this.setupArmorRenderer();
    }

    public void changePotionMini(boolean mini) {
        InventoryHUD.getConfig();
        this.changePotion(mini, InvConfig.pot.potHor);
        this.setupPotionRenderer();
    }

    public void changePotionHor(boolean hor) {
        InventoryHUD.getConfig();
        this.changePotion(InvConfig.pot.potMini, hor);
    }

    private void changePotion(boolean mini, boolean hor) {
        this.potionRenderer = hor ? (mini ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft)) : (mini ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft));
        this.setupPotionRenderer();
    }

    static {
        INVBG = new ResourceLocation("inventoryhud", "textures/gui/inv_bg.png");
    }
}

