/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.Config;
import com.denfop.IUItem;
import com.denfop.blocks.FluidName;
import com.denfop.world.WorldGenGas;
import com.denfop.world.WorldGenOil;
import com.denfop.world.WorldGenRubTree;
import com.denfop.world.vein.AlgorithmVein;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.TypeVein;
import com.denfop.world.vein.VeinType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class WorldGenOres
implements IWorldGenerator {
    final Fluid fluid = FluidName.fluidneft.getInstance();
    public static List<ChunkPos> chunkPosList = new ArrayList<ChunkPos>();
    public static List<VeinType> veinTypes = new ArrayList<VeinType>();
    public static List<VeinType> veinTypes1 = new ArrayList<VeinType>();
    final Block block = this.fluid.getBlock();
    public static Random random = new Random();

    public static void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOres(), (int)0);
    }

    public static void initVein() {
        veinTypes.add(new VeinType(IUItem.heavyore, 0, TypeVein.SMALL, new ChanceOre(Blocks.field_150366_p.func_176223_P(), 75, 0), new ChanceOre(Blocks.field_150352_o.func_176223_P(), 25, 0)));
        veinTypes.add(new VeinType(IUItem.heavyore, 1, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(7), 28, 7), new ChanceOre(Blocks.field_150352_o.func_176223_P(), 44, 0), new ChanceOre(IUItem.classic_ore.func_176203_a(0), 28, 0)));
        veinTypes.add(new VeinType(IUItem.heavyore, 2, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(11), 26, 11), new ChanceOre(IUItem.classic_ore.func_176203_a(2), 74, 2)));
        veinTypes.add(new VeinType(IUItem.heavyore, 3, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(8), 44, 8), new ChanceOre(IUItem.ore.func_176203_a(6), 56, 6)));
        veinTypes.add(new VeinType(IUItem.heavyore, 4, TypeVein.SMALL, new ChanceOre(Blocks.field_150366_p.func_176223_P(), 80, 0), new ChanceOre(IUItem.ore.func_176203_a(4), 20, 4)));
        veinTypes.add(new VeinType(IUItem.heavyore, 5, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(12), 16, 12), new ChanceOre(IUItem.ore.func_176203_a(11), 26, 11), new ChanceOre(IUItem.classic_ore.func_176203_a(1), 24, 1), new ChanceOre(IUItem.ore.func_176203_a(10), 34, 10)));
        veinTypes.add(new VeinType(IUItem.heavyore, 6, TypeVein.SMALL, new ChanceOre(IUItem.classic_ore.func_176203_a(3), 60, 3), new ChanceOre(IUItem.toriyore.func_176223_P(), 32, 0), new ChanceOre(IUItem.radiationore.func_176203_a(1), 4, 1), new ChanceOre(IUItem.radiationore.func_176203_a(0), 3, 0), new ChanceOre(IUItem.radiationore.func_176203_a(2), 1, 2)));
        veinTypes.add(new VeinType(IUItem.heavyore, 7, TypeVein.SMALL, new ChanceOre(IUItem.classic_ore.func_176203_a(0), 55, 0), new ChanceOre(Blocks.field_150369_x.func_176223_P(), 23, 0), new ChanceOre(Blocks.field_150450_ax.func_176223_P(), 21, 0)));
        veinTypes.add(new VeinType(IUItem.heavyore, 8, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(13), 44, 13), new ChanceOre(IUItem.ore.func_176203_a(5), 28, 5), new ChanceOre(IUItem.ore.func_176203_a(0), 28, 0)));
        veinTypes.add(new VeinType(IUItem.heavyore, 9, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(4), 50, 4), new ChanceOre(IUItem.ore.func_176203_a(6), 50, 6)));
        veinTypes.add(new VeinType(IUItem.heavyore, 10, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(8), 50, 8), new ChanceOre(IUItem.classic_ore.func_176203_a(3), 25, 3), new ChanceOre(IUItem.toriyore.func_176223_P(), 25, 0)));
        veinTypes.add(new VeinType(IUItem.heavyore, 11, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(12), 65, 12), new ChanceOre(Blocks.field_150365_q.func_176223_P(), 35, 0)));
        veinTypes.add(new VeinType(IUItem.heavyore, 12, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(8), 47, 8), new ChanceOre(Blocks.field_150366_p.func_176223_P(), 33, 0), new ChanceOre(IUItem.ore.func_176203_a(2), 33, 2)));
        veinTypes.add(new VeinType(IUItem.heavyore, 13, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(13), 66, 13), new ChanceOre(IUItem.ore.func_176203_a(5), 17, 5), new ChanceOre(IUItem.ore.func_176203_a(1), 17, 1)));
        veinTypes.add(new VeinType(IUItem.heavyore, 14, TypeVein.SMALL, new ChanceOre(Blocks.field_150366_p.func_176223_P(), 30, 0), new ChanceOre(IUItem.ore.func_176203_a(5), 40, 5), new ChanceOre(IUItem.ore.func_176203_a(1), 30, 1)));
        veinTypes.add(new VeinType(IUItem.heavyore, 15, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(3), 80, 3), new ChanceOre(IUItem.classic_ore.func_176203_a(1), 20, 1)));
        veinTypes.add(new VeinType(null, 16, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(14), 70, 14), new ChanceOre(IUItem.ore.func_176203_a(7), 30, 7)));
        veinTypes.add(new VeinType(null, 17, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(15), 60, 15), new ChanceOre(IUItem.ore.func_176203_a(1), 40, 1)));
        veinTypes.add(new VeinType(null, 18, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(2), 50, 2), new ChanceOre(IUItem.ore.func_176203_a(9), 50, 9)));
        veinTypes.add(new VeinType(null, 19, TypeVein.SMALL, new ChanceOre(IUItem.ore2.func_176203_a(3), 65, 3), new ChanceOre(IUItem.ore.func_176203_a(14), 35, 14)));
        veinTypes.add(new VeinType(null, 20, TypeVein.SMALL, new ChanceOre(IUItem.ore2.func_176203_a(4), 70, 4), new ChanceOre(IUItem.ore.func_176203_a(13), 20, 13), new ChanceOre(Blocks.field_150366_p.func_176223_P(), 10, 0)));
        veinTypes.add(new VeinType(null, 21, TypeVein.SMALL, new ChanceOre(IUItem.ore2.func_176203_a(5), 70, 5), new ChanceOre(IUItem.ore.func_176203_a(4), 30, 4)));
    }

    private static int randomX(Chunk chunk, Random rnd) {
        return chunk.field_76635_g * 16 + rnd.nextInt(16);
    }

    private static int randomZ(Chunk chunk, Random rnd) {
        return chunk.field_76647_h * 16 + rnd.nextInt(16);
    }

    private static void genRubberTree(Chunk chunk, float baseScale) {
        int i;
        int rubberTrees;
        Biome[] biomes = new Biome[6];
        for (rubberTrees = 0; rubberTrees < 5; ++rubberTrees) {
            int x = chunk.field_76635_g * 16 + 8 + (rubberTrees & 2) * 15;
            i = chunk.field_76647_h * 16 + 8 + ((rubberTrees & 2) >>> 1) * 15;
            BlockPos pos = new BlockPos(x, chunk.func_177412_p().func_181545_F(), i);
            biomes[rubberTrees] = chunk.func_177412_p().func_72959_q().func_180300_a(pos, Biomes.field_76772_c);
        }
        rubberTrees = 0;
        for (Biome biome : biomes) {
            if (biome == null) continue;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                rubberTrees += random.nextInt(10) + 5;
            }
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) continue;
            rubberTrees += random.nextInt(5) + 1;
        }
        rubberTrees = Math.round((float)rubberTrees * baseScale);
        if ((rubberTrees /= 2) > 0 && random.nextInt(100) < rubberTrees) {
            WorldGenRubTree gen = new WorldGenRubTree(false);
            for (i = 0; i < rubberTrees; ++i) {
                if (gen.func_180709_b(chunk.func_177412_p(), random, new BlockPos(WorldGenOres.randomX(chunk, random), chunk.func_177412_p().func_181545_F(), WorldGenOres.randomZ(chunk, random)))) continue;
                rubberTrees -= 3;
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (Config.DimensionList.contains(world.field_73011_w.getDimension())) {
            int var5;
            int var4;
            int var3;
            if (random.nextInt(100) + 1 > 70 && world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16)) == Biome.func_150568_d((int)2)) {
                for (int var2 = 0; var2 < 1; ++var2) {
                    var3 = chunkX * 16 + random.nextInt(16) + 8;
                    var4 = random.nextInt(random.nextInt(random.nextInt(112) + 8) + 8) + 60;
                    var5 = chunkZ * 16 + random.nextInt(16) + 8;
                    if (this.block == null) continue;
                    new WorldGenOil(this.block).func_180709_b(world, random, new BlockPos(var3, var4, var5));
                }
            }
            if (WorldGenOres.random.nextInt(900) + 1 > 700) {
                var3 = chunkX * 16 + random.nextInt(16) + 8;
                var4 = random.nextInt(random.nextInt(random.nextInt(30) + 20) + 8);
                var5 = chunkZ * 16 + random.nextInt(16) + 8;
                new WorldGenGas().func_180709_b(world, random, new BlockPos(var3, var4, var5));
            }
            Chunk chunk = chunkProvider.func_186025_d(chunkX, chunkZ);
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16, chunkGenerator, chunkProvider, chunk);
            WorldGenOres.genRubberTree(chunk, 2.0f);
        }
    }

    private void generateSurface(World world, Random random, int x, int y, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, Chunk chunk) {
        if (Config.RubyOre) {
            this.addOreSpawn(IUItem.preciousore.func_176203_a(0), world, random, x, y, 16, 16, 3 + random.nextInt(2), 8, 10, 70);
        }
        if (Config.SapphireOre) {
            this.addOreSpawn(IUItem.preciousore.func_176203_a(1), world, random, x, y, 16, 16, 3 + random.nextInt(2), 8, 10, 70);
        }
        if (Config.TopazOre) {
            this.addOreSpawn(IUItem.preciousore.func_176203_a(2), world, random, x, y, 16, 16, 3 + random.nextInt(2), 8, 10, 70);
        }
        WorldGenOres.random.setSeed(WorldGenOres.random.nextLong());
        if (WorldGenOres.random.nextInt(4) <= 2) {
            if (veinTypes1.isEmpty()) {
                veinTypes1 = new ArrayList<VeinType>(veinTypes);
            }
            int meta = WorldGenOres.random.nextInt(veinTypes1.size());
            VeinType veinType = veinTypes1.remove(meta);
            AlgorithmVein.generate(world, veinType, new BlockPos(x + random.nextInt(16), 2, y + random.nextInt(16)), chunk, veinType.getMeta());
        }
    }

    public void addOreSpawn(IBlockState block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, maxVeinSize).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

