/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.Localization;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class Timer {
    boolean canWork = true;
    private int hour;
    private int minute;
    private int seconds;

    public Timer(int hour, int minute, int seconds) {
        this.hour = hour;
        this.minute = minute;
        this.seconds = seconds;
    }

    public void readBuffer(CustomPacketBuffer is) throws IOException {
        this.hour = is.readInt();
        this.minute = is.readInt();
        this.seconds = is.readInt();
        this.canWork = is.readBoolean();
    }

    public void writeBuffer(CustomPacketBuffer buffer) {
        buffer.writeInt(this.hour);
        buffer.writeInt(this.minute);
        buffer.writeInt(this.seconds);
        buffer.writeBoolean(this.canWork);
    }

    public NBTTagCompound writeNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("hour", this.hour);
        tagCompound.func_74768_a("minute", this.minute);
        tagCompound.func_74768_a("seconds", this.seconds);
        tagCompound.func_74757_a("canWork", this.canWork);
        return tagCompound;
    }

    public String getDisplay() {
        return this.hour + Localization.translate("iu.hour") + this.minute + Localization.translate("iu.minutes") + this.seconds + Localization.translate("iu.seconds");
    }

    public int getBar() {
        return this.hour * 3600 + this.minute * 60 + this.seconds;
    }

    public int getTime() {
        return this.seconds + this.minute * 60 + this.hour * 3600;
    }

    public void work() {
        if (this.seconds != 0) {
            --this.seconds;
        } else if (this.minute != 0) {
            this.seconds = 59;
            --this.minute;
        } else if (this.hour != 0) {
            --this.hour;
            this.minute = 59;
            this.seconds = 59;
        } else {
            this.canWork = false;
        }
    }

    public void rework() {
        ++this.seconds;
        if (this.seconds == 60) {
            this.seconds = 0;
            ++this.minute;
            if (this.minute == 60) {
                this.minute = 0;
                ++this.hour;
            }
        }
    }

    public boolean canWork() {
        return this.canWork;
    }

    public void setCanWork(boolean canWork) {
        this.canWork = canWork;
    }

    public void readNBT(NBTTagCompound tagCompound) {
        this.hour = tagCompound.func_74762_e("hour");
        this.minute = tagCompound.func_74762_e("minute");
        this.seconds = tagCompound.func_74762_e("seconds");
        this.canWork = tagCompound.func_74767_n("canWork");
    }

    public void readTimer(Timer timer) {
        this.hour = timer.hour;
        this.seconds = timer.seconds;
        this.minute = timer.minute;
        this.canWork = timer.canWork;
    }

    public Timer cloning() {
        Timer timer = new Timer(this.hour, this.minute, this.seconds);
        timer.canWork = this.canWork;
        return timer;
    }

    public boolean getMinute(int minute) {
        return this.minute == minute;
    }
}

