/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.transport.ITransportAcceptor;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.api.transport.TransportNetGlobal;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.state.TileEntityBlockStateContainer;
import com.denfop.blocks.state.UnlistedProperty;
import com.denfop.componets.AbstractComponent;
import com.denfop.container.ContainerCable;
import com.denfop.gui.GuiCable;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketCableSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.transport.DataCable;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.transport.tiles.RenderState;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityMultiCable
extends TileEntityInventory
implements IUpdatableTileEvent {
    private final ICableItem cableItem;
    public byte connectivity;
    private ResourceLocation texture;
    private List<EnumFacing> blackList = new ArrayList<EnumFacing>();
    public ItemStack stackFacade = ItemStack.field_190927_a;
    public static final IUnlistedProperty<RenderState> renderStateProperty = new UnlistedProperty<RenderState>("renderstate", RenderState.class);
    @SideOnly(value=Side.CLIENT)
    public DataCable dataCable;
    private RenderState renderState;

    public TileEntityMultiCable(ICableItem name) {
        this.cableItem = name;
        this.connectivity = 0;
    }

    public List<EnumFacing> getBlackList() {
        return this.blackList;
    }

    public ICableItem getCableItem() {
        return this.cableItem;
    }

    public ResourceLocation getTexture() {
        if (this.texture == null) {
            this.texture = new ResourceLocation("industrialupgrade", "blocks/wiring/" + this.getCableItem().getMainPath() + "/" + this.getCableItem().getNameCable());
        }
        return this.texture;
    }

    public void removeConductor() {
        this.func_145831_w().func_175698_g(this.field_174879_c);
        new PacketCableSound(this.func_145831_w(), this.field_174879_c, 0.5, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        NBTTagCompound nbt1 = new NBTTagCompound();
        if (!this.blackList.isEmpty()) {
            nbt1.func_74768_a("size", this.blackList.size());
            for (int i = 0; i < this.blackList.size(); ++i) {
                nbt1.func_74768_a(String.valueOf(i), this.blackList.get(i).ordinal());
            }
            nbt.func_74782_a("list", (NBTBase)nbt1);
        }
        if (this.stackFacade != null && !this.stackFacade.func_190926_b()) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            this.stackFacade.func_77955_b(nbt2);
            nbt.func_74782_a("stackFacade", (NBTBase)nbt2);
        }
        return nbt;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return false;
        }
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        if (this.capabilityComponents == null) {
            return false;
        }
        AbstractComponent comp = (AbstractComponent)this.capabilityComponents.get(capability);
        return comp != null && comp.getProvidedCapabilities(facing).contains(capability);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("list")) {
            NBTTagCompound tagList = nbtTagCompound.func_74775_l("list");
            int size = tagList.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                this.blackList.add(EnumFacing.values()[tagList.func_74762_e(String.valueOf(i))]);
            }
        }
        if (nbtTagCompound.func_74764_b("stackFacade")) {
            NBTTagCompound stackFacade = nbtTagCompound.func_74775_l("stackFacade");
            this.stackFacade = new ItemStack(stackFacade);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return super.getPickBlock(player, target);
    }

    @Override
    public List<ItemStack> getAuxDrops(int fortune) {
        return Collections.emptyList();
    }

    @Override
    public SoundType getBlockSound(Entity entity) {
        return SoundType.field_185854_g;
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        if (this.stackFacade == null || this.stackFacade.func_190926_b()) {
            EnumFacing[] var5;
            float th = 0.25f;
            float sp = (1.0f - th) / 2.0f;
            ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>(7);
            ret.add(new AxisAlignedBB((double)sp, (double)sp, (double)sp, (double)(sp + th), (double)(sp + th), (double)(sp + th)));
            for (EnumFacing facing : var5 = EnumFacing.field_82609_l) {
                float zE;
                boolean hasConnection;
                boolean bl = hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                if (!hasConnection) continue;
                float zS = sp;
                float yS = sp;
                float xS = sp;
                float yE = zE = sp + th;
                float xE = zE;
                switch (facing) {
                    case DOWN: {
                        xS = sp + th;
                        xE = 1.0f;
                        break;
                    }
                    case UP: {
                        xS = 0.0f;
                        xE = sp;
                        break;
                    }
                    case NORTH: {
                        zS = sp + th;
                        zE = 1.0f;
                        break;
                    }
                    case SOUTH: {
                        zS = 0.0f;
                        zE = sp;
                        break;
                    }
                    case WEST: {
                        yS = sp + th;
                        yE = 1.0f;
                        break;
                    }
                    case EAST: {
                        yS = 0.0f;
                        yE = sp;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                ret.add(new AxisAlignedBB((double)xS, (double)yS, (double)zS, (double)xE, (double)yE, (double)zE));
            }
            return ret;
        }
        return super.getAabbs(forCollision);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return null;
    }

    @Override
    public BlockTileEntity getBlock() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void setConnectivity(byte connectivity) {
        if (this.connectivity != connectivity) {
            this.connectivity = connectivity;
            new PacketUpdateFieldTile(this, "connectivity", this.connectivity);
            new PacketUpdateFieldTile(this, "texture", this.texture);
            this.rerender();
        }
    }

    public void updateConnectivity() {
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_145831_w().field_72995_K && stack.func_77973_b() == IUItem.facadeItem) {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            NBTTagList contentList = nbt.func_150295_c("Items", 10);
            for (int i = 0; i < 1; ++i) {
                NBTTagCompound slotNbt = contentList.func_150305_b(i);
                this.stackFacade = new ItemStack(slotNbt);
            }
            Block block = Block.func_149634_a((Item)this.stackFacade.func_77973_b());
            if (block != Blocks.field_150350_a) {
                this.stackFacade = this.stackFacade.func_77946_l();
                new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
            } else {
                this.stackFacade = ItemStack.field_190927_a;
            }
        } else if (stack.func_77973_b() == IUItem.connect_item) {
            return super.onActivated(player, hand, side, hitX, hitY, hitZ);
        }
        if (this instanceof ITransportConductor) {
            boolean can = TransportNetGlobal.getForWorld(this.field_145850_b).hasInSystem((ITransportAcceptor)((Object)this));
            if (can) {
                return super.onActivated(player, hand, side, hitX, hitY, hitZ);
            }
            return false;
        }
        return false;
    }

    public void rerenderCable(ItemStack stack) {
        this.stackFacade = stack != ItemStack.field_190927_a ? stack.func_77946_l() : stack;
        new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiCable(this.getGuiContainer(var1));
    }

    public ContainerCable getGuiContainer(EntityPlayer var1) {
        return new ContainerCable(var1, this);
    }

    @Override
    public boolean onSneakingActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && !this.stackFacade.func_190926_b()) {
            this.stackFacade = ItemStack.field_190927_a;
            new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
        }
        return super.onSneakingActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("connectivity")) {
            try {
                this.connectivity = (Byte)DecoderHandler.decode(is);
                this.renderState = new RenderState(this.getTexture(), this.connectivity);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("texture")) {
            try {
                this.texture = (ResourceLocation)DecoderHandler.decode(is);
                this.renderState = new RenderState(this.getTexture(), this.connectivity);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("stackFacade")) {
            try {
                this.stackFacade = (ItemStack)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.stackFacade);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.stackFacade = (ItemStack)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer buffer = super.writeContainerPacket();
        try {
            EncoderHandler.encode(buffer, this.blackList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.blackList = (List)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasSpecialModel() {
        return true;
    }

    @Override
    public TileEntityBlockStateContainer.PropertiesStateInstance getExtendedState(TileEntityBlockStateContainer.PropertiesStateInstance state) {
        state = super.getExtendedState(state);
        if (this.renderState == null) {
            this.renderState = new RenderState(this.getTexture(), this.connectivity);
        }
        state = state.withProperties(renderStateProperty, this.renderState);
        return state;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        byte event1 = (byte)var2;
        EnumFacing facing1 = EnumFacing.values()[event1];
        if (this.blackList.contains(facing1)) {
            this.blackList.remove(facing1);
        } else {
            this.blackList.add(facing1);
        }
    }
}

