/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.NodeStats;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.item.IHazmatLike;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockCable;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketCableSound;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.CableType;
import com.denfop.tiles.transport.types.ICableItem;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityCable
extends TileEntityMultiCable
implements IEnergyConductor {
    public boolean addedToEnergyNet = false;
    public int type;
    protected CableType cableType;
    private boolean needUpdate;

    public TileEntityCable(CableType cableType) {
        super(cableType);
        this.cableType = cableType;
        this.type = cableType.ordinal();
    }

    public TileEntityCable() {
        super(CableType.glass);
        this.cableType = CableType.glass;
        this.type = this.cableType.ordinal();
    }

    @Override
    public void onEntityCollision(Entity entity) {
        super.onEntityCollision(entity);
        if (!this.func_145831_w().field_72995_K && entity instanceof EntityLivingBase && (this.cableType == CableType.tin || this.cableType == CableType.copper || this.cableType == CableType.gold || this.cableType == CableType.iron)) {
            NodeStats stats = EnergyNetGlobal.instance.getNodeStats(this);
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!IHazmatLike.hasCompleteHazmat((EntityLivingBase)player) && stats.getEnergyIn() > 0.0) {
                    entity.func_70097_a(IUDamageSource.radiation, 0.25f);
                }
            } else if (stats.getEnergyIn() > 0.0) {
                entity.func_70097_a(IUDamageSource.radiation, 0.25f);
            }
        }
    }

    public static TileEntityCable delegate(CableType cableType) {
        return new TileEntityCable(cableType);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockCable.cable_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.cableblock;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = CableType.values[nbt.func_74771_c("cableType") & 0xFF];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.func_145831_w(), this));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.func_145831_w(), this, this));
            this.needUpdate = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.func_145831_w(), this, this));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.func_145831_w(), this));
            this.addedToEnergyNet = false;
            this.updateConnectivity();
        }
        super.onUnloaded();
    }

    @Override
    public SoundType getBlockSound(Entity entity) {
        return SoundType.field_185854_g;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack(IUItem.cable, 1, this.cableType.ordinal());
    }

    @Override
    public ItemStack getItem(EntityPlayer player, RayTraceResult target) {
        return new ItemStack(IUItem.cable, 1, this.cableType.ordinal());
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public void updateConnectivity() {
        EnumFacing[] var4;
        World world = this.func_145831_w();
        byte newConnectivity = 0;
        for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
            newConnectivity = (byte)(newConnectivity << 1);
            IEnergyTile tile = EnergyNetGlobal.instance.getTile(world, this.field_174879_c.func_177972_a(dir));
            if (this.getBlackList().contains(dir) || (!(tile instanceof IEnergyAcceptor) || !((IEnergyAcceptor)tile).acceptsEnergyFrom(this, dir.func_176734_d())) && (!(tile instanceof IEnergyEmitter) || !((IEnergyEmitter)tile).emitsEnergyTo(this, dir.func_176734_d()))) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public double getConductionLoss() {
        return this.cableType.loss;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public void removeConductor() {
        this.func_145831_w().func_175698_g(this.field_174879_c);
        new PacketCableSound(this.func_145831_w(), this.field_174879_c, 0.5, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = CableType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update_render() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }
}

