/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.water.tank;

import com.denfop.componets.Fluids;
import com.denfop.container.ContainerWaterTank;
import com.denfop.gui.GuiMainTank;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.water.ITank;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMainTank
extends TileEntityMultiBlockElement
implements ITank {
    public final Fluids fluids = this.addComponent(new Fluids(this));
    public final Fluids.InternalFluidTank tank;
    public int level = 0;

    public TileEntityMainTank(int col) {
        this.tank = this.fluids.addTank("fluidTank", col);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        int level = (int)(6.0 * ((double)this.tank.getFluidAmount() / ((double)this.tank.getCapacity() * 1.0)));
        if (level != this.level) {
            this.level = level;
            new PacketUpdateFieldTile(this, "level", this.level);
            if (level != 0) {
                this.setActive(String.valueOf(this.level));
            } else {
                this.setActive("");
            }
        }
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("level")) {
            try {
                this.level = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiMainTank(this.getGuiContainer(var1));
    }

    public ContainerWaterTank getGuiContainer(EntityPlayer var1) {
        return new ContainerWaterTank(this, var1);
    }

    @Override
    public Fluids getFluids() {
        return this.fluids;
    }

    @Override
    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    @Override
    public void setFluid(Fluid fluid) {
        this.tank.setAcceptedFluids(Fluids.fluidPredicate(fluid));
    }
}

