/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.heat.pump;

import com.denfop.container.ContainerHeatPump;
import com.denfop.gui.GuiHeatPump;
import com.denfop.invslot.InvSlot;
import com.denfop.items.resource.ItemCraftingElements;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.heat.IPump;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBasePump
extends TileEntityMultiBlockElement
implements IPump {
    private final int level;
    private final InvSlot slot;
    private int power;
    private int energy;

    public TileEntityBasePump(int level) {
        this.level = level;
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.func_77973_b() instanceof ItemCraftingElements)) {
                    return false;
                }
                int itemDamage = stack.func_77952_i();
                switch (itemDamage) {
                    case 276: {
                        return ((TileEntityBasePump)this.base).getLevel() >= 0;
                    }
                    case 20: {
                        return ((TileEntityBasePump)this.base).getLevel() >= 1;
                    }
                    case 96: {
                        return ((TileEntityBasePump)this.base).getLevel() >= 2;
                    }
                    case 120: {
                        return ((TileEntityBasePump)this.base).getLevel() >= 3;
                    }
                }
                return false;
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (content.func_190926_b()) {
                    ((TileEntityBasePump)this.base).setEnergy(0);
                    ((TileEntityBasePump)this.base).setPower(0);
                } else {
                    int itemDamage = content.func_77952_i();
                    switch (itemDamage) {
                        case 276: {
                            ((TileEntityBasePump)this.base).setEnergy(5);
                            ((TileEntityBasePump)this.base).setPower(1);
                            break;
                        }
                        case 20: {
                            ((TileEntityBasePump)this.base).setEnergy(10);
                            ((TileEntityBasePump)this.base).setPower(2);
                            break;
                        }
                        case 96: {
                            ((TileEntityBasePump)this.base).setEnergy(20);
                            ((TileEntityBasePump)this.base).setPower(3);
                            break;
                        }
                        case 120: {
                            ((TileEntityBasePump)this.base).setEnergy(40);
                            ((TileEntityBasePump)this.base).setPower(4);
                        }
                    }
                }
            }
        };
    }

    public ContainerHeatPump getGuiContainer(EntityPlayer var1) {
        return new ContainerHeatPump(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiHeatPump(this.getGuiContainer(var1));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            if (this.getSlot().get().func_190926_b()) {
                this.setEnergy(0);
                this.setPower(0);
            } else {
                int itemDamage = this.getSlot().get().func_77952_i();
                switch (itemDamage) {
                    case 276: {
                        this.setEnergy(5);
                        this.setPower(1);
                        break;
                    }
                    case 20: {
                        this.setEnergy(10);
                        this.setPower(2);
                        break;
                    }
                    case 96: {
                        this.setEnergy(20);
                        this.setPower(3);
                        break;
                    }
                    case 120: {
                        this.setEnergy(40);
                        this.setPower(4);
                    }
                }
            }
        }
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void setPower(int power) {
        this.power = power;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public InvSlot getSlot() {
        return this.slot;
    }
}

