/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.quarry_earth;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockEarthQuarry;
import com.denfop.componets.AdvEnergy;
import com.denfop.container.ContainerEarthController;
import com.denfop.gui.GuiEarthController;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.quarry_earth.DataPos;
import com.denfop.tiles.quarry_earth.IAnalyzer;
import com.denfop.tiles.quarry_earth.IEarthChest;
import com.denfop.tiles.quarry_earth.IEarthQuarry;
import com.denfop.tiles.quarry_earth.IRigDrill;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEarthQuarryController
extends TileMultiBlockBase
implements IEarthQuarry,
IUpdatableTileEvent {
    public static List<ChunkPos> chunkPos = new ArrayList<ChunkPos>();
    public final AdvEnergy energy;
    public List<IEarthChest> earthChestList = new ArrayList<IEarthChest>();
    public IAnalyzer analyzer;
    public boolean work;
    public static Random random = new Random();
    public int indexChunk = 0;
    public Map<ChunkPos, List<DataPos>> map;
    public List<ChunkPos> chunkPosList;
    private List<DataPos> dataPos = new ArrayList<DataPos>();
    private IRigDrill quarry;
    public int max = 0;

    public TileEntityEarthQuarryController() {
        super(InitMultiBlockSystem.EarthQuarryMultiBlock);
        this.energy = this.addComponent(AdvEnergy.asBasicSink((TileEntityInventory)this, 100000.0, 14));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.work = nbttagcompound.func_74767_n("work");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("work", this.work);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.earthQuarry;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockEarthQuarry.earth_controller;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.max);
        customPacketBuffer.writeInt(this.indexChunk);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.max = customPacketBuffer.readInt();
        this.indexChunk = customPacketBuffer.readInt();
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 == 0.0 && !this.analyzer.getChunkPoses().isEmpty()) {
            this.work = !this.work;
            this.indexChunk = 0;
            this.dataPos.clear();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.full && this.func_145831_w().field_73011_w.getWorldTime() % 10L == 0L) {
            if (this.analyzer.fullAnalyzed() && !this.chunkPosList.isEmpty()) {
                List<DataPos> dataPos = this.map.get(this.chunkPosList.get(this.indexChunk));
                this.max = this.chunkPosList.size();
                for (DataPos dataPos1 : dataPos) {
                    if (this.energy.getEnergy() < 50.0) continue;
                    this.energy.useEnergy(50.0);
                    if (dataPos1.state.func_177230_c() == Blocks.field_150346_d) {
                        if (random.nextInt(200) != 199) continue;
                        this.field_145850_b.func_175656_a(dataPos1.getPos(), IUItem.ore2.func_176203_a(1));
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.func_177230_c() == Blocks.field_150351_n) {
                        if (random.nextInt(200) != 199) continue;
                        this.field_145850_b.func_175656_a(dataPos1.getPos(), IUItem.ore2.func_176203_a(2));
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.func_177230_c() != Blocks.field_150354_m || random.nextInt(200) != 199) continue;
                    this.field_145850_b.func_175656_a(dataPos1.getPos(), IUItem.ore2.func_176203_a(0));
                    this.dataPos.add(dataPos1);
                }
                chunkPos.add(this.chunkPosList.get(this.indexChunk));
                ++this.indexChunk;
                if (this.indexChunk == this.chunkPosList.size()) {
                    this.quarry.startOperation(this.dataPos);
                    this.chunkPosList.clear();
                    this.work = false;
                }
            } else {
                this.work = false;
                this.indexChunk = this.max;
            }
        }
    }

    public ContainerEarthController getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerEarthController(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiEarthController(this.getGuiContainer(var1));
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.earthChestList.clear();
        }
    }

    @Override
    public void updateAfterAssembly() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IAnalyzer.class);
        this.analyzer = (IAnalyzer)this.func_145831_w().func_175625_s(pos1.get(0));
        List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IEarthChest.class);
        for (BlockPos pos3 : pos2) {
            this.earthChestList.add((IEarthChest)this.func_145831_w().func_175625_s(pos3));
        }
        this.map = this.analyzer.getChunkPoses();
        this.chunkPosList = new ArrayList<ChunkPos>(this.map.keySet());
        List<BlockPos> pos3 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IRigDrill.class);
        this.quarry = (IRigDrill)this.func_145831_w().func_175625_s(pos3.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }

    public AdvEnergy getEnergy() {
        return this.energy;
    }
}

