/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.panels.entity;

import com.denfop.Config;
import com.denfop.Localization;
import com.denfop.api.IAdvEnergyNet;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.SunCoef;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.tile.IWrenchable;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.componets.ComponentPollution;
import com.denfop.componets.ComponentTimer;
import com.denfop.container.ContainerSolarPanels;
import com.denfop.gui.GuiSolarPanels;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotPanel;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.panels.entity.EnumSolarPanels;
import com.denfop.tiles.panels.entity.EnumType;
import com.denfop.tiles.panels.entity.WirelessTransfer;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileSolarPanel
extends TileEntityInventory
implements IEnergySource,
IWrenchable,
IUpdatableTileEvent {
    public final ComponentTimer timer;
    public final ComponentPollution pollution;
    public double coef;
    public List<IEnergyTile> list;
    public EnumSolarPanels solarpanels;
    public int tier;
    public List<WirelessTransfer> wirelessTransferList = new ArrayList<WirelessTransfer>();
    public InvSlotPanel inputslot;
    public Biome biome;
    public int solarType = 0;
    public EnumType type;
    public boolean charge;
    public boolean wireless = false;
    public GenerationState activeState = GenerationState.NONE;
    public boolean wetBiome;
    public boolean noSunWorld;
    public boolean rain;
    public boolean sunIsUp;
    public boolean skyIsVisible;
    public double generating;
    public double genDay;
    public double genNight;
    public double storage;
    public double production;
    public double maxStorage;
    public double p;
    public double k;
    public double m;
    public double u;
    public double o;
    public double moonPhase = 1.0;
    public double tick;
    public SunCoef sunCoef;
    public int level = 0;
    public boolean canRain;
    public boolean hasSky;
    protected double tierPower;
    protected boolean addedToEnet;
    protected double pastEnergy;
    protected double perenergy;

    public TileSolarPanel(int tier, double gDay, double gOutput, double gmaxStorage, EnumSolarPanels type) {
        this.genDay = gDay;
        this.genNight = gDay / 2.0;
        this.storage = 0.0;
        this.generating = 0.0;
        this.maxStorage = gmaxStorage;
        this.p = gmaxStorage;
        this.k = gDay;
        this.m = gDay / 2.0;
        this.production = gOutput;
        this.u = gOutput;
        this.tier = tier;
        this.o = tier;
        this.inputslot = new InvSlotPanel(this, tier, 9, InvSlot.TypeItemSlot.INPUT_OUTPUT);
        this.tierPower = EnergyNetGlobal.instance.getPowerFromTier(tier);
        this.type = EnumType.DEFAULT;
        this.solarpanels = type;
        this.list = new ArrayList<IEnergyTile>();
        this.coef = 0.0;
        this.pastEnergy = 0.0;
        this.perenergy = 0.0;
        this.tick = 0.0;
        this.pollution = this.addComponent(new ComponentPollution(this));
        this.timer = this.addComponent(new ComponentTimer(this, new Timer[]{new Timer(8, 0, 0), new Timer(4, 0, 0), new Timer(4, 0, 0)}){

            @Override
            public boolean needWriteNBTToDrops() {
                return true;
            }
        });
        this.pollution.setTimer(this.timer);
    }

    public TileSolarPanel(EnumSolarPanels solarpanels) {
        this(solarpanels.tier, solarpanels.genday, solarpanels.producing, solarpanels.maxstorage, solarpanels);
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.pollution, false);
            EncoderHandler.encode(packet, this.timer, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.pollution.onNetworkUpdate(customPacketBuffer);
            this.timer.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.sunIsUp = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.skyIsVisible = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.generating = (Double)DecoderHandler.decode(customPacketBuffer);
            this.genDay = (Double)DecoderHandler.decode(customPacketBuffer);
            this.genNight = (Double)DecoderHandler.decode(customPacketBuffer);
            this.storage = (Double)DecoderHandler.decode(customPacketBuffer);
            this.maxStorage = (Double)DecoderHandler.decode(customPacketBuffer);
            this.production = (Double)DecoderHandler.decode(customPacketBuffer);
            this.rain = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.solarType = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.type = EnumType.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.u = (Double)DecoderHandler.decode(customPacketBuffer);
            this.p = (Double)DecoderHandler.decode(customPacketBuffer);
            this.k = (Double)DecoderHandler.decode(customPacketBuffer);
            this.m = (Double)DecoderHandler.decode(customPacketBuffer);
            this.tier = (Integer)DecoderHandler.decode(customPacketBuffer);
            boolean isNull = (Boolean)DecoderHandler.decode(customPacketBuffer);
            if (!isNull) {
                this.solarpanels = EnumSolarPanels.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            }
            this.activeState = GenerationState.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.wireless = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.sunIsUp);
            EncoderHandler.encode(packet, this.skyIsVisible);
            EncoderHandler.encode(packet, this.generating);
            EncoderHandler.encode(packet, this.genDay);
            EncoderHandler.encode(packet, this.genNight);
            EncoderHandler.encode(packet, this.storage);
            EncoderHandler.encode(packet, this.maxStorage);
            EncoderHandler.encode(packet, this.production);
            EncoderHandler.encode(packet, this.rain);
            EncoderHandler.encode(packet, this.solarType);
            EncoderHandler.encode(packet, (Object)this.type);
            EncoderHandler.encode(packet, this.u);
            EncoderHandler.encode(packet, this.p);
            EncoderHandler.encode(packet, this.k);
            EncoderHandler.encode(packet, this.m);
            EncoderHandler.encode(packet, this.tier);
            EncoderHandler.encode(packet, this.solarpanels == null);
            if (this.solarpanels != null) {
                EncoderHandler.encode(packet, (Object)this.solarpanels);
            }
            EncoderHandler.encode(packet, (Object)this.activeState);
            EncoderHandler.encode(packet, this.wireless);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        this.wirelessTransferList.clear();
        this.inputslot.wirelessmodule();
        this.wireless = !this.wirelessTransferList.isEmpty();
    }

    public String getStartSoundFile() {
        return "Machines/pen.ogg";
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public List<ItemStack> getDrop() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            if (this.inputslot.get(i).func_190926_b()) continue;
            list.add(this.inputslot.get(i));
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, List<String> info, ITooltipFlag advanced) {
        if (Config.promt) {
            info.add(Localization.translate("supsolpans.iu.GenerationDay.tooltip") + " " + ModUtils.getString(this.genDay) + " EF/t ");
            info.add(Localization.translate("supsolpans.iu.GenerationNight.tooltip") + " " + ModUtils.getString(this.genNight) + " EF/t ");
            info.add(Localization.translate("iu.item.tooltip.Output") + " " + ModUtils.getString(this.production) + " EF/t ");
            info.add(Localization.translate("iu.item.tooltip.Capacity") + " " + ModUtils.getString(this.maxStorage) + " EF ");
            info.add(Localization.translate("iu.tier") + ModUtils.getString(this.tier));
        }
    }

    public EnumSolarPanels getPanels() {
        return this.solarpanels;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void gainFuel() {
        double coefpollution = 1.0;
        switch (this.timer.getIndexWork()) {
            case -1: {
                coefpollution = 0.25;
                break;
            }
            case 1: {
                coefpollution = 0.75;
                break;
            }
            case 2: {
                coefpollution = 0.5;
            }
        }
        switch (this.activeState) {
            case DAY: {
                this.generating = this.type.coefficient_day * this.genDay;
                break;
            }
            case NIGHT: {
                this.generating = this.type.coefficient_night * this.genNight;
                break;
            }
            case RAINDAY: {
                this.generating = this.type.coefficient_rain * this.type.coefficient_day * this.genDay;
                break;
            }
            case RAINNIGHT: {
                this.generating = this.type.coefficient_rain * this.type.coefficient_night * this.genNight;
                break;
            }
            case NETHER: {
                this.generating = this.type.coefficient_nether * this.genDay;
                break;
            }
            case END: {
                this.generating = this.type.coefficient_end * this.genDay;
                break;
            }
            case NONE: {
                this.generating = 0.0;
            }
        }
        double coefficient_phase = this.experimental_generating();
        double coef = this.moonPhase;
        if (this.sunIsUp) {
            coef = 1.0;
        }
        this.generating *= coefpollution * coefficient_phase * coef;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        drop = Collections.singletonList(this.adjustDrop(drop.get(0), wrench, fortune));
        return drop;
    }

    public ItemStack adjustDrop(ItemStack drop, boolean wrench, int fortune) {
        drop = super.adjustDrop(drop, wrench);
        if (wrench || this.teBlock.getDefaultDrop() == MultiTileBlock.DefaultDrop.Self) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            if (fortune == 100) {
                nbt.func_82580_o(this.timer.toString());
            }
        }
        return drop;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.func_145831_w(), this));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.canRain = this.field_145850_b.func_180494_b(this.field_174879_c).func_76738_d() || this.field_145850_b.func_180494_b(this.field_174879_c).func_76727_i() > 0.0f;
            this.hasSky = !this.field_145850_b.field_73011_w.func_177495_o();
            this.biome = this.field_145850_b.func_180494_b(this.field_174879_c);
            this.updateVisibility();
            this.inputslot.checkmodule();
            this.solarType = this.inputslot.solartype();
            IAdvEnergyNet advEnergyNet = EnergyNetGlobal.instance;
            this.sunCoef = advEnergyNet.getSunCoefficient(this.field_145850_b);
        }
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.func_145831_w(), this));
    }

    private double experimental_generating() {
        double k = this.sunCoef.getCoef();
        double coef = this.coef;
        return Math.max(coef, k);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.storage = nbttagcompound.func_74769_h("storage");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74780_a("storage", this.storage);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 40L == 0L) {
            this.updateVisibility();
            this.solarType = this.inputslot.solartypeFast();
            if (this.solarType == 0) {
                this.setActive("");
            } else {
                this.setActive(EnumType.getFromID(this.solarType).getNameType());
            }
        }
        if (this.charge) {
            this.inputslot.charge();
        }
        if (this.activeState == GenerationState.NONE) {
            this.generating = 0.0;
            return;
        }
        if (this.wireless) {
            boolean refresh = false;
            try {
                for (WirelessTransfer transfer : this.wirelessTransferList) {
                    if (transfer.getTile().func_145837_r()) {
                        refresh = true;
                        continue;
                    }
                    double energy = Math.min(this.canExtractEnergy(), transfer.getSink().getDemandedEnergy());
                    transfer.work(energy);
                    this.storage -= energy;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (refresh) {
                this.wirelessTransferList.clear();
                this.inputslot.wirelessmodule();
            }
        }
        this.gainFuel();
        if (this.generating > 0.0) {
            this.storage = this.storage + this.generating <= this.maxStorage ? (this.storage += this.generating) : this.maxStorage;
        }
    }

    public void updateVisibility() {
        this.wetBiome = this.biome.func_76727_i() > 0.0f;
        this.noSunWorld = this.field_145850_b.field_73011_w.func_177495_o();
        this.rain = this.wetBiome && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        this.sunIsUp = this.field_145850_b.func_72935_r();
        boolean bl = this.skyIsVisible = this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_151565_r() == MapColor.field_151660_b && !this.noSunWorld;
        if (!this.skyIsVisible) {
            this.activeState = GenerationState.NONE;
        }
        if (this.sunIsUp && this.skyIsVisible) {
            this.activeState = !this.rain ? GenerationState.DAY : GenerationState.RAINDAY;
        }
        if (!this.sunIsUp && this.skyIsVisible) {
            this.activeState = !this.rain ? GenerationState.NIGHT : GenerationState.RAINNIGHT;
        }
        if (this.field_145850_b.field_73011_w.getDimension() == 1) {
            this.activeState = GenerationState.END;
        }
        if (this.field_145850_b.field_73011_w.getDimension() == -1) {
            this.activeState = GenerationState.NETHER;
        }
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    public void extractEnergy(double amount) {
        this.storage -= amount;
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public List<ItemStack> getWrenchDrops(World world, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity, EntityPlayer entityPlayer, int i) {
        return new ArrayList<ItemStack>(Arrays.asList(this.inputslot.gets()));
    }

    @Override
    public void wrenchBreak(World world, BlockPos pos) {
        this.wrenchBreak();
    }

    @Override
    public EnumFacing getFacing(World world, BlockPos blockPos) {
        return this.getFacing();
    }

    @Override
    public boolean setFacing(World world, BlockPos blockPos, EnumFacing enumFacing, EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        return true;
    }

    public ContainerSolarPanels getGuiContainer(EntityPlayer player) {
        return new ContainerSolarPanels(player, this);
    }

    @Override
    public double canExtractEnergy() {
        return Math.min(this.production, this.storage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiSolarPanels(new ContainerSolarPanels(player, this));
    }

    public double gaugeEnergyScaled(float i) {
        if (this.storage * (double)i / this.maxStorage > 24.0) {
            return 24.0;
        }
        return (float)(this.storage * (double)i / this.maxStorage);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.solarType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.solarType = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
    }

    public EnumType getType() {
        return this.type;
    }

    public void setType(EnumType type) {
        this.type = type;
    }

    public int setSolarType(EnumType type) {
        if (type == null) {
            this.setType(EnumType.DEFAULT);
            return 0;
        }
        this.setType(type);
        switch (type) {
            case AIR: {
                if (this.field_174879_c.func_177956_o() < 130) break;
                return 1;
            }
            case EARTH: {
                if (this.field_174879_c.func_177956_o() > 40) break;
                return 2;
            }
            case NETHER: {
                if (this.field_145850_b.field_73011_w.getDimension() != -1) break;
                return 3;
            }
            case END: {
                if (this.field_145850_b.field_73011_w.getDimension() != 1) break;
                return 4;
            }
            case NIGHT: {
                if (this.sunIsUp) break;
                return 5;
            }
            case DAY: {
                if (!this.sunIsUp) break;
                return 6;
            }
            case RAIN: {
                if (!this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I()) break;
                return 7;
            }
        }
        this.setType(EnumType.DEFAULT);
        return 0;
    }

    @Override
    public double getPerEnergy() {
        return this.perenergy;
    }

    @Override
    public double getPastEnergy() {
        return this.pastEnergy;
    }

    @Override
    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    @Override
    public void addPerEnergy(double setEnergy) {
        this.perenergy += setEnergy;
    }

    @Override
    public boolean isSource() {
        return true;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    public static enum GenerationState {
        DAY,
        NIGHT,
        RAINDAY,
        RAINNIGHT,
        NETHER,
        END,
        NONE;

    }
}

