/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.water;

import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.water.upgrade.EnumInfoRotorUpgradeModules;
import com.denfop.api.water.upgrade.IRotorUpgradeItem;
import com.denfop.api.water.upgrade.RotorUpgradeItemInform;
import com.denfop.api.water.upgrade.RotorUpgradeSystem;
import com.denfop.api.water.upgrade.event.EventRotorItemLoad;
import com.denfop.api.windsystem.EnumLevelGenerators;
import com.denfop.api.windsystem.EnumRotorSide;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.EnumWindSide;
import com.denfop.api.windsystem.IWindMechanism;
import com.denfop.api.windsystem.IWindRotor;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.api.windsystem.event.WindGeneratorEvent;
import com.denfop.componets.AdvEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.container.ContainerBaseWaterGenerator;
import com.denfop.gui.GuiBaseWaterGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotWaterRotor;
import com.denfop.invslot.InvSlotWaterRotorBlades;
import com.denfop.items.ItemWindRod;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.DamageHandler;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.biome.BiomeRiver;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileBaseWaterGenerator
extends TileEntityInventory
implements IWindMechanism,
IType,
IUpdatableTileEvent {
    public final AdvEnergy energy;
    public final InvSlotWaterRotorBlades slot_blades;
    private final EnumLevelGenerators levelGenerators;
    public InvSlotWaterRotor slot;
    public double generation = 0.0;
    public boolean need_repair;
    public int mind_wind;
    public boolean can_repair;
    public int mind_speed;
    public int timers;
    public double wind_speed;
    public EnumWindSide wind_side;
    public EnumTypeWind enumTypeWind;
    boolean space = false;
    private int tick;
    private boolean change_facing;
    private boolean min_level;
    private int addition_power;
    private int addition_efficient;
    private int addition_strength;
    private double coefficient;
    private EnumRotorSide rotorSide;
    private float speed;
    private float angle;
    private long lastcheck;
    private boolean work;
    private int time;
    private boolean can_work;
    private double biome;

    public TileBaseWaterGenerator(EnumLevelGenerators levelGenerators) {
        this.levelGenerators = levelGenerators;
        this.slot = new InvSlotWaterRotor(this);
        this.slot_blades = new InvSlotWaterRotorBlades(this);
        this.energy = this.addComponent(AdvEnergy.asBasicSource(this, 500000 * (levelGenerators.ordinal() + 1), 1));
        this.change_facing = false;
        this.min_level = false;
        this.addition_power = 0;
        this.addition_efficient = 0;
        this.addition_strength = 0;
        this.tick = 0;
        this.biome = 1.0;
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.WATER_GENERATOR);
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.slot);
            EncoderHandler.encode(packet, this.facing);
            EncoderHandler.encode(packet, this.generation);
            EncoderHandler.encode(packet, this.mind_speed);
            EncoderHandler.encode(packet, this.coefficient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.slot.readFromNbt(this.getNBTFromSlot(customPacketBuffer));
            this.facing = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
            this.mind_speed = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.coefficient = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        super.addInformation(stack, tooltip, advanced);
        tooltip.add(Localization.translate("wind.need_level") + this.levelGenerators.getMin() + " " + Localization.translate("wind.need_level1") + this.levelGenerators.getMax() + " " + Localization.translate("wind.need_level2"));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.coefficient = (Double)DecoderHandler.decode(customPacketBuffer);
            this.speed = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.slot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            this.rotorSide = EnumRotorSide.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
            this.timers = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.wind_speed = (Double)DecoderHandler.decode(customPacketBuffer);
            this.wind_side = EnumWindSide.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.mind_wind = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.mind_speed = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.enumTypeWind = EnumTypeWind.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.coefficient);
            EncoderHandler.encode(packet, Float.valueOf(this.speed));
            EncoderHandler.encode(packet, this.slot);
            EncoderHandler.encode(packet, (Object)this.rotorSide);
            EncoderHandler.encode(packet, this.generation);
            EncoderHandler.encode(packet, this.timers);
            EncoderHandler.encode(packet, this.wind_speed);
            EncoderHandler.encode(packet, (Object)this.wind_side);
            EncoderHandler.encode(packet, this.mind_wind);
            EncoderHandler.encode(packet, this.mind_speed);
            EncoderHandler.encode(packet, (Object)this.enumTypeWind);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getRotor() != null && stack.func_77973_b() instanceof ItemWindRod) {
            ItemStack rotor = this.slot.get();
            if (((ItemWindRod)stack.func_77973_b()).getLevel(this.getRotor().getLevel(), stack.func_77952_i()) && (double)rotor.func_77952_i() >= (double)rotor.func_77958_k() * 0.25) {
                this.slot.damage((int)(-((double)rotor.func_77958_k() * 0.25)), 0.0);
                stack.func_190918_g(1);
                return true;
            }
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    public boolean checkSpace() {
        int box = this.getRotorDiameter() / 2;
        if (box == 0) {
            return false;
        }
        BlockPos pos1 = this.field_174879_c.func_177971_a(this.getFacing().func_176730_m());
        switch (this.getFacing().func_176740_k()) {
            case Y: {
                return false;
            }
            case X: {
                for (int z = pos1.func_177952_p() - box; z <= pos1.func_177952_p() + box; ++z) {
                    for (int y = pos1.func_177956_o() - box; y <= pos1.func_177956_o() + box; ++y) {
                        IBlockState state = this.field_145850_b.func_180495_p(new BlockPos(pos1.func_177958_n(), y, z));
                        if (state.func_185904_a() == Material.field_151586_h) continue;
                        return false;
                    }
                }
                return true;
            }
            case Z: {
                for (int x = pos1.func_177958_n() - box; x <= pos1.func_177958_n() + box; ++x) {
                    for (int y = pos1.func_177956_o() - box; y <= pos1.func_177956_o() + box; ++y) {
                        IBlockState state = this.field_145850_b.func_180495_p(new BlockPos(x, y, pos1.func_177952_p()));
                        if (state.func_185904_a() == Material.field_151586_h) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setFacingWrench(EnumFacing facing, EntityPlayer player) {
        boolean fac = super.setFacingWrench(facing, player);
        new PacketUpdateFieldTile(this, "facing", this.facing);
        return fac;
    }

    public void update_generator() {
        this.work = true;
        for (int i = this.field_174879_c.func_177958_n() - 4; i <= this.field_174879_c.func_177958_n() + 4; ++i) {
            for (int j = this.field_174879_c.func_177956_o() - 4; j <= this.field_174879_c.func_177956_o() + 4; ++j) {
                for (int k = this.field_174879_c.func_177952_p() - 4; k <= this.field_174879_c.func_177952_p() + 4; ++k) {
                    TileEntity tile;
                    if (this.field_174879_c.func_177958_n() == i && this.field_174879_c.func_177956_o() == j && this.field_174879_c.func_177952_p() == k || !((tile = this.func_145831_w().func_175625_s(new BlockPos(i, j, k))) instanceof TileBaseWaterGenerator)) continue;
                    this.work = false;
                    ((TileBaseWaterGenerator)tile).work = false;
                }
            }
        }
        new PacketUpdateFieldTile(this, "work", this.work);
    }

    public void update_generator(BlockPos pos) {
        this.work = true;
        for (int i = this.field_174879_c.func_177958_n() - 4; i <= this.field_174879_c.func_177958_n() + 4; ++i) {
            for (int j = this.field_174879_c.func_177956_o() - 4; j <= this.field_174879_c.func_177956_o() + 4; ++j) {
                for (int k = this.field_174879_c.func_177952_p() - 4; k <= this.field_174879_c.func_177952_p() + 4; ++k) {
                    TileEntity tile;
                    if (this.field_174879_c.func_177958_n() == i && this.field_174879_c.func_177956_o() == j && this.field_174879_c.func_177952_p() == k || pos.func_177958_n() == i && pos.func_177956_o() == j && pos.func_177952_p() == k || !((tile = this.func_145831_w().func_175625_s(new BlockPos(i, j, k))) instanceof TileBaseWaterGenerator)) continue;
                    this.work = false;
                    ((TileBaseWaterGenerator)tile).work = false;
                }
            }
        }
        new PacketUpdateFieldTile(this, "work", this.work);
    }

    @Override
    public EnumRotorSide getRotorSide() {
        return this.rotorSide;
    }

    @Override
    public void setRotorSide(EnumRotorSide rotorSide) {
        this.rotorSide = rotorSide;
        new PacketUpdateFieldTile(this, "rotorSide", (Object)this.rotorSide);
    }

    @Override
    public double getCoefficient() {
        return this.coefficient;
    }

    @Override
    public void setCoefficient(double coefficient) {
        this.coefficient = coefficient;
        new PacketUpdateFieldTile(this, "coefficient", this.coefficient);
    }

    @Override
    public IWindRotor getRotor() {
        return this.slot.isEmpty() ? null : (IWindRotor)this.slot.get().func_77973_b();
    }

    @Override
    public ItemStack getItemStack() {
        return this.slot.get();
    }

    @Override
    public EnumLevelGenerators getLevel() {
        return this.levelGenerators;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.need_repair && this.getRotor() != null) {
            this.slot_blades.work();
        }
        this.timers = WindSystem.windSystem.getTime();
        this.wind_side = WindSystem.windSystem.getWindSide();
        this.enumTypeWind = WindSystem.windSystem.getEnumTypeWind();
        if (!this.work || !this.can_work) {
            if (this.generation != 0.0) {
                this.generation = 0.0;
            }
            return;
        }
        if (this.can_repair && this.time != 0 && this.field_145850_b.field_73011_w.getWorldTime() % ((long)this.time * 20L) == 0L) {
            this.slot.damage(-1, 0.0);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 30L == 0L) {
            if (this.getRotor() != null) {
                this.space = this.checkSpace();
                new PacketUpdateFieldTile(this, "space", this.space);
            } else if (this.space) {
                this.space = false;
                new PacketUpdateFieldTile(this, "space", this.space);
            } else {
                this.generation = 0.0;
            }
        }
        ++this.tick;
        if (this.tick >= 40) {
            this.tick = 40;
        }
        if (this.space && this.getRotor() != null && ((ItemDamage)this.slot.get(0).func_77973_b()).getCustomDamage(this.slot.get(0)) > 0) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.getRotor() == null) {
                if (this.getActive()) {
                    this.setActive(false);
                }
                if (this.space) {
                    this.space = false;
                    new PacketUpdateFieldTile(this, "space", this.space);
                }
                return;
            }
            this.wind_speed = WindSystem.windSystem.getWind_Strength();
            this.generation = WindSystem.windSystem.getPowerFromWaterRotor(this.field_145850_b, this, this.getItemStack()) * this.biome;
            this.energy.addEnergy(this.generation);
            if (this.field_145850_b.func_72820_D() % 20L == 0L) {
                this.slot.damage(1, this.addition_strength);
            }
        } else {
            this.generation = 0.0;
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("speed")) {
            try {
                this.speed = ((Float)DecoderHandler.decode(is)).floatValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot")) {
            this.slot.readFromNbt(this.getNBTFromSlot(is));
        }
        if (name.equals("space")) {
            try {
                this.space = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("coefficient")) {
            try {
                this.coefficient = (Double)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("work")) {
            try {
                this.work = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("rotorSide")) {
            try {
                this.rotorSide = EnumRotorSide.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("change_facing")) {
            try {
                this.change_facing = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("min_level")) {
            try {
                this.min_level = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("mind_wind")) {
            try {
                this.mind_wind = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("wind_side")) {
            try {
                this.wind_side = EnumWindSide.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("angle")) {
            try {
                this.angle = ((Float)DecoderHandler.decode(is)).floatValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("generation")) {
            try {
                this.generation = (Double)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("mind_speed")) {
            try {
                this.mind_speed = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.timers = WindSystem.windSystem.getTime();
        this.wind_side = WindSystem.windSystem.getWindSide();
        this.enumTypeWind = WindSystem.windSystem.getEnumTypeWind();
        if (!this.slot.isEmpty()) {
            MinecraftForge.EVENT_BUS.post((Event)new EventRotorItemLoad(this.func_145831_w(), (IRotorUpgradeItem)this.slot.get().func_77973_b(), this.slot.get()));
        }
        this.biome = this.func_145831_w().func_180494_b(this.field_174879_c) instanceof BiomeOcean || this.func_145831_w().func_180494_b(this.field_174879_c) instanceof BiomeRiver ? 1.0 : 0.5;
        this.change();
        this.setRotorSide(WindSystem.windSystem.getRotorSide(this.getFacing()));
        MinecraftForge.EVENT_BUS.post((Event)new WindGeneratorEvent(this, this.func_145831_w(), true));
        new PacketUpdateFieldTile(this, "speed", Float.valueOf(this.speed));
        new PacketUpdateFieldTile(this, "slot", this.slot);
        new PacketUpdateFieldTile(this, "space", this.space);
        new PacketUpdateFieldTile(this, "coefficient", this.coefficient);
        new PacketUpdateFieldTile(this, "wind_side", (Object)this.wind_side);
        new PacketUpdateFieldTile(this, "angle", Float.valueOf(this.angle));
        new PacketUpdateFieldTile(this, "mind_speed", this.mind_speed);
        new PacketUpdateFieldTile(this, "generation", this.generation);
        this.update_generator();
        if (this.getRotor() != null) {
            this.energy.setSourceTier(this.getRotor().getSourceTier());
        }
        this.can_work = this.func_145831_w().field_73011_w.func_191066_m() && !this.func_145831_w().field_73011_w.func_177495_o();
        this.timers = WindSystem.windSystem.getTime();
        this.wind_side = WindSystem.windSystem.getWindSide();
        this.enumTypeWind = WindSystem.windSystem.getEnumTypeWind();
        if (!this.slot.get().func_190926_b() && (double)DamageHandler.getDamage(this.slot.get()) <= (double)DamageHandler.getMaxDamage(this.slot.get()) * 0.75) {
            this.need_repair = true;
        }
    }

    @Override
    public void onUnloaded() {
        MinecraftForge.EVENT_BUS.post((Event)new WindGeneratorEvent(this, this.func_145831_w(), false));
        super.onUnloaded();
    }

    @Override
    public void onBlockBreak(boolean w) {
        for (int i = this.field_174879_c.func_177958_n() - 4; i <= this.field_174879_c.func_177958_n() + 4; ++i) {
            for (int j = this.field_174879_c.func_177956_o() - 4; j <= this.field_174879_c.func_177956_o() + 4; ++j) {
                for (int k = this.field_174879_c.func_177952_p() - 4; k <= this.field_174879_c.func_177952_p() + 4; ++k) {
                    TileEntity tile = this.func_145831_w().func_175625_s(new BlockPos(i, j, k));
                    if (!(tile instanceof TileBaseWaterGenerator)) continue;
                    ((TileBaseWaterGenerator)tile).update_generator(this.field_174879_c);
                }
            }
        }
        super.onBlockBreak(w);
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.getActive()) {
            new PacketUpdateFieldTile(this, "slot", this.slot);
        }
        super.setActive(active);
    }

    public double getGeneration() {
        return this.generation;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, Float.valueOf(this.speed));
            EncoderHandler.encode(packet, this.slot);
            EncoderHandler.encode(packet, this.space);
            EncoderHandler.encode(packet, this.coefficient);
            EncoderHandler.encode(packet, (Object)this.wind_side);
            EncoderHandler.encode(packet, Float.valueOf(this.angle));
            EncoderHandler.encode(packet, this.mind_speed);
            EncoderHandler.encode(packet, this.generation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.speed = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.slot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            this.space = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.coefficient = (Double)DecoderHandler.decode(customPacketBuffer);
            this.wind_side = EnumWindSide.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.angle = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.mind_speed = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float getAngle() {
        if (this.func_145831_w().field_73011_w.getDimension() != 0) {
            return 0.0f;
        }
        if (this.speed != 0.0f && this.work && this.getRotor() != null && ((ItemDamage)this.slot.get(0).func_77973_b()).getCustomDamage(this.slot.get(0)) > 0) {
            long k = System.currentTimeMillis() - this.lastcheck;
            this.angle = this.mind_wind != 0 ? (float)((double)this.angle + (double)k * WindSystem.windSystem.getSpeed(Math.min(24.7 + (double)this.mind_speed, WindSystem.windSystem.getSpeedFromPower(this.getBlockPos(), this, this.generation)) * this.getCoefficient())) : (float)((double)this.angle + (double)((float)k * this.speed) * this.getCoefficient());
            this.angle %= 360.0f;
        }
        this.lastcheck = System.currentTimeMillis();
        return this.angle;
    }

    @Override
    public void setRotationSpeed(float speed) {
        if (this.speed != speed) {
            this.speed = speed;
            new PacketUpdateFieldTile(this, "speed", Float.valueOf(speed));
        }
    }

    @Override
    public int getRotorDiameter() {
        return this.getRotor() != null ? this.getRotor().getDiameter(this.slot.get()) : 0;
    }

    @Override
    public ResourceLocation getRotorRenderTexture() {
        return this.getRotor() != null ? this.getRotor().getRotorRenderTexture(this.slot.get()) : null;
    }

    @Override
    public void change() {
        this.change_facing = false;
        this.min_level = false;
        this.addition_power = 0;
        this.addition_efficient = 0;
        this.addition_strength = 0;
        this.time = 0;
        this.mind_speed = 0;
        this.mind_wind = 0;
        if (this.getRotor() != null) {
            RotorUpgradeItemInform modules;
            int i;
            List<RotorUpgradeItemInform> list = RotorUpgradeSystem.instance.getInformation(this.getItemStack());
            this.change_facing = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.AUTO, list) != null;
            for (i = 0; i < 3; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.addition_strength = (int)((double)this.addition_strength + (modules == null ? 0.0 : (double)modules.number * modules.upgrade.getCoef()));
            }
            for (i = 3; i < 6; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.addition_efficient = (int)((double)this.addition_efficient + (modules == null ? 0.0 : (double)modules.number * modules.upgrade.getCoef()));
            }
            for (i = 6; i < 9; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.addition_power = (int)((double)this.addition_power + (modules == null ? 0.0 : (double)modules.number * modules.upgrade.getCoef()));
            }
            for (i = 13; i < 16; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.time = modules == null ? 0 : (int)modules.upgrade.getCoef();
            }
            for (i = 10; i < 13; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.mind_wind = modules == null ? 0 : (int)modules.upgrade.getCoef();
            }
            RotorUpgradeItemInform modules2 = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(16), list);
            this.biome = modules2 == null ? 0.5 : 1.0;
        }
        new PacketUpdateFieldTile(this, "change_facing", this.change_facing);
        new PacketUpdateFieldTile(this, "min_level", this.min_level);
        new PacketUpdateFieldTile(this, "mind_wind", this.mind_wind);
        if (this.change_facing) {
            WindSystem.windSystem.getNewPositionOfMechanism(this);
        }
    }

    @Override
    public double getAdditionalCoefficient() {
        return this.addition_efficient;
    }

    @Override
    public double getAdditionalPower() {
        return this.addition_power;
    }

    @Override
    public boolean getAuto() {
        return this.change_facing;
    }

    @Override
    public boolean getMin() {
        return this.min_level;
    }

    @Override
    public boolean getSpace() {
        return this.space;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public boolean need_repair() {
        return this.need_repair;
    }

    @Override
    public boolean can_repair() {
        return this.can_repair;
    }

    @Override
    public int getMinWind() {
        return this.mind_wind;
    }

    @Override
    public int getMinWindSpeed() {
        return this.mind_speed;
    }

    public ContainerBaseWaterGenerator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBaseWaterGenerator(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiBaseWaterGenerator(this.getGuiContainer(entityPlayer));
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (this.tick >= 20) {
            WindSystem.windSystem.getNewFacing(this.getFacing(), this);
            this.tick = 0;
            if (this.getAuto()) {
                WindSystem.windSystem.getNewPositionOfMechanism(this);
            }
        }
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }
}

