/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.quantum_storage;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.gui.IType;
import com.denfop.api.sytem.EnergyType;
import com.denfop.blocks.BlockResource;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerQuantumStorage;
import com.denfop.gui.GuiQuantumStorage;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityQuantumStorage
extends TileEntityInventory
implements IType {
    public final ComponentBaseEnergy qe;
    private final EnumTypeStyle enumTypeStyle;

    public TileEntityQuantumStorage(double maxStorage1, EnumTypeStyle enumTypeStyle) {
        this.qe = this.addComponent(new ComponentBaseEnergy(EnergyType.QUANTUM, (TileEntityInventory)this, maxStorage1, Arrays.asList(EnumFacing.values()), Arrays.asList(EnumFacing.values()), EnergyNetGlobal.instance.getTierFromPower(14.0), EnergyNetGlobal.instance.getTierFromPower(14.0), false));
        this.enumTypeStyle = enumTypeStyle;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        double energy1 = nbt.func_74769_h("energy");
        tooltip.add(Localization.translate("iu.item.tooltip.Capacity") + " " + ModUtils.getString(this.qe.getCapacity()) + " QE");
        if (energy1 != 0.0) {
            tooltip.add(Localization.translate("iu.item.tooltip.Store") + " " + ModUtils.getString(energy1) + "/" + ModUtils.getString(this.qe.getCapacity()) + " QE");
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    ComponentBaseEnergy component2 = this.qe;
                    if (component2 != null && component2.getEnergy() != 0.0) {
                        NBTTagCompound nbt = ModUtils.nbt(drop);
                        nbt.func_74780_a("energy", component2.getEnergy());
                    }
                    return drop;
                }
                case None: {
                    return null;
                }
                case Generator: {
                    return new ItemStack((Block)IUItem.basemachine2, 1, 78);
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: 
            }
            return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
        }
        ComponentBaseEnergy component2 = this.qe;
        if (component2 != null && component2.getEnergy() != 0.0) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            nbt.func_74780_a("energy", component2.getEnergy());
        }
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        double energy1 = nbt.func_74769_h("energy");
        if (energy1 != 0.0) {
            this.qe.addEnergy(energy1);
        }
    }

    public ContainerQuantumStorage getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerQuantumStorage(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiQuantumStorage(this.getGuiContainer(entityPlayer));
    }

    @Override
    public EnumTypeStyle getStyle() {
        return this.enumTypeStyle;
    }
}

